/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.commonarchivecore.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.GenericArchiveTypeDiscriminator;

public class ArchiveTypeDiscriminatorRegistry {
    private Collection discriminators = null;
    private Collection customTypes = null;
    private static final String[] defaultKnownTypes = new String[]{"ear", "war", "jar", "zip", "far"};
    public static final ArchiveTypeDiscriminatorRegistry INSTANCE = new ArchiveTypeDiscriminatorRegistry();

    public static void registorDiscriminator(GenericArchiveTypeDiscriminator genericArchiveTypeDiscriminator) {
        INSTANCE.getDiscriminators().add(genericArchiveTypeDiscriminator);
        INSTANCE.addKnownArchiveTypes(genericArchiveTypeDiscriminator.getCustomFileExtensions());
    }

    public static ArchiveTypeDiscriminatorRegistry getInstance() {
        return INSTANCE;
    }

    public Collection getDiscriminators() {
        if (this.discriminators == null) {
            this.discriminators = new ArrayList();
        }
        return this.discriminators;
    }

    public void contributeTypes(Archive archive) {
        if (this.discriminators == null) {
            return;
        }
        GenericArchiveTypeDiscriminator genericArchiveTypeDiscriminator = null;
        Iterator iterator = this.discriminators.iterator();
        while (iterator.hasNext()) {
            genericArchiveTypeDiscriminator = (GenericArchiveTypeDiscriminator)iterator.next();
            if (!genericArchiveTypeDiscriminator.discriminate(archive)) continue;
            archive.getTypes().add(genericArchiveTypeDiscriminator.getTypeKey());
        }
    }

    public void addKnownArchiveTypes(String[] stringArray) {
        if (this.customTypes == null) {
            this.customTypes = new ArrayList();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            this.customTypes.add(stringArray[i]);
        }
    }

    public boolean isKnownArchiveType(String string) {
        String string2;
        if (string == null || string.length() == 0) {
            return false;
        }
        String string3 = string.toLowerCase();
        if (string3.length() > 4 && string3.charAt(string3.length() - 4) == '.') {
            string2 = string3.substring(string3.length() - 3);
            for (int i = 0; i < defaultKnownTypes.length; ++i) {
                if (!defaultKnownTypes[i].equals(string2)) continue;
                return true;
            }
        }
        string2 = null;
        if (this.customTypes != null) {
            Iterator iterator = this.customTypes.iterator();
            while (iterator.hasNext()) {
                string2 = (String)iterator.next();
                if (!string.endsWith(string2)) continue;
                return true;
            }
        }
        return false;
    }
}

