/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.common;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.Logger;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.osgi.framework.Bundle;

public abstract class EMFPlugin
implements ResourceLocator,
Logger {
    public static final boolean IS_ECLIPSE_RUNNING;
    protected ResourceLocator[] delegateResourceLocators;
    protected URL baseURL;
    protected ResourceBundle untranslatedResourceBundle;
    protected ResourceBundle resourceBundle;
    protected Map strings = new HashMap();
    protected Map untranslatedStrings = new HashMap();
    protected boolean shouldTranslate = true;
    protected Map images = new HashMap();
    private static final URI DOT;
    static /* synthetic */ Class class$0;

    static {
        boolean result = false;
        try {
            result = Platform.isRunning();
        }
        catch (Throwable throwable) {}
        IS_ECLIPSE_RUNNING = result;
        DOT = URI.createURI(".");
    }

    public EMFPlugin(ResourceLocator[] delegateResourceLocators) {
        this.delegateResourceLocators = delegateResourceLocators;
    }

    public abstract ResourceLocator getPluginResourceLocator();

    public Logger getPluginLogger() {
        return (Logger)((Object)this.getPluginResourceLocator());
    }

    public String getSymbolicName() {
        ResourceLocator resourceLocator = this.getPluginResourceLocator();
        if (resourceLocator instanceof InternalEclipsePlugin) {
            return ((InternalEclipsePlugin)((Object)resourceLocator)).getSymbolicName();
        }
        String result = this.getClass().getName();
        return result.substring(0, result.lastIndexOf(46));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public URL getBaseURL() {
        if (this.baseURL != null) return this.baseURL;
        if (this.getPluginResourceLocator() == null) {
            try {
                Class<?> theClass = this.getClass();
                URL pluginPropertiesURL = theClass.getResource("plugin.properties");
                if (pluginPropertiesURL == null) {
                    String className = theClass.getName();
                    int index = className.lastIndexOf(".");
                    URL classURL = theClass.getResource(String.valueOf(index == -1 ? className : className.substring(index + 1)) + ".class");
                    URI uri = URI.createURI(classURL.toString());
                    int count = 1;
                    int i = 0;
                    while ((i = className.indexOf(46, i)) != -1) {
                        ++count;
                        ++i;
                    }
                    if (URI.isArchiveScheme((uri = uri.trimSegments(count)).scheme())) {
                        try {
                            InputStream inputStream = new URL(uri.appendSegment("plugin.properties").toString()).openStream();
                            inputStream.close();
                            this.baseURL = new URL(uri.toString());
                        }
                        catch (IOException iOException) {
                            uri = URI.createURI(uri.authority()).trimSegments(1);
                        }
                    }
                    if (this.baseURL == null) {
                        String lastSegment = uri.lastSegment();
                        if ("bin".equals(lastSegment) || "runtime".equals(lastSegment)) {
                            uri = uri.trimSegments(1);
                        }
                        uri = uri.appendSegment("plugin.properties");
                        try {
                            InputStream inputStream = new URL(uri.toString()).openStream();
                            inputStream.close();
                            this.baseURL = new URL(DOT.resolve(uri).toString());
                        }
                        catch (IOException iOException) {}
                    }
                    if (this.baseURL != null) return this.baseURL;
                    String resourceName = index == -1 ? "plugin.properties" : String.valueOf(className.substring(0, index + 1).replace('.', '/')) + "plugin.properties";
                    throw new MissingResourceException("Missing properties: " + resourceName, theClass.getName(), "plugin.properties");
                }
                this.baseURL = new URL(DOT.resolve(URI.createURI(pluginPropertiesURL.toString())).toString());
                return this.baseURL;
            }
            catch (IOException exception) {
                throw new WrappedException(exception);
            }
        }
        this.baseURL = this.getPluginResourceLocator().getBaseURL();
        return this.baseURL;
    }

    public Object getImage(String key) {
        Object result = (URL)this.images.get(key);
        if (result == null) {
            if (this.getPluginResourceLocator() == null) {
                try {
                    result = this.doGetImage(key);
                }
                catch (MalformedURLException exception) {
                    throw new WrappedException(exception);
                }
                catch (IOException iOException) {
                    result = this.delegatedGetImage(key);
                }
            } else {
                try {
                    result = this.getPluginResourceLocator().getImage(key);
                }
                catch (MissingResourceException missingResourceException) {
                    result = this.delegatedGetImage(key);
                }
            }
            this.images.put(key, result);
        }
        return result;
    }

    protected Object doGetImage(String key) throws IOException {
        URL url = new URL(this.getBaseURL() + "icons/" + key + ".gif");
        InputStream inputStream = url.openStream();
        inputStream.close();
        return url;
    }

    protected Object delegatedGetImage(String key) throws MissingResourceException {
        int i = 0;
        while (i < this.delegateResourceLocators.length) {
            try {
                return this.delegateResourceLocators[i].getImage(key);
            }
            catch (MissingResourceException missingResourceException) {
                ++i;
            }
        }
        throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_ImageResourceNotFound_exception", new Object[]{key}), this.getClass().getName(), key);
    }

    public boolean shouldTranslate() {
        return this.shouldTranslate;
    }

    public void setShouldTranslate(boolean shouldTranslate) {
        this.shouldTranslate = shouldTranslate;
    }

    public String getString(String key) {
        return this.getString(key, this.shouldTranslate());
    }

    /*
     * Unable to fully structure code
     */
    public String getString(String key, boolean translate) {
        stringMap = translate != false ? this.strings : this.untranslatedStrings;
        result = (String)stringMap.get(key);
        if (result == null) {
            block14: {
                try {
                    if (this.getPluginResourceLocator() == null) {
                        v0 = bundle = translate != false ? this.resourceBundle : this.untranslatedResourceBundle;
                        if (bundle == null) {
                            packageName = this.getClass().getName();
                            index = packageName.lastIndexOf(".");
                            if (index != -1) {
                                packageName = packageName.substring(0, index);
                            }
                            if (translate) {
                                try {
                                    bundle = this.resourceBundle = ResourceBundle.getBundle(String.valueOf(packageName) + ".plugin");
                                }
                                catch (MissingResourceException exception) {
                                    try {
                                        inputStream = new URL(String.valueOf(this.getBaseURL().toString()) + "plugin.properties").openStream();
                                        this.untranslatedResourceBundle = this.resourceBundle = new PropertyResourceBundle(inputStream);
                                        bundle = this.resourceBundle;
                                        inputStream.close();
                                    }
                                    catch (IOException v1) {}
                                    if (this.resourceBundle != null) ** GOTO lbl34
                                    throw exception;
                                }
                            } else {
                                resourceName = String.valueOf(this.getBaseURL().toString()) + "plugin.properties";
                                try {
                                    inputStream = new URL(resourceName).openStream();
                                    bundle = this.untranslatedResourceBundle = new PropertyResourceBundle(inputStream);
                                    inputStream.close();
                                }
                                catch (IOException v2) {
                                    throw new MissingResourceException("Missing properties: " + resourceName, this.getClass().getName(), "plugin.properties");
                                }
                            }
                        }
lbl34:
                        // 5 sources

                        result = bundle.getString(key);
                        break block14;
                    }
                    result = this.getPluginResourceLocator().getString(key, translate);
                }
                catch (MissingResourceException v3) {
                    result = this.delegatedGetString(key, translate);
                }
            }
            stringMap.put(key, result);
        }
        return result;
    }

    protected String delegatedGetString(String key, boolean translate) {
        int i = 0;
        while (i < this.delegateResourceLocators.length) {
            try {
                return this.delegateResourceLocators[i].getString(key, translate);
            }
            catch (MissingResourceException missingResourceException) {
                ++i;
            }
        }
        throw new MissingResourceException(MessageFormat.format("The string resource ''{0}'' could not be located", key), this.getClass().getName(), key);
    }

    public String getString(String key, Object[] substitutions) {
        return this.getString(key, substitutions, this.shouldTranslate());
    }

    public String getString(String key, Object[] substitutions, boolean translate) {
        return MessageFormat.format(this.getString(key, translate), substitutions);
    }

    public void log(Object logEntry) {
        Logger logger = this.getPluginLogger();
        if (logger == null) {
            if (logEntry instanceof Throwable) {
                ((Throwable)logEntry).printStackTrace(System.err);
            } else {
                System.err.println(logEntry);
            }
        } else {
            logger.log(logEntry);
        }
    }

    public static void main(String[] args) {
        try {
            Manifest manifest;
            String symbolicName;
            Class<?> clazz;
            String[] relativePath = new String[]{"META-INF", "MANIFEST.MF"};
            if (args.length > 0) {
                clazz = Class.forName(args[0]);
            } else {
                clazz = class$0;
                if (clazz == null) {
                    try {
                        class$0 = Class.forName("org.eclipse.emf.common.EMFPlugin");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                    clazz = class$0;
                }
            }
            Class<?> theClass = clazz;
            String className = theClass.getName();
            int index = className.lastIndexOf(".");
            URL classURL = theClass.getResource(String.valueOf(index == -1 ? className : className.substring(index + 1)) + ".class");
            URI uri = URI.createURI(classURL.toString());
            int count = 1;
            int i = 0;
            while ((i = className.indexOf(46, i)) != -1) {
                ++count;
                ++i;
            }
            uri = uri.trimSegments(count);
            URL manifestURL = null;
            if (URI.isArchiveScheme(uri.scheme())) {
                try {
                    String manifestURI = uri.appendSegments(relativePath).toString();
                    InputStream inputStream = new URL(manifestURI).openStream();
                    inputStream.close();
                    manifestURL = new URL(manifestURI);
                }
                catch (IOException iOException) {
                    uri = URI.createURI(uri.authority()).trimSegments(1);
                }
            }
            if (manifestURL == null) {
                String lastSegment = uri.lastSegment();
                if ("bin".equals(lastSegment) || "runtime".equals(lastSegment)) {
                    uri = uri.trimSegments(1);
                }
                uri = uri.appendSegments(relativePath);
                manifestURL = new URL(uri.toString());
            }
            if (manifestURL != null && (symbolicName = (manifest = new Manifest(manifestURL.openStream())).getMainAttributes().getValue("Bundle-SymbolicName")) != null) {
                int end = symbolicName.indexOf(";");
                if (end != -1) {
                    symbolicName = symbolicName.substring(0, end);
                }
                System.out.println("Bundle-SymbolicName=" + symbolicName + " Bundle-Version=" + manifest.getMainAttributes().getValue("Bundle-Version"));
                return;
            }
        }
        catch (Exception exception) {}
        System.err.println("No Bundle information found");
    }

    public static abstract class EclipsePlugin
    extends Plugin
    implements ResourceLocator,
    Logger,
    InternalEclipsePlugin {
        protected InternalHelper helper = new InternalHelper(this);

        public EclipsePlugin() {
        }

        public EclipsePlugin(IPluginDescriptor descriptor) {
            super(descriptor);
        }

        public String getSymbolicName() {
            return this.helper.getSymbolicName();
        }

        public URL getBaseURL() {
            return this.helper.getBaseURL();
        }

        public Object getImage(String key) {
            try {
                return this.doGetImage(key);
            }
            catch (MalformedURLException exception) {
                throw new WrappedException(exception);
            }
            catch (IOException iOException) {
                throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_StringResourceNotFound_exception", new Object[]{key}), this.getClass().getName(), key);
            }
        }

        protected Object doGetImage(String key) throws IOException {
            return this.helper.getImage(key);
        }

        public String getString(String key) {
            return this.helper.getString(key, true);
        }

        public String getString(String key, boolean translate) {
            return this.helper.getString(key, translate);
        }

        public String getString(String key, Object[] substitutions) {
            return this.helper.getString(key, substitutions, true);
        }

        public String getString(String key, Object[] substitutions, boolean translate) {
            return this.helper.getString(key, substitutions, translate);
        }

        public void log(Object logEntry) {
            this.helper.log(logEntry);
        }
    }

    public static interface InternalEclipsePlugin {
        public String getSymbolicName();
    }

    public static class InternalHelper {
        protected Plugin plugin;
        protected ResourceBundle resourceBundle;
        protected ResourceBundle untranslatedResourceBundle;

        public InternalHelper(Plugin plugin) {
            this.plugin = plugin;
        }

        protected Bundle getBundle() {
            return this.plugin.getBundle();
        }

        protected ILog getLog() {
            return this.plugin.getLog();
        }

        public String getSymbolicName() {
            return this.getBundle().getSymbolicName();
        }

        public URL getBaseURL() {
            return this.getBundle().getEntry("/");
        }

        public Object getImage(String key) throws IOException {
            URL url = new URL(this.getBaseURL() + "icons/" + key + ".gif");
            InputStream inputStream = url.openStream();
            inputStream.close();
            return url;
        }

        public String getString(String key, boolean translate) {
            ResourceBundle bundle;
            ResourceBundle resourceBundle = bundle = translate ? this.resourceBundle : this.untranslatedResourceBundle;
            if (bundle == null) {
                if (translate) {
                    bundle = this.resourceBundle = Platform.getResourceBundle(this.getBundle());
                } else {
                    String resourceName = String.valueOf(this.getBaseURL().toString()) + "plugin.properties";
                    try {
                        InputStream inputStream = new URL(resourceName).openStream();
                        bundle = this.untranslatedResourceBundle = new PropertyResourceBundle(inputStream);
                        inputStream.close();
                    }
                    catch (IOException iOException) {
                        throw new MissingResourceException("Missing properties: " + resourceName, this.getClass().getName(), "plugin.properties");
                    }
                }
            }
            return bundle.getString(key);
        }

        public String getString(String key, Object[] substitutions, boolean translate) {
            return MessageFormat.format(this.getString(key, translate), substitutions);
        }

        public void log(Object logEntry) {
            if (logEntry instanceof IStatus) {
                IStatus status = (IStatus)logEntry;
                this.getLog().log(status);
            } else {
                if (logEntry == null) {
                    logEntry = new RuntimeException(this.getString("_UI_NullLogEntry_exception", true)).fillInStackTrace();
                }
                if (logEntry instanceof Throwable) {
                    Throwable throwable = (Throwable)logEntry;
                    String message = throwable.getLocalizedMessage();
                    if (message == null) {
                        message = "";
                    }
                    this.getLog().log(new Status(2, this.getBundle().getSymbolicName(), 0, message, throwable));
                } else {
                    this.getLog().log(new Status(2, this.getBundle().getSymbolicName(), 0, logEntry.toString(), null));
                }
            }
        }
    }
}

