/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.runtime.internal.adaptor;

import java.io.File;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.runtime.internal.adaptor.ClasspathManifest;
import org.eclipse.core.runtime.internal.adaptor.EclipseEnvironmentInfo;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.internal.baseadaptor.BaseClassLoadingHook;
import org.eclipse.osgi.internal.baseadaptor.BaseStorageHook;

public class EclipseClassLoadingHook
implements ClassLoadingHook,
HookConfigurator {
    private static String[] NL_JAR_VARIANTS = EclipseClassLoadingHook.buildNLJarVariants(EclipseEnvironmentInfo.getDefault().getNL());
    private static boolean DEFINE_PACKAGES;
    private static String[] LIB_VARIANTS;

    static {
        LIB_VARIANTS = EclipseClassLoadingHook.buildLibraryVariants();
        try {
            Class.forName("java.lang.Package");
            DEFINE_PACKAGES = true;
        }
        catch (ClassNotFoundException e) {
            DEFINE_PACKAGES = false;
        }
    }

    private static String[] buildLibraryVariants() {
        ArrayList<String> result = new ArrayList<String>();
        EclipseEnvironmentInfo info = EclipseEnvironmentInfo.getDefault();
        result.add("ws/" + info.getWS() + "/");
        result.add("os/" + info.getOS() + "/" + info.getOSArch() + "/");
        result.add("os/" + info.getOS() + "/");
        String nl = info.getNL();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    public byte[] processClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
        Manifest mf;
        if (!DEFINE_PACKAGES) {
            return null;
        }
        int lastIndex = name.lastIndexOf(46);
        if (lastIndex < 0) {
            return null;
        }
        String packageName = name.substring(0, lastIndex);
        Package pkg = (Package)manager.getBaseClassLoader().publicGetPackage(packageName);
        if (pkg != null) {
            return null;
        }
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        ClasspathManifest cpm = (ClasspathManifest)classpathEntry.getUserObject(ClasspathManifest.KEY);
        if (cpm == null) {
            cpm = new ClasspathManifest();
            classpathEntry.addUserObject(cpm);
        }
        if ((mf = cpm.getManifest(classpathEntry, manager)) != null) {
            Attributes mainAttributes = mf.getMainAttributes();
            String dirName = String.valueOf(packageName.replace('.', '/')) + '/';
            Attributes packageAttributes = mf.getAttributes(dirName);
            boolean noEntry = false;
            if (packageAttributes == null) {
                noEntry = true;
                packageAttributes = mainAttributes;
            }
            if ((specTitle = packageAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE)) == null && !noEntry) {
                specTitle = mainAttributes.getValue(Attributes.Name.SPECIFICATION_TITLE);
            }
            if ((specVersion = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION)) == null && !noEntry) {
                specVersion = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VERSION);
            }
            if ((specVendor = packageAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR)) == null && !noEntry) {
                specVendor = mainAttributes.getValue(Attributes.Name.SPECIFICATION_VENDOR);
            }
            if ((implTitle = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE)) == null && !noEntry) {
                implTitle = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE);
            }
            if ((implVersion = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION)) == null && !noEntry) {
                implVersion = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION);
            }
            if ((implVendor = packageAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR)) == null && !noEntry) {
                implVendor = mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VENDOR);
            }
        }
        manager.getBaseClassLoader().publicDefinePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
        return null;
    }

    public boolean addClassPathEntry(ArrayList cpEntries, String cp, ClasspathManager hostmanager, BaseData sourcedata, ProtectionDomain sourcedomain) {
        ClasspathEntry cpEntry;
        String var = EclipseClassLoadingHook.hasPrefix(cp);
        if (var != null) {
            return this.addInternalClassPath(var, cpEntries, cp, hostmanager, sourcedata, sourcedomain);
        }
        if (cp.startsWith("external:") && (cpEntry = hostmanager.getExternalClassPath(BaseStorageHook.substituteVars(cp = cp.substring("external:".length())), sourcedata, sourcedomain)) != null) {
            cpEntries.add(cpEntry);
            return true;
        }
        return false;
    }

    private boolean addInternalClassPath(String var, ArrayList cpEntries, String cp, ClasspathManager hostloader, BaseData sourcedata, ProtectionDomain sourcedomain) {
        if (var.equals("ws")) {
            return ClasspathManager.addClassPathEntry(cpEntries, "ws/" + EclipseEnvironmentInfo.getDefault().getWS() + cp.substring(4), hostloader, sourcedata, sourcedomain);
        }
        if (var.equals("os")) {
            return ClasspathManager.addClassPathEntry(cpEntries, "os/" + EclipseEnvironmentInfo.getDefault().getOS() + cp.substring(4), hostloader, sourcedata, sourcedomain);
        }
        if (var.equals("nl")) {
            cp = cp.substring(4);
            int i = 0;
            while (i < NL_JAR_VARIANTS.length) {
                if (ClasspathManager.addClassPathEntry(cpEntries, "nl/" + NL_JAR_VARIANTS[i] + cp, hostloader, sourcedata, sourcedomain)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static String hasPrefix(String libPath) {
        if (libPath.startsWith("$ws$")) {
            return "ws";
        }
        if (libPath.startsWith("$os$")) {
            return "os";
        }
        if (libPath.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    private static String[] buildNLJarVariants(String nl) {
        ArrayList<String> result = new ArrayList<String>();
        nl = nl.replace('_', '/');
        while (nl.length() > 0) {
            result.add("nl/" + nl + "/");
            int i = nl.lastIndexOf(47);
            String string = nl = i < 0 ? "" : nl.substring(0, i);
        }
        result.add("");
        return result.toArray(new String[result.size()]);
    }

    public void recordClassDefine(String name, Class clazz, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager manager) {
    }

    public String findLibrary(BaseData data, String libName) {
        String mappedLibName;
        String result;
        if (libName.length() == 0) {
            return null;
        }
        if (libName.charAt(0) == '/' || libName.charAt(0) == '\\') {
            libName = libName.substring(1);
        }
        if ((result = this.searchVariants(data, mappedLibName = System.mapLibraryName(libName))) != null) {
            return result;
        }
        String[] mappedLibNames = BaseClassLoadingHook.mapLibraryNames(mappedLibName);
        int i = 0;
        while (i < mappedLibNames.length && result == null) {
            result = this.searchVariants(data, mappedLibNames[i]);
            ++i;
        }
        return result;
    }

    private String searchVariants(BaseData bundledata, String path) {
        int i = 0;
        while (i < LIB_VARIANTS.length) {
            BundleFile baseBundleFile = bundledata.getBundleFile();
            BundleEntry libEntry = baseBundleFile.getEntry(String.valueOf(LIB_VARIANTS[i]) + path);
            if (libEntry != null) {
                File libFile = baseBundleFile.getFile(String.valueOf(LIB_VARIANTS[i]) + path, true);
                if (libFile == null) {
                    return null;
                }
                if ("hpux".equals(EclipseEnvironmentInfo.getDefault().getOS())) {
                    try {
                        Runtime.getRuntime().exec(new String[]{"chmod", "755", libFile.getAbsolutePath()}).waitFor();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                return libFile.getAbsolutePath();
            }
            ++i;
        }
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public void addHooks(HookRegistry hookRegistry) {
        hookRegistry.addClassLoadingHook(this);
    }

    public BaseClassLoader createClassLoader(ClassLoader parent, ClassLoaderDelegate delegate, BundleProtectionDomain domain, BaseData data, String[] bundleclasspath) {
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData data) {
    }
}

