/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.annogen.view.internal;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.codehaus.annogen.generate.AnnogenInfo;
import org.codehaus.annogen.override.AnnoBean;
import org.codehaus.annogen.override.AnnoBeanSet;
import org.codehaus.annogen.view.internal.reflect.ReflectAnnogenTigerDelegate;

public final class ReflectAnnogenTigerDelegateImpl_150
extends ReflectAnnogenTigerDelegate {
    public Class getAnnogenInfo_annoBeanClass(Class a175class) throws ClassNotFoundException {
        if (!a175class.isAnnotation()) {
            throw new IllegalArgumentException("Requested type is not an Annotation: " + a175class.getName());
        }
        AnnogenInfo info = a175class.getAnnotation(AnnogenInfo.class);
        if (info == null) {
            throw new ClassNotFoundException("Missing @AnnogenInfo on specified class " + a175class.getName());
        }
        return a175class.getClassLoader().loadClass(info.annoBeanClass());
    }

    public Class getAnnotationClassFor(Object annotation2) {
        return ((Annotation)annotation2).annotationType();
    }

    public boolean extractAnnotations(AnnoBeanSet out, Package on) {
        return this.doExtract(out, on.getAnnotations());
    }

    public boolean extractAnnotations(AnnoBeanSet out, Class on) {
        return this.doExtract(out, on.getAnnotations());
    }

    public boolean extractAnnotations(AnnoBeanSet out, Method on) {
        return this.doExtract(out, on.getAnnotations());
    }

    public boolean extractAnnotations(AnnoBeanSet out, Field on) {
        return this.doExtract(out, on.getAnnotations());
    }

    public boolean extractAnnotations(AnnoBeanSet out, Constructor on) {
        return this.doExtract(out, on.getAnnotations());
    }

    public boolean extractAnnotations(AnnoBeanSet out, Method on, int pnum) {
        Annotation[][] raw = on.getParameterAnnotations();
        if (out == null || raw.length <= pnum) {
            return false;
        }
        return this.doExtract(out, raw[pnum]);
    }

    public boolean extractAnnotations(AnnoBeanSet out, Constructor on, int pnum) {
        Annotation[][] raw = on.getParameterAnnotations();
        if (out == null || raw.length <= pnum) {
            return false;
        }
        return this.doExtract(out, raw[pnum]);
    }

    public Class getAnnogenInfoClass() {
        return AnnogenInfo.class;
    }

    private boolean doExtract(AnnoBeanSet out, Object[] raw) {
        if (raw == null || raw.length == 0) {
            return false;
        }
        for (int i = 0; i < raw.length; ++i) {
            Class declClass = this.getAnnotationClassFor(raw[i]);
            AnnoBean proxy = out.findOrCreateBeanFor(declClass);
            this.copyValues(raw[i], proxy, declClass);
        }
        return true;
    }

    private void copyValues(Object src, AnnoBean dest, Class declaredClass) {
        boolean isVerbose = false;
        if (src == null) {
            throw new IllegalArgumentException();
        }
        if (isVerbose) {
            this.mLogger.verbose("type is " + declaredClass.getName());
        }
        Method[] methods = declaredClass.getMethods();
        for (int i = 0; i < methods.length; ++i) {
            Object value;
            Class<?> c;
            int mods;
            if (isVerbose) {
                this.mLogger.verbose("examining " + methods[i].toString());
            }
            if (Modifier.isStatic(mods = methods[i].getModifiers()) || !Modifier.isPublic(mods) || methods[i].getParameterTypes().length > 0 || Object.class.equals(c = methods[i].getDeclaringClass())) continue;
            if (isVerbose) {
                this.mLogger.verbose("invoking " + methods[i].getName() + "()");
            }
            try {
                value = methods[i].invoke(src, (Object[])null);
            }
            catch (IllegalAccessException e) {
                this.mLogger.error(e);
                continue;
            }
            catch (InvocationTargetException e) {
                this.mLogger.error(e);
                continue;
            }
            if (isVerbose) {
                this.mLogger.verbose("value is " + value);
            }
            Class<?> valClass = value.getClass();
            try {
                if (!this.isSimpleType(valClass)) {
                    if (valClass.isArray()) {
                        if (this.isSimpleType(valClass.getComponentType())) {
                            // empty if block
                        }
                        throw new IllegalArgumentException("array annotation properties NYI");
                    }
                    throw new IllegalArgumentException("complex annotation properties NYI " + valClass.getName());
                }
                dest.setValue(methods[i].getName(), value);
                continue;
            }
            catch (Exception fixme) {
                this.mLogger.error(fixme);
            }
        }
    }

    private boolean isSimpleType(Class c) {
        return c.isPrimitive() || String.class.equals((Object)c) || Number.class.isAssignableFrom(c) || Boolean.class.equals((Object)c) || Class.class.equals((Object)c);
    }
}

