/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlbeans.impl.store;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;

public final class SaxonXBeansDelegate {
    protected static boolean _saxonAvailable = true;
    private static Constructor _constructor;
    private static Constructor _xqConstructor;

    private SaxonXBeansDelegate() {
    }

    static void init() {
        Class<?> saxonXPathImpl = null;
        Class<?> saxonXQueryImpl = null;
        try {
            saxonXPathImpl = Class.forName("org.apache.xmlbeans.impl.xpath.saxon.XBeansXPath");
            saxonXQueryImpl = Class.forName("org.apache.xmlbeans.impl.xquery.saxon.XBeansXQuery");
        }
        catch (ClassNotFoundException e) {
            _saxonAvailable = false;
        }
        catch (NoClassDefFoundError e) {
            _saxonAvailable = false;
        }
        if (_saxonAvailable) {
            try {
                _constructor = saxonXPathImpl.getConstructor(String.class, Map.class, String.class);
                _xqConstructor = saxonXQueryImpl.getConstructor(String.class, String.class, Integer.class);
            }
            catch (Exception e) {
                _saxonAvailable = false;
                throw new RuntimeException(e);
            }
        }
    }

    static SelectPathInterface createInstance(String xpath2, Map namespaceMap) {
        if (_saxonAvailable && _constructor == null) {
            SaxonXBeansDelegate.init();
        }
        if (_constructor == null) {
            return null;
        }
        try {
            Object defaultNS = namespaceMap.get("$xmlbeans!default_uri");
            if (defaultNS != null) {
                namespaceMap.remove("$xmlbeans!default_uri");
            }
            return (SelectPathInterface)_constructor.newInstance(xpath2, namespaceMap, (String)defaultNS);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static QueryInterface createQueryInstance(String query, String contextVar, int boundary) {
        if (_saxonAvailable && _xqConstructor == null) {
            SaxonXBeansDelegate.init();
        }
        if (_xqConstructor == null) {
            return null;
        }
        try {
            return (QueryInterface)_xqConstructor.newInstance(query, contextVar, new Integer(boundary));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static interface QueryInterface {
        public List execQuery(Object var1, Map var2);
    }

    public static interface SelectPathInterface {
        public List selectPath(Object var1);
    }
}

