/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.ws.java2wsdl.Java2WSDLConstants;
import org.apache.ws.java2wsdl.utils.Java2WSDLCommandLineOption;
import org.apache.ws.java2wsdl.utils.Java2WSDLOptionsValidator;

public class Java2WSDLCommandLineOptionParser
implements Java2WSDLConstants {
    private static int STARTED = 0;
    private static int NEW_OPTION = 1;
    private static int SUB_PARAM_OF_OPTION = 2;
    private Map commandLineOptions;

    public Java2WSDLCommandLineOptionParser(Map commandLineOptions) {
        this.commandLineOptions = commandLineOptions;
    }

    public Java2WSDLCommandLineOptionParser(String[] args) {
        this.commandLineOptions = this.parse(args);
    }

    private Map parse(String[] args) {
        Java2WSDLCommandLineOption commandLineOption;
        HashMap<String, Java2WSDLCommandLineOption> commandLineOptions = new HashMap<String, Java2WSDLCommandLineOption>();
        if (0 == args.length) {
            return commandLineOptions;
        }
        int state = STARTED;
        ArrayList<String> optionBundle = null;
        String optionType = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith("-")) {
                if (STARTED == state) {
                    state = NEW_OPTION;
                    optionType = args[i];
                    continue;
                }
                if (SUB_PARAM_OF_OPTION != state && NEW_OPTION != state) continue;
                commandLineOption = new Java2WSDLCommandLineOption(optionType, optionBundle);
                commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
                state = NEW_OPTION;
                optionType = args[i];
                optionBundle = null;
                continue;
            }
            if (STARTED == state) {
                commandLineOption = new Java2WSDLCommandLineOption("SOLE_INPUT", args);
                commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
                return commandLineOptions;
            }
            if (NEW_OPTION == state) {
                optionBundle = new ArrayList<String>();
                optionBundle.add(args[i]);
                state = SUB_PARAM_OF_OPTION;
                continue;
            }
            if (SUB_PARAM_OF_OPTION != state) continue;
            optionBundle.add(args[i]);
        }
        commandLineOption = new Java2WSDLCommandLineOption(optionType, optionBundle);
        commandLineOptions.put(commandLineOption.getOptionType(), commandLineOption);
        return commandLineOptions;
    }

    public Map getAllOptions() {
        return this.commandLineOptions;
    }

    public List getInvalidOptions(Java2WSDLOptionsValidator validator) {
        ArrayList<Java2WSDLCommandLineOption> faultList = new ArrayList<Java2WSDLCommandLineOption>();
        Iterator iterator = this.commandLineOptions.values().iterator();
        while (iterator.hasNext()) {
            Java2WSDLCommandLineOption commandLineOption = (Java2WSDLCommandLineOption)iterator.next();
            if (!validator.isInvalid(commandLineOption)) continue;
            faultList.add(commandLineOption);
        }
        return faultList;
    }
}

