/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaCollection;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaForm;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.utils.NamespaceMap;
import org.apache.ws.java2wsdl.DefaultNamespaceGenerator;
import org.apache.ws.java2wsdl.Java2WSDLConstants;
import org.apache.ws.java2wsdl.Java2WSDLUtils;
import org.apache.ws.java2wsdl.NamespaceGenerator;
import org.apache.ws.java2wsdl.bytecode.MethodTable;
import org.apache.ws.java2wsdl.utils.TypeTable;
import org.codehaus.jam.JAnnotation;
import org.codehaus.jam.JClass;
import org.codehaus.jam.JMethod;
import org.codehaus.jam.JPackage;
import org.codehaus.jam.JParameter;
import org.codehaus.jam.JProperty;
import org.codehaus.jam.JamClassIterator;
import org.codehaus.jam.JamService;
import org.codehaus.jam.JamServiceFactory;
import org.codehaus.jam.JamServiceParams;

public class SchemaGenerator
implements Java2WSDLConstants {
    public static final String NAME_SPACE_PREFIX = "ax2";
    private static int prefixCount = 1;
    protected Map targetNamespacePrefixMap = new Hashtable();
    protected Map schemaMap = new Hashtable();
    protected XmlSchemaCollection xmlSchemaCollection = new XmlSchemaCollection();
    private ClassLoader classLoader;
    private String className;
    private TypeTable typeTable = new TypeTable();
    private JMethod[] methods;
    private MethodTable methodTable;
    private String schemaTargetNameSpace;
    private String schema_namespace_prefix;
    private String attrFormDefault = null;
    private String elementFormDefault = null;
    private ArrayList excludeMethods = new ArrayList();
    private ArrayList extraClasses = null;
    private boolean useWSDLTypesNamespace = false;
    private Map pkg2nsmap = null;
    private NamespaceGenerator nsGen = null;
    private String targetNamespace = null;
    private ArrayList nonRpcMethods = new ArrayList();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;

    public NamespaceGenerator getNsGen() throws Exception {
        if (this.nsGen == null) {
            this.nsGen = new DefaultNamespaceGenerator();
        }
        return this.nsGen;
    }

    public void setNsGen(NamespaceGenerator nsGen) {
        this.nsGen = nsGen;
    }

    public SchemaGenerator(ClassLoader loader, String className, String schematargetNamespace, String schematargetNamespacePrefix) throws Exception {
        this.classLoader = loader;
        this.className = className;
        Class<?> clazz = Class.forName(className, true, loader);
        this.methodTable = new MethodTable(clazz);
        this.targetNamespace = Java2WSDLUtils.targetNamespaceFromClassName(className, loader, this.getNsGen()).toString();
        this.schemaTargetNameSpace = schematargetNamespace != null && schematargetNamespace.trim().length() != 0 ? schematargetNamespace : Java2WSDLUtils.schemaNamespaceFromClassName(className, loader, this.getNsGen()).toString();
        this.schema_namespace_prefix = schematargetNamespacePrefix != null && schematargetNamespacePrefix.trim().length() != 0 ? schematargetNamespacePrefix : "ns";
    }

    public Collection generateSchema() throws Exception {
        JamServiceFactory factory = JamServiceFactory.getInstance();
        JamServiceParams jam_service_parms = factory.createServiceParams();
        jam_service_parms.addClassLoader(this.classLoader);
        jam_service_parms.includeClass(this.className);
        for (int count = 0; count < this.getExtraClasses().size(); ++count) {
            jam_service_parms.includeClass((String)this.getExtraClasses().get(count));
        }
        JamService service = factory.createService(jam_service_parms);
        JamClassIterator jClassIter = service.getClasses();
        while (jClassIter.hasNext()) {
            JClass jclass = (JClass)jClassIter.next();
            if (this.getQualifiedName(jclass).equals(this.className)) {
                String tns;
                JAnnotation annotation2 = jclass.getAnnotation("javax.jws.WebService");
                if (annotation2 != null && (tns = annotation2.getValue("targetNamespace").asString()) != null && !"".equals(tns)) {
                    this.targetNamespace = tns;
                }
                this.methods = jclass.getDeclaredMethods();
                Arrays.sort(this.methods);
                HashMap<String, JMethod> uniqueMethods = new HashMap<String, JMethod>();
                XmlSchemaSequence sequence = null;
                for (int i = 0; i < this.methods.length; ++i) {
                    JClass returnType;
                    XmlSchemaComplexType methodSchemaType;
                    JMethod jMethod = this.methods[i];
                    JAnnotation methodAnnon = jMethod.getAnnotation("javax.jws.WebMethod");
                    if (methodAnnon != null && methodAnnon.getValue("exclude").asBoolean()) continue;
                    String methodName = this.getSimpleName(jMethod);
                    if (this.excludeMethods.contains(this.getSimpleName(jMethod))) continue;
                    if (uniqueMethods.get(this.getSimpleName(jMethod)) != null) {
                        throw new Exception(" Sorry we don't support methods overloading !!!! ");
                    }
                    if (!jMethod.isPublic()) continue;
                    if (jMethod.getExceptionTypes().length > 0) {
                        methodSchemaType = this.createSchemaTypeForMethodPart(this.getSimpleName(jMethod) + "Fault");
                        sequence = new XmlSchemaSequence();
                        XmlSchemaElement elt1 = new XmlSchemaElement();
                        elt1.setName(this.getSimpleName(jMethod) + "Fault");
                        elt1.setSchemaTypeName(this.typeTable.getQNamefortheType((class$java$lang$Object == null ? SchemaGenerator.class$("java.lang.Object") : class$java$lang$Object).getName()));
                        sequence.getItems().add(elt1);
                        methodSchemaType.setParticle(sequence);
                    }
                    uniqueMethods.put(this.getSimpleName(jMethod), jMethod);
                    uniqueMethods.put(this.getSimpleName(jMethod), jMethod);
                    JParameter[] paras = jMethod.getParameters();
                    String[] parameterNames = null;
                    if (paras.length > 0) {
                        parameterNames = this.methodTable.getParameterNames(methodName);
                        sequence = new XmlSchemaSequence();
                        methodSchemaType = this.createSchemaTypeForMethodPart(this.getSimpleName(jMethod));
                        methodSchemaType.setParticle(sequence);
                    }
                    for (int j = 0; j < paras.length; ++j) {
                        JParameter methodParameter = paras[j];
                        String parameterName = null;
                        JAnnotation paramterAnnon = methodParameter.getAnnotation("javax.jws.WebParam");
                        if (paramterAnnon != null) {
                            parameterName = paramterAnnon.getValue("name").asString();
                        }
                        if (parameterName == null || "".equals(parameterName)) {
                            parameterName = parameterNames != null && parameterNames[j] != null ? parameterNames[j] : this.getSimpleName(methodParameter);
                        }
                        JClass paraType = methodParameter.getType();
                        if (this.nonRpcMethods.contains(this.getSimpleName(jMethod))) {
                            this.generateSchemaForType(sequence, null, this.getSimpleName(jMethod));
                            break;
                        }
                        this.generateSchemaForType(sequence, paraType, parameterName);
                    }
                    if ((returnType = jMethod.getReturnType()).isVoidType()) continue;
                    methodSchemaType = this.createSchemaTypeForMethodPart(this.getSimpleName(jMethod) + "Response");
                    sequence = new XmlSchemaSequence();
                    methodSchemaType.setParticle(sequence);
                    JAnnotation returnAnnon = jMethod.getAnnotation("javax.jws.WebResult");
                    String returnName = "return";
                    if (returnAnnon != null && (returnName = returnAnnon.getValue("name").asString()) != null && !"".equals(returnName)) {
                        returnName = "return";
                    }
                    if (this.nonRpcMethods.contains(this.getSimpleName(jMethod))) {
                        this.generateSchemaForType(sequence, null, returnName);
                        continue;
                    }
                    this.generateSchemaForType(sequence, returnType, returnName);
                }
                continue;
            }
            QName extraSchemaTypeName = this.typeTable.getSimpleSchemaTypeName(this.getQualifiedName(jclass));
            if (extraSchemaTypeName != null) continue;
            this.generateSchema(jclass);
        }
        return this.schemaMap.values();
    }

    public static String getCorrectName(String wrongName) {
        if (wrongName.length() > 1) {
            return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH) + wrongName.substring(1, wrongName.length());
        }
        return wrongName.substring(0, 1).toLowerCase(Locale.ENGLISH);
    }

    private QName generateSchema(JClass javaType) throws Exception {
        String name = this.getQualifiedName(javaType);
        QName schemaTypeName = this.typeTable.getComplexSchemaType(name);
        if (schemaTypeName == null) {
            int i;
            String simpleName = this.getSimpleName(javaType);
            String packageName = this.getQualifiedName(javaType.getContainingPackage());
            String targetNameSpace = this.resolveSchemaNamespace(packageName);
            XmlSchema xmlSchema = this.getXmlSchema(targetNameSpace);
            String targetNamespacePrefix = (String)this.targetNamespacePrefixMap.get(targetNameSpace);
            XmlSchemaComplexType complexType2 = new XmlSchemaComplexType(xmlSchema);
            XmlSchemaSequence sequence = new XmlSchemaSequence();
            XmlSchemaElement eltOuter = new XmlSchemaElement();
            schemaTypeName = new QName(targetNameSpace, simpleName, targetNamespacePrefix);
            eltOuter.setName(simpleName);
            eltOuter.setQName(schemaTypeName);
            complexType2.setParticle(sequence);
            complexType2.setName(simpleName);
            xmlSchema.getItems().add(eltOuter);
            xmlSchema.getElements().add(schemaTypeName, eltOuter);
            eltOuter.setSchemaTypeName(complexType2.getQName());
            xmlSchema.getItems().add(complexType2);
            xmlSchema.getSchemaTypes().add(schemaTypeName, complexType2);
            this.typeTable.addComplexSchema(name, eltOuter.getQName());
            HashSet<JProperty> propertiesSet = new HashSet<JProperty>();
            for (JClass tempClass = javaType; tempClass != null && !"java.lang.Object".equals(this.getQualifiedName(tempClass)); tempClass = tempClass.getSuperclass()) {
                JProperty[] tempProperties = tempClass.getDeclaredProperties();
                for (i = 0; i < tempProperties.length; ++i) {
                    propertiesSet.add(tempProperties[i]);
                }
            }
            Object[] properties = propertiesSet.toArray(new JProperty[0]);
            Arrays.sort(properties);
            for (i = 0; i < properties.length; ++i) {
                XmlSchemaElement elt1;
                Object property = properties[i];
                String propertyName = this.getQualifiedName(property.getType());
                boolean isArryType = property.getType().isArrayType();
                if (isArryType) {
                    propertyName = this.getQualifiedName(property.getType().getArrayComponentType());
                }
                if (this.typeTable.isSimpleType(propertyName)) {
                    elt1 = new XmlSchemaElement();
                    elt1.setName(SchemaGenerator.getCorrectName(this.getSimpleName((JProperty)property)));
                    elt1.setSchemaTypeName(this.typeTable.getSimpleSchemaTypeName(propertyName));
                    sequence.getItems().add(elt1);
                    if (isArryType) {
                        elt1.setMaxOccurs(Long.MAX_VALUE);
                        elt1.setMinOccurs(1L);
                    }
                    if (!(class$java$lang$String == null ? SchemaGenerator.class$("java.lang.String") : class$java$lang$String).getName().equals(propertyName)) continue;
                    elt1.setNillable(true);
                    continue;
                }
                if (isArryType) {
                    this.generateSchema(property.getType().getArrayComponentType());
                } else {
                    this.generateSchema(property.getType());
                }
                elt1 = new XmlSchemaElement();
                elt1.setName(SchemaGenerator.getCorrectName(this.getSimpleName((JProperty)property)));
                elt1.setSchemaTypeName(this.typeTable.getComplexSchemaType(propertyName));
                sequence.getItems().add(elt1);
                if (isArryType) {
                    elt1.setMaxOccurs(Long.MAX_VALUE);
                    elt1.setMinOccurs(1L);
                }
                elt1.setNillable(true);
                if (((NamespaceMap)xmlSchema.getNamespaceContext()).values().contains(this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI())) continue;
                XmlSchemaImport importElement = new XmlSchemaImport();
                importElement.setNamespace(this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI());
                xmlSchema.getItems().add(importElement);
                ((NamespaceMap)xmlSchema.getNamespaceContext()).put(this.generatePrefix(), this.typeTable.getComplexSchemaType(propertyName).getNamespaceURI());
            }
        }
        return schemaTypeName;
    }

    private QName generateSchemaForType(XmlSchemaSequence sequence, JClass type, String partName) throws Exception {
        QName schemaTypeName;
        boolean isArrayType = false;
        if (type != null) {
            isArrayType = type.isArrayType();
        }
        if (isArrayType) {
            type = type.getArrayComponentType();
        }
        String classTypeName = type == null ? "java.lang.Object" : this.getQualifiedName(type);
        if (isArrayType && "byte".equals(classTypeName)) {
            classTypeName = "base64Binary";
            isArrayType = false;
        }
        if ((schemaTypeName = this.typeTable.getSimpleSchemaTypeName(classTypeName)) == null) {
            schemaTypeName = this.generateSchema(type);
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
            String schemaNamespace = this.resolveSchemaNamespace(this.getQualifiedName(type.getContainingPackage()));
            this.addImport(this.getXmlSchema(schemaNamespace), schemaTypeName);
        } else {
            this.addContentToMethodSchemaType(sequence, schemaTypeName, partName, isArrayType);
        }
        return schemaTypeName;
    }

    private void addContentToMethodSchemaType(XmlSchemaSequence sequence, QName schemaTypeName, String paraName, boolean isArray) {
        XmlSchemaElement elt1 = new XmlSchemaElement();
        elt1.setName(paraName);
        elt1.setSchemaTypeName(schemaTypeName);
        sequence.getItems().add(elt1);
        if (isArray) {
            elt1.setMaxOccurs(Long.MAX_VALUE);
            elt1.setMinOccurs(1L);
        }
        elt1.setNillable(true);
    }

    private XmlSchemaComplexType createSchemaTypeForMethodPart(String localPartName) {
        XmlSchema xmlSchema = this.getXmlSchema(this.schemaTargetNameSpace);
        QName elementName = new QName(this.schemaTargetNameSpace, localPartName, this.schema_namespace_prefix);
        XmlSchemaComplexType complexType2 = new XmlSchemaComplexType(xmlSchema);
        XmlSchemaElement globalElement = new XmlSchemaElement();
        globalElement.setSchemaType(complexType2);
        globalElement.setName(localPartName);
        globalElement.setQName(elementName);
        xmlSchema.getItems().add(globalElement);
        xmlSchema.getElements().add(elementName, globalElement);
        this.typeTable.addComplexSchema(localPartName, elementName);
        return complexType2;
    }

    private XmlSchema getXmlSchema(String targetNamespace) {
        XmlSchema xmlSchema = (XmlSchema)this.schemaMap.get(targetNamespace);
        if (xmlSchema == null) {
            String targetNamespacePrefix = null;
            targetNamespacePrefix = targetNamespace.equals(this.schemaTargetNameSpace) && this.schema_namespace_prefix != null ? this.schema_namespace_prefix : this.generatePrefix();
            xmlSchema = new XmlSchema(targetNamespace, this.xmlSchemaCollection);
            xmlSchema.setAttributeFormDefault(this.getAttrFormDefaultSetting());
            xmlSchema.setElementFormDefault(this.getElementFormDefaultSetting());
            this.targetNamespacePrefixMap.put(targetNamespace, targetNamespacePrefix);
            this.schemaMap.put(targetNamespace, xmlSchema);
            NamespaceMap prefixmap = new NamespaceMap();
            prefixmap.put("xs", "http://www.w3.org/2001/XMLSchema");
            prefixmap.put(targetNamespacePrefix, targetNamespace);
            xmlSchema.setNamespaceContext(prefixmap);
        }
        return xmlSchema;
    }

    public TypeTable getTypeTable() {
        return this.typeTable;
    }

    public JMethod[] getMethods() {
        return this.methods;
    }

    private String generatePrefix() {
        return NAME_SPACE_PREFIX + prefixCount++;
    }

    public void setExcludeMethods(ArrayList excludeMethods) {
        this.excludeMethods = excludeMethods;
    }

    public String getSchemaTargetNameSpace() {
        return this.schemaTargetNameSpace;
    }

    private void addImport(XmlSchema xmlSchema, QName schemaTypeName) {
        if (!((NamespaceMap)xmlSchema.getNamespaceContext()).values().contains(schemaTypeName.getNamespaceURI())) {
            XmlSchemaImport importElement = new XmlSchemaImport();
            importElement.setNamespace(schemaTypeName.getNamespaceURI());
            xmlSchema.getItems().add(importElement);
            ((NamespaceMap)xmlSchema.getNamespaceContext()).put(this.generatePrefix(), schemaTypeName.getNamespaceURI());
        }
    }

    public String getAttrFormDefault() {
        return this.attrFormDefault;
    }

    public void setAttrFormDefault(String attrFormDefault) {
        this.attrFormDefault = attrFormDefault;
    }

    public String getElementFormDefault() {
        return this.elementFormDefault;
    }

    public void setElementFormDefault(String elementFormDefault) {
        this.elementFormDefault = elementFormDefault;
    }

    private XmlSchemaForm getAttrFormDefaultSetting() {
        if ("unqualified".equals(this.getAttrFormDefault())) {
            return new XmlSchemaForm("unqualified");
        }
        return new XmlSchemaForm("qualified");
    }

    private XmlSchemaForm getElementFormDefaultSetting() {
        if ("unqualified".equals(this.getElementFormDefault())) {
            return new XmlSchemaForm("unqualified");
        }
        return new XmlSchemaForm("qualified");
    }

    public ArrayList getExtraClasses() {
        if (this.extraClasses == null) {
            this.extraClasses = new ArrayList();
        }
        return this.extraClasses;
    }

    public void setExtraClasses(ArrayList extraClasses) {
        this.extraClasses = extraClasses;
    }

    private String resolveSchemaNamespace(String packageName) throws Exception {
        if (this.useWSDLTypesNamespace) {
            return (String)this.pkg2nsmap.get("all");
        }
        if (this.pkg2nsmap != null && !this.pkg2nsmap.isEmpty()) {
            if (this.pkg2nsmap.get(packageName) != null) {
                return (String)this.pkg2nsmap.get(packageName);
            }
            return this.getNsGen().schemaNamespaceFromPackageName(packageName).toString();
        }
        return this.getNsGen().schemaNamespaceFromPackageName(packageName).toString();
    }

    public boolean isUseWSDLTypesNamespace() {
        return this.useWSDLTypesNamespace;
    }

    public void setUseWSDLTypesNamespace(boolean useWSDLTypesNamespace) {
        this.useWSDLTypesNamespace = useWSDLTypesNamespace;
    }

    public Map getPkg2nsmap() {
        return this.pkg2nsmap;
    }

    public void setPkg2nsmap(Map pkg2nsmap) {
        this.pkg2nsmap = pkg2nsmap;
    }

    public String getTargetNamespace() {
        return this.targetNamespace;
    }

    protected String getSimpleName(JMethod method) {
        return method.getSimpleName();
    }

    protected String getSimpleName(JClass type) {
        return type.getSimpleName();
    }

    protected String getSimpleName(JProperty peroperty) {
        return peroperty.getSimpleName();
    }

    protected String getSimpleName(JParameter parameter) {
        return parameter.getSimpleName();
    }

    protected String getQualifiedName(JMethod method) {
        return method.getQualifiedName();
    }

    protected String getQualifiedName(JClass type) {
        return type.getQualifiedName();
    }

    protected String getQualifiedName(JProperty peroperty) {
        return peroperty.getQualifiedName();
    }

    protected String getQualifiedName(JParameter parameter) {
        return parameter.getQualifiedName();
    }

    protected String getQualifiedName(JPackage packagez) {
        return packagez.getQualifiedName();
    }

    public void setNonRpcMethods(ArrayList nonRpcMethods) {
        if (nonRpcMethods != null) {
            this.nonRpcMethods = nonRpcMethods;
        }
    }
}

