/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.java2wsdl;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamReader;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.tools.ant.BuildException;
import org.apache.ws.java2wsdl.Mapper;

public class NamespaceMapping
implements Mapper {
    public static final QName PKG2NS_MAPPINGS = new QName("http://ws.apache.org/axis2", "pkg2ns_mapping");
    public static final QName MAPPING = new QName("http://ws.apache.org/axis2", "mapping");
    public static final String NAMESPACE = "namespace";
    public static final String PACKAGE = "package";
    private String namespace = null;
    private String packageName = null;
    private File mappingFile;
    private InputStream mapInputStream = null;
    private XMLStreamReader mapXmlReader = null;

    public void setNamespace(String value) {
        this.namespace = value;
    }

    public void setPackage(String value) {
        this.packageName = value;
    }

    public void setFile(File file) {
        this.mappingFile = file;
    }

    protected void map(HashMap map, String packName, String nspace, boolean packageIsKey) {
        if (packageIsKey) {
            map.put(packName, nspace);
        } else {
            map.put(nspace, packName);
        }
    }

    private void validate() {
        if (this.mappingFile != null || this.mapInputStream != null || this.mapXmlReader != null) {
            if (this.namespace != null || this.packageName != null) {
                throw new BuildException("Namespace or Package cannot be used with a File attribute");
            }
        } else {
            if (this.namespace == null) {
                throw new BuildException("namespace must be defined");
            }
            if (this.packageName == null) {
                throw new BuildException("package must be defined");
            }
        }
    }

    protected void mapXmlReader(HashMap map, boolean packageIsKey) throws BuildException {
        try {
            this.loadMappingFromXMLReader(map, packageIsKey);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void mapXmlStream(HashMap map, boolean packageIsKey) throws BuildException {
        try {
            this.mapXmlReader = StAXUtils.createXMLStreamReader(this.mapInputStream);
            this.mapXmlReader(map, packageIsKey);
            this.mapXmlReader = null;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    protected void mapFile(HashMap map, boolean packageIsKey) throws BuildException {
        try {
            this.mapInputStream = new FileInputStream(this.mappingFile);
            this.mapXmlStream(map, packageIsKey);
            this.mapInputStream.close();
            this.mapInputStream = null;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void loadMappingFromXMLReader(HashMap map, boolean packageIsKey) throws BuildException {
        try {
            QName parentElement = null;
            while (this.mapXmlReader.hasNext()) {
                switch (this.mapXmlReader.next()) {
                    case 1: {
                        QName qname2 = this.mapXmlReader.getName();
                        if (MAPPING.equals(qname2) && parentElement.equals(PKG2NS_MAPPINGS)) {
                            this.map(map, this.mapXmlReader.getAttributeValue(null, PACKAGE), this.mapXmlReader.getAttributeValue(null, NAMESPACE), packageIsKey);
                        } else {
                            parentElement = qname2;
                        }
                        this.mapXmlReader.next();
                        break;
                    }
                    case 2: {
                        if (!this.mapXmlReader.getName().equals(PKG2NS_MAPPINGS)) break;
                        return;
                    }
                }
            }
        }
        catch (Exception e) {
            System.out.println("Exception while loading package to namespace mappings... " + e);
        }
    }

    public void execute(HashMap map, boolean packageIsKey) throws BuildException {
        this.validate();
        if (this.mappingFile != null) {
            this.mapFile(map, packageIsKey);
            this.mappingFile = null;
        } else if (this.mapInputStream != null) {
            this.mapXmlStream(map, packageIsKey);
        } else if (this.mapXmlReader != null) {
            this.mapXmlReader(map, packageIsKey);
        } else {
            this.map(map, this.packageName, this.namespace, packageIsKey);
        }
    }

    public InputStream getMapInputStream() {
        return this.mapInputStream;
    }

    public void setMapInputStream(InputStream mapInputStream) {
        this.mapInputStream = mapInputStream;
    }

    public File getMappingFile() {
        return this.mappingFile;
    }

    public void setMappingFile(File mappingFile) {
        this.mappingFile = mappingFile;
    }

    public XMLStreamReader getXmlReader() {
        return this.mapXmlReader;
    }

    public void setXmlReader(XMLStreamReader xmlReader) {
        this.mapXmlReader = xmlReader;
    }
}

