/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.AckFinal;
import org.apache.sandesha2.wsrm.AckNone;
import org.apache.sandesha2.wsrm.AcknowledgementRange;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.Nack;

public class SequenceAcknowledgement
implements IOMRMPart {
    private Identifier identifier;
    private ArrayList acknowledgementRangeList;
    private ArrayList nackList;
    private String namespaceValue = null;
    private OMNamespace omNamespace = null;
    private AckNone ackNone = null;
    private AckFinal ackFinal = null;
    private OMElement originalSequenceAckElement;

    public SequenceAcknowledgement(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
        this.acknowledgementRangeList = new ArrayList();
        this.nackList = new ArrayList();
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement sequenceAckElement) throws OMException, SandeshaException {
        this.originalSequenceAckElement = sequenceAckElement;
        OMElement identifierPart = null;
        Iterator childElements = sequenceAckElement.getChildElements();
        while (childElements.hasNext()) {
            OMElement element = (OMElement)childElements.next();
            String elementNamespace = element.getQName().getNamespaceURI();
            String elementLocalName = element.getQName().getLocalPart();
            if (!this.namespaceValue.equals(elementNamespace)) continue;
            if ("AcknowledgementRange".equals(elementLocalName)) {
                AcknowledgementRange ackRange = new AcknowledgementRange(this.namespaceValue);
                ackRange.fromOMElement(element);
                this.acknowledgementRangeList.add(ackRange);
                continue;
            }
            if ("Nack".equals(elementLocalName)) {
                Nack nack = new Nack(this.namespaceValue);
                nack.fromOMElement(element);
                this.nackList.add(nack);
                continue;
            }
            if ("Identifier".equals(elementLocalName)) {
                identifierPart = element;
                continue;
            }
            String rmSpecVersion = SpecSpecificConstants.getSpecVersionString(this.namespaceValue);
            if (SpecSpecificConstants.isAckFinalAllowed(rmSpecVersion) && "Final".equals(elementLocalName)) {
                this.ackFinal = new AckFinal(this.namespaceValue);
                this.ackFinal.fromOMElement(element);
            }
            if (!SpecSpecificConstants.isAckNoneAllowed(rmSpecVersion) || !"None".equals(elementLocalName)) continue;
            this.ackNone = new AckNone(this.namespaceValue);
            this.ackNone.fromOMElement(element);
        }
        this.identifier = new Identifier(this.namespaceValue);
        this.identifier.fromOMElement(identifierPart);
        ((SOAPHeaderBlock)sequenceAckElement).setProcessed();
        return this;
    }

    public OMElement toOMElement(OMElement header) throws OMException, SandeshaException {
        if (header == null || !(header instanceof SOAPHeader)) {
            throw new OMException();
        }
        Iterator oldAckIter = header.getChildrenWithName(new QName(this.namespaceValue, "SequenceAcknowledgement"));
        while (oldAckIter.hasNext()) {
            OMElement oldAckElement = (OMElement)oldAckIter.next();
            SequenceAcknowledgement oldSequenceAcknowledgement = new SequenceAcknowledgement(this.namespaceValue);
            oldSequenceAcknowledgement.fromOMElement(oldAckElement);
            String oldAckIdentifier = oldSequenceAcknowledgement.getIdentifier().getIdentifier();
            if (oldAckIdentifier == null || !oldAckIdentifier.equals(this.identifier.getIdentifier())) continue;
            oldAckElement.detach();
        }
        SOAPHeader SOAPHeader2 = (SOAPHeader)header;
        SOAPHeaderBlock sequenceAcknowledgementHeaderBlock = SOAPHeader2.addHeaderBlock("SequenceAcknowledgement", this.omNamespace);
        if (sequenceAcknowledgementHeaderBlock == null) {
            throw new OMException("Cant set sequence acknowledgement since the element is null");
        }
        if (this.identifier == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("invalidIdentifier", ((Object)header).toString()));
        }
        sequenceAcknowledgementHeaderBlock.setMustUnderstand(true);
        this.identifier.toOMElement(sequenceAcknowledgementHeaderBlock, this.omNamespace);
        for (AcknowledgementRange ackRange : this.acknowledgementRangeList) {
            ackRange.toOMElement(sequenceAcknowledgementHeaderBlock);
        }
        for (Nack nack : this.nackList) {
            nack.toOMElement(sequenceAcknowledgementHeaderBlock);
        }
        String rmSpecVersion = SpecSpecificConstants.getSpecVersionString(this.namespaceValue);
        if (this.ackNone == null && this.acknowledgementRangeList.size() == 0 && this.nackList.size() == 0 && SpecSpecificConstants.isAckNoneAllowed(rmSpecVersion)) {
            this.ackNone = new AckNone(this.namespaceValue);
        }
        if (this.ackNone != null) {
            if (!SpecSpecificConstants.isAckNoneAllowed(rmSpecVersion)) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("noneNotAllowedNamespace", rmSpecVersion));
            }
            if (this.acknowledgementRangeList.size() > 0) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("noneNotAllowedAckRangesPresent"));
            }
            if (this.nackList.size() > 0) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("noneNotAllowedNackPresent"));
            }
            this.ackNone.toOMElement(sequenceAcknowledgementHeaderBlock);
        }
        if (this.ackFinal != null) {
            if (!SpecSpecificConstants.isAckFinalAllowed(rmSpecVersion)) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("finalNotAllowedNamespace"));
            }
            if (this.nackList.size() > 0) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotHaveFinalWithNack"));
            }
            this.ackFinal.toOMElement(sequenceAcknowledgementHeaderBlock);
        }
        return header;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setAckRanges(ArrayList acknowledgementRagngesList) {
        this.acknowledgementRangeList = acknowledgementRagngesList;
    }

    public Nack addNackRanges(Nack nack) {
        this.nackList.add(nack);
        return nack;
    }

    public AcknowledgementRange addAcknowledgementRanges(AcknowledgementRange ackRange) {
        this.acknowledgementRangeList.add(ackRange);
        return ackRange;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public List getAcknowledgementRanges() {
        return this.acknowledgementRangeList;
    }

    public List getNackList() {
        return this.nackList;
    }

    public void toSOAPEnvelope(SOAPEnvelope envelope) throws SandeshaException {
        SOAPHeader header = envelope.getHeader();
        if (header == null) {
            SOAPFactory factory = (SOAPFactory)envelope.getOMFactory();
            header = factory.createSOAPHeader(envelope);
        }
        this.toOMElement(header);
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            this.omNamespace = Sandesha2Constants.SPEC_2005_02.OM_NS_URI;
            return true;
        }
        if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName)) {
            this.omNamespace = Sandesha2Constants.SPEC_2007_02.OM_NS_URI;
            return true;
        }
        return false;
    }

    public AckFinal getAckFinal() {
        return this.ackFinal;
    }

    public void setAckFinal(AckFinal ackFinal) {
        this.ackFinal = ackFinal;
    }

    public AckNone getAckNone() {
        return this.ackNone;
    }

    public void setAckNone(AckNone ackNone) {
        this.ackNone = ackNone;
    }

    public OMElement getOriginalSequenceAckElement() {
        return this.originalSequenceAckElement;
    }
}

