/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.LastMessage;
import org.apache.sandesha2.wsrm.MessageNumber;

public class Sequence
implements IOMRMPart {
    private Identifier identifier;
    private MessageNumber messageNumber;
    private LastMessage lastMessage = null;
    private String namespaceValue = null;
    private OMNamespace omNamespace = null;

    public Sequence(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement ome) throws OMException, SandeshaException {
        SOAPHeaderBlock shb = (SOAPHeaderBlock)ome;
        if (shb == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noSequencePartInElement", shb.toString()));
        }
        OMElement identifierPart = null;
        OMElement msgNumberPart = null;
        OMElement lastMessageElement = null;
        Iterator iter = shb.getChildElements();
        while (iter.hasNext()) {
            OMElement child = (OMElement)iter.next();
            QName qn = child.getQName();
            if (!this.namespaceValue.equals(qn.getNamespaceURI())) continue;
            if ("Identifier".equals(qn.getLocalPart())) {
                identifierPart = child;
                continue;
            }
            if ("MessageNumber".equals(qn.getLocalPart())) {
                msgNumberPart = child;
                continue;
            }
            if (!"LastMessage".equals(qn.getLocalPart())) continue;
            lastMessageElement = child;
        }
        this.identifier = new Identifier(this.namespaceValue);
        this.identifier.fromOMElement(identifierPart);
        this.messageNumber = new MessageNumber(this.namespaceValue);
        this.messageNumber.fromOMElement(msgNumberPart);
        if (lastMessageElement != null) {
            this.lastMessage = new LastMessage(this.namespaceValue);
            this.lastMessage.fromOMElement(lastMessageElement);
        }
        shb.setProcessed();
        return this;
    }

    public OMElement toOMElement(OMElement headerElement) throws OMException {
        if (headerElement == null || !(headerElement instanceof SOAPHeader)) {
            throw new OMException(SandeshaMessageHelper.getMessage("seqElementCannotBeAddedToNonHeader"));
        }
        SOAPHeader soapHeader = (SOAPHeader)headerElement;
        if (this.identifier == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("nullMsgId"));
        }
        if (this.messageNumber == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("seqPartIsNull"));
        }
        SOAPHeaderBlock sequenceHeaderBlock = soapHeader.addHeaderBlock("Sequence", this.omNamespace);
        sequenceHeaderBlock.setMustUnderstand(true);
        this.identifier.toOMElement(sequenceHeaderBlock, this.omNamespace);
        this.messageNumber.toOMElement(sequenceHeaderBlock, this.omNamespace);
        if (this.lastMessage != null) {
            this.lastMessage.toOMElement(sequenceHeaderBlock);
        }
        return headerElement;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public LastMessage getLastMessage() {
        return this.lastMessage;
    }

    public MessageNumber getMessageNumber() {
        return this.messageNumber;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void setLastMessage(LastMessage lastMessage) {
        this.lastMessage = lastMessage;
    }

    public void setMessageNumber(MessageNumber messageNumber) {
        this.messageNumber = messageNumber;
    }

    public void toSOAPEnvelope(SOAPEnvelope envelope) {
        OMElement elem;
        SOAPHeader header = envelope.getHeader();
        if (header == null) {
            SOAPFactory factory = (SOAPFactory)envelope.getOMFactory();
            header = factory.createSOAPHeader(envelope);
        }
        if ((elem = header.getFirstChildWithName(new QName(this.namespaceValue, "Sequence"))) != null) {
            elem.detach();
        }
        this.toOMElement(header);
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            this.omNamespace = Sandesha2Constants.SPEC_2005_02.OM_NS_URI;
            return true;
        }
        if ("http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName)) {
            this.omNamespace = Sandesha2Constants.SPEC_2007_02.OM_NS_URI;
            return true;
        }
        return false;
    }
}

