/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.CloseSequenceResponse;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.CreateSequenceResponse;
import org.apache.sandesha2.wsrm.MakeConnection;
import org.apache.sandesha2.wsrm.MessagePending;
import org.apache.sandesha2.wsrm.Sequence;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;
import org.apache.sandesha2.wsrm.SequenceFault;
import org.apache.sandesha2.wsrm.TerminateSequence;
import org.apache.sandesha2.wsrm.TerminateSequenceResponse;
import org.apache.sandesha2.wsrm.UsesSequenceSTR;

public class RMElements {
    private Sequence sequence = null;
    private ArrayList sequenceAcknowledgements = new ArrayList();
    private ArrayList ackRequests = new ArrayList();
    private CreateSequence createSequence = null;
    private CreateSequenceResponse createSequenceResponse = null;
    private TerminateSequence terminateSequence = null;
    private TerminateSequenceResponse terminateSequenceResponse = null;
    private CloseSequence closeSequence = null;
    private CloseSequenceResponse closeSequenceResponse = null;
    private UsesSequenceSTR usesSequenceSTR = null;
    private MessagePending messagePending = null;
    private MakeConnection makeConnection = null;
    private SequenceFault sequenceFault = null;

    public RMElements() {
    }

    public RMElements(String addressingNamespace) {
        this();
    }

    public void fromSOAPEnvelope(SOAPEnvelope envelope, String action) throws AxisFault {
        if (envelope == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("nullPassedElement"));
        }
        SOAPHeader header = envelope.getHeader();
        SOAPBody body = envelope.getBody();
        if (header != null) {
            this.processHeaders(envelope);
        }
        if (body != null) {
            this.processBody(body);
        }
    }

    private void processBody(SOAPBody body) throws AxisFault {
        OMElement firstBodyElement = body.getFirstElement();
        if (firstBodyElement != null) {
            QName firstBodyQName = firstBodyElement.getQName();
            String namespace = firstBodyQName.getNamespaceURI();
            String localName = firstBodyQName.getLocalPart();
            boolean isSPEC2007_02 = "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespace);
            boolean isSPEC2005_02 = false;
            if (!isSPEC2007_02) {
                isSPEC2005_02 = "http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespace);
            }
            if (isSPEC2005_02 || isSPEC2007_02) {
                if (Sandesha2Constants.SPEC_2007_02.QNames.CreateSequence.equals(firstBodyQName)) {
                    this.createSequence = new CreateSequence(namespace);
                    this.createSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.CreateSequence.equals(firstBodyQName)) {
                    this.createSequence = new CreateSequence(namespace);
                    this.createSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2007_02.QNames.CreateSequenceResponse.equals(firstBodyQName)) {
                    this.createSequenceResponse = new CreateSequenceResponse(namespace);
                    this.createSequenceResponse.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.CreateSequenceResponse.equals(firstBodyQName)) {
                    this.createSequenceResponse = new CreateSequenceResponse(namespace);
                    this.createSequenceResponse.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2007_02.QNames.CloseSequence.equals(firstBodyQName)) {
                    this.closeSequence = new CloseSequence(namespace);
                    this.closeSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.CloseSequence.equals(firstBodyQName)) {
                    this.closeSequence = new CloseSequence(namespace);
                    this.closeSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2007_02.QNames.CloseSequenceResponse.equals(firstBodyQName)) {
                    this.closeSequenceResponse = new CloseSequenceResponse(namespace);
                    this.closeSequenceResponse.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.CloseSequenceResponse.equals(firstBodyQName)) {
                    this.closeSequenceResponse = new CloseSequenceResponse(namespace);
                    this.closeSequenceResponse.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2007_02.QNames.TerminateSequence.equals(firstBodyQName)) {
                    this.terminateSequence = new TerminateSequence(namespace);
                    this.terminateSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.TerminateSequence.equals(firstBodyQName)) {
                    this.terminateSequence = new TerminateSequence(namespace);
                    this.terminateSequence.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2007_02.QNames.TerminateSequenceResponse.equals(firstBodyQName)) {
                    this.terminateSequenceResponse = new TerminateSequenceResponse(namespace);
                    this.terminateSequenceResponse.fromOMElement(body);
                } else if (Sandesha2Constants.SPEC_2005_02.QNames.TerminateSequenceResponse.equals(firstBodyQName)) {
                    this.terminateSequenceResponse = new TerminateSequenceResponse(namespace);
                    this.terminateSequenceResponse.fromOMElement(body);
                }
            } else if (Sandesha2Constants.SPEC_2007_02.QNames.MakeConnection.equals(firstBodyQName)) {
                this.makeConnection = new MakeConnection(namespace);
                this.makeConnection.fromOMElement(firstBodyElement);
            }
        }
    }

    private void processHeaders(SOAPEnvelope envelope) throws AxisFault {
        if (envelope == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("nullPassedElement"));
        }
        SOAPFactory factory = (SOAPFactory)envelope.getOMFactory();
        SOAPHeader header = envelope.getHeader();
        if (header != null) {
            Iterator headers = header.getChildElements();
            while (headers.hasNext()) {
                OMElement element = (OMElement)headers.next();
                QName elementName = element.getQName();
                String namespace = elementName.getNamespaceURI();
                String localName = elementName.getLocalPart();
                boolean isSPEC2007_02 = "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespace);
                boolean isSPEC2005_02 = false;
                if (!isSPEC2007_02) {
                    isSPEC2005_02 = "http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespace);
                }
                if (!isSPEC2005_02 && !isSPEC2007_02) continue;
                boolean isProcessed = false;
                if (isSPEC2007_02) {
                    if ("UsesSequenceSTR".equals(localName)) {
                        this.usesSequenceSTR = new UsesSequenceSTR(factory, namespace);
                        this.usesSequenceSTR.fromOMElement(element);
                        isProcessed = true;
                    } else if ("MessagePending".equals(localName)) {
                        this.messagePending = new MessagePending(namespace);
                        this.messagePending.fromOMElement(element);
                        isProcessed = true;
                    }
                }
                if (isProcessed) continue;
                if ("Sequence".equals(localName)) {
                    this.sequence = new Sequence(namespace);
                    this.sequence.fromOMElement(element);
                    continue;
                }
                if ("SequenceAcknowledgement".equals(localName)) {
                    SequenceAcknowledgement sequenceAcknowledgement = new SequenceAcknowledgement(namespace);
                    sequenceAcknowledgement.fromOMElement(element);
                    this.sequenceAcknowledgements.add(sequenceAcknowledgement);
                    continue;
                }
                if ("AckRequested".equals(localName)) {
                    AckRequested ackRequest = new AckRequested(namespace);
                    ackRequest.fromOMElement(element);
                    this.ackRequests.add(ackRequest);
                    continue;
                }
                if (!"SequenceFault".equals(localName)) continue;
                this.sequenceFault = new SequenceFault(namespace);
                this.sequenceFault.fromOMElement(element);
            }
        }
    }

    public SOAPEnvelope toSOAPEnvelope(SOAPEnvelope envelope) throws AxisFault {
        if (this.sequence != null) {
            this.sequence.toOMElement(envelope.getHeader());
        }
        for (SequenceAcknowledgement sequenceAck : this.sequenceAcknowledgements) {
            sequenceAck.toOMElement(envelope.getHeader());
        }
        for (AckRequested ackReq : this.ackRequests) {
            ackReq.toOMElement(envelope.getHeader());
        }
        if (this.createSequence != null) {
            this.createSequence.toOMElement(envelope.getBody());
        }
        if (this.createSequenceResponse != null) {
            this.createSequenceResponse.toOMElement(envelope.getBody());
        }
        if (this.terminateSequence != null) {
            this.terminateSequence.toOMElement(envelope.getBody());
        }
        if (this.terminateSequenceResponse != null) {
            this.terminateSequenceResponse.toOMElement(envelope.getBody());
        }
        if (this.closeSequence != null) {
            this.closeSequence.toOMElement(envelope.getBody());
        }
        if (this.closeSequenceResponse != null) {
            this.closeSequenceResponse.toOMElement(envelope.getBody());
        }
        if (this.makeConnection != null) {
            this.makeConnection.toOMElement(envelope.getBody());
        }
        if (this.messagePending != null) {
            this.messagePending.toOMElement(envelope.getHeader());
        }
        return envelope;
    }

    public CreateSequence getCreateSequence() {
        return this.createSequence;
    }

    public CreateSequenceResponse getCreateSequenceResponse() {
        return this.createSequenceResponse;
    }

    public Sequence getSequence() {
        return this.sequence;
    }

    public Iterator getSequenceAcknowledgements() {
        return this.sequenceAcknowledgements.iterator();
    }

    public TerminateSequence getTerminateSequence() {
        return this.terminateSequence;
    }

    public TerminateSequenceResponse getTerminateSequenceResponse() {
        return this.terminateSequenceResponse;
    }

    public void setCreateSequence(CreateSequence createSequence) {
        this.createSequence = createSequence;
    }

    public void setCreateSequenceResponse(CreateSequenceResponse createSequenceResponse) {
        this.createSequenceResponse = createSequenceResponse;
    }

    public void setSequence(Sequence sequence) {
        this.sequence = sequence;
    }

    public void setSequenceAcknowledgements(ArrayList sequenceAcknowledgements) {
        this.sequenceAcknowledgements = sequenceAcknowledgements;
    }

    public void addSequenceAcknowledgement(SequenceAcknowledgement sequenceAcknowledgement) {
        this.sequenceAcknowledgements.add(sequenceAcknowledgement);
    }

    public void setTerminateSequence(TerminateSequence terminateSequence) {
        this.terminateSequence = terminateSequence;
    }

    public void setTerminateSequenceResponse(TerminateSequenceResponse terminateSequenceResponse) {
        this.terminateSequenceResponse = terminateSequenceResponse;
    }

    public Iterator getAckRequests() {
        return this.ackRequests.iterator();
    }

    public void setAckRequested(ArrayList ackRequests) {
        this.ackRequests = ackRequests;
    }

    public void addAckRequested(AckRequested ackRequested) {
        this.ackRequests.add(ackRequested);
    }

    public void setMakeConnection(MakeConnection makeConnection) {
        this.makeConnection = makeConnection;
    }

    public void setMessagePending(MessagePending messagePending) {
        this.messagePending = messagePending;
    }

    public CloseSequence getCloseSequence() {
        return this.closeSequence;
    }

    public void setCloseSequence(CloseSequence closeSequence) {
        this.closeSequence = closeSequence;
    }

    public CloseSequenceResponse getCloseSequenceResponse() {
        return this.closeSequenceResponse;
    }

    public void setCloseSequenceResponse(CloseSequenceResponse closeSequenceResponse) {
        this.closeSequenceResponse = closeSequenceResponse;
    }

    public UsesSequenceSTR getUsesSequenceSTR() {
        return this.usesSequenceSTR;
    }

    public void setUsesSequenceSTR(UsesSequenceSTR header) {
        this.usesSequenceSTR = header;
    }

    public MakeConnection getMakeConnection() {
        return this.makeConnection;
    }

    public MessagePending getMessagePending() {
        return this.messagePending;
    }

    public SequenceFault getSequenceFault() {
        return this.sequenceFault;
    }
}

