/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class LastMessage
implements IOMRMElement {
    private String namespaceValue = null;

    public LastMessage(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement lastMessagePart) throws OMException {
        if (lastMessagePart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noLastMessagePartInElement", ((Object)lastMessagePart).toString()));
        }
        return this;
    }

    public OMElement toOMElement(OMElement sequenceElement) throws OMException {
        OMFactory factory = sequenceElement.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement lastMessageElement = factory.createOMElement("LastMessage", rmNamespace);
        sequenceElement.addChild(lastMessageElement);
        return sequenceElement;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

