/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class FaultCode
implements IOMRMElement {
    private QName faultCode = null;
    private String namespaceValue = null;
    private String detail;
    private OMElement detailOMElement;
    private OMElement extendedDetailOMElement;

    public FaultCode(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement sequenceFault) throws OMException {
        if (sequenceFault == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noFaultCodePart", null));
        }
        OMElement faultCodePart = sequenceFault.getFirstChildWithName(new QName(this.namespaceValue, "FaultCode"));
        if (faultCodePart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noFaultCode", ((Object)sequenceFault).toString()));
        }
        this.faultCode = faultCodePart.getTextAsQName();
        OMElement detailPart = sequenceFault.getFirstChildWithName(new QName(this.namespaceValue, "Detail"));
        if (detailPart != null) {
            this.detailOMElement = detailPart;
            OMElement identifier = detailPart.getFirstChildWithName(new QName(this.namespaceValue, "Identifier"));
            if (identifier != null) {
                this.detail = identifier.getText();
            }
        }
        return sequenceFault;
    }

    public OMElement toOMElement(OMElement sequenceFault) throws OMException {
        if (sequenceFault == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("nullPassedElement"));
        }
        if (this.faultCode == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noFaultCode"));
        }
        OMFactory factory = sequenceFault.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement faultCodeElement = factory.createOMElement("FaultCode", rmNamespace);
        OMElement detailElement = factory.createOMElement("Detail", rmNamespace);
        faultCodeElement.setText(this.faultCode);
        sequenceFault.addChild(faultCodeElement);
        if (this.detailOMElement != null) {
            detailElement.addChild(this.detailOMElement);
        }
        if (this.detail != null) {
            detailElement.setText(this.detail);
        }
        if (this.extendedDetailOMElement != null) {
            detailElement.addChild(this.extendedDetailOMElement);
        }
        sequenceFault.addChild(detailElement);
        return sequenceFault;
    }

    public void setFaultCode(QName faultCode) {
        this.faultCode = faultCode;
    }

    public QName getFaultCode() {
        return this.faultCode;
    }

    public void setDetail(String detail) {
        this.detail = detail;
    }

    public String getDetail() {
        return this.detail;
    }

    public OMElement getDetailOMElement() {
        return this.detailOMElement;
    }

    public void setDetailOMElement(OMElement detailOMElement) {
        this.detailOMElement = detailOMElement;
    }

    public void setExtendedDetailOMElement(OMElement detail2) {
        this.extendedDetailOMElement = detail2;
    }

    public OMElement getExtendedDetailOMElement() {
        return this.extendedDetailOMElement;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

