/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;

public class CloseSequence
implements IOMRMPart {
    private Identifier identifier;
    private String namespaceValue = null;

    public CloseSequence(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement body) throws OMException, SandeshaException {
        if (!(body instanceof SOAPBody)) {
            throw new OMException(SandeshaMessageHelper.getMessage("closeSeqCannotBeAddedToNonBody"));
        }
        OMElement closeSeqPart = body.getFirstChildWithName(new QName(this.namespaceValue, "CloseSequence"));
        if (closeSeqPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("noCloseSequencePartInElement", ((Object)body).toString()));
        }
        this.identifier = new Identifier(this.namespaceValue);
        OMElement identifierPart = closeSeqPart.getFirstChildWithName(new QName(this.namespaceValue, "Identifier"));
        if (identifierPart != null) {
            this.identifier.fromOMElement(identifierPart);
        }
        return this;
    }

    public OMElement toOMElement(OMElement body) throws OMException {
        if (body == null || !(body instanceof SOAPBody)) {
            throw new OMException(SandeshaMessageHelper.getMessage("closeSeqCannotBeAddedToNonBody"));
        }
        if (this.identifier == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("closeSeqPartNullID"));
        }
        OMFactory factory = body.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        OMElement closeSequenceElement = factory.createOMElement("CloseSequence", rmNamespace);
        this.identifier.toOMElement(closeSequenceElement, rmNamespace);
        body.addChild(closeSequenceElement);
        return body;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public void toSOAPEnvelope(SOAPEnvelope envelope) {
        SOAPBody body = envelope.getBody();
        OMElement elem = body.getFirstChildWithName(new QName(this.namespaceValue, "CloseSequence"));
        if (elem != null) {
            elem.detach();
        }
        this.toOMElement(body);
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }
}

