/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMElement;

public class Address
implements IOMRMElement {
    private String address = null;
    private String rmNamespaceValue = null;

    public Address(String rmNamespaceValue) {
        this.rmNamespaceValue = rmNamespaceValue;
    }

    public Object fromOMElement(OMElement element) throws OMException {
        OMElement addressPart = element.getFirstChildWithName(new QName(this.rmNamespaceValue, "Address"));
        if (addressPart == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("cannotFindAddressElement", ((Object)element).toString()));
        }
        String addressText = addressPart.getText();
        if (addressText == null || "".equals(addressText)) {
            throw new OMException(SandeshaMessageHelper.getMessage("cannotFindAddressText", ((Object)element).toString()));
        }
        this.address = addressText;
        return this;
    }

    public String getNamespaceValue() {
        return this.rmNamespaceValue;
    }

    public OMElement toOMElement(OMElement element) throws OMException {
        if (this.address == null || "".equals(this.address)) {
            throw new OMException(SandeshaMessageHelper.getMessage("addressNotValid"));
        }
        OMFactory factory = element.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.rmNamespaceValue, "wsmc");
        OMElement addressElement = factory.createOMElement("Address", rmNamespace);
        addressElement.setText(this.address);
        element.addChild(addressElement);
        return element;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        return "http://docs.oasis-open.org/ws-rx/wsmc/200702".equals(namespaceName);
    }
}

