/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.wsrm;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.wsrm.IOMRMPart;
import org.apache.sandesha2.wsrm.Identifier;

public class AckRequested
implements IOMRMPart {
    private Identifier identifier;
    private String namespaceValue = null;
    private boolean mustUnderstand = false;
    private OMElement originalAckRequestedElement;

    public AckRequested(String namespaceValue) throws SandeshaException {
        if (!this.isNamespaceSupported(namespaceValue)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSpec", namespaceValue));
        }
        this.namespaceValue = namespaceValue;
    }

    public String getNamespaceValue() {
        return this.namespaceValue;
    }

    public Object fromOMElement(OMElement ackReqElement) throws OMException, SandeshaException {
        this.originalAckRequestedElement = ackReqElement;
        this.identifier = new Identifier(this.namespaceValue);
        OMElement identifierPart = ackReqElement.getFirstChildWithName(new QName(this.namespaceValue, "Identifier"));
        if (identifierPart != null) {
            this.identifier.fromOMElement(identifierPart);
        }
        ((SOAPHeaderBlock)ackReqElement).setProcessed();
        return this;
    }

    public OMElement toOMElement(OMElement header) throws OMException {
        if (header == null || !(header instanceof SOAPHeader)) {
            throw new OMException(SandeshaMessageHelper.getMessage("ackRequestedCannotBeAddedToNonHeader"));
        }
        if (this.identifier == null) {
            throw new OMException(SandeshaMessageHelper.getMessage("ackRequestNullID"));
        }
        OMFactory factory = header.getOMFactory();
        OMNamespace rmNamespace = factory.createOMNamespace(this.namespaceValue, "wsrm");
        Iterator iter = header.getChildrenWithName(new QName(this.namespaceValue, "AckRequested"));
        while (iter.hasNext()) {
            OMElement ackRequestedElement = (OMElement)iter.next();
            OMElement identifierElement = ackRequestedElement.getFirstChildWithName(new QName(this.namespaceValue, "Identifier"));
            String identifierVal = null;
            if (identifierElement != null) {
                identifierVal = identifierElement.getText();
            }
            if (identifierVal == null || !identifierVal.equals(this.identifier.getIdentifier()) && !identifierVal.equals("uuid:tempID")) continue;
            ackRequestedElement.detach();
        }
        SOAPHeader SOAPHdr = (SOAPHeader)header;
        SOAPHeaderBlock ackReqHdrBlock = SOAPHdr.addHeaderBlock("AckRequested", rmNamespace);
        ackReqHdrBlock.setMustUnderstand(this.isMustUnderstand());
        this.identifier.toOMElement(ackReqHdrBlock, rmNamespace);
        return header;
    }

    public void setIdentifier(Identifier identifier) {
        this.identifier = identifier;
    }

    public Identifier getIdentifier() {
        return this.identifier;
    }

    public void toSOAPEnvelope(SOAPEnvelope envelope) {
        SOAPHeader header = envelope.getHeader();
        if (header == null) {
            SOAPFactory factory = (SOAPFactory)envelope.getOMFactory();
            header = factory.createSOAPHeader(envelope);
        }
        this.toOMElement(header);
    }

    public boolean isMustUnderstand() {
        return this.mustUnderstand;
    }

    public void setMustUnderstand(boolean mustUnderstand) {
        this.mustUnderstand = mustUnderstand;
    }

    public boolean isNamespaceSupported(String namespaceName) {
        if ("http://schemas.xmlsoap.org/ws/2005/02/rm".equals(namespaceName)) {
            return true;
        }
        return "http://docs.oasis-open.org/ws-rx/wsrm/200702".equals(namespaceName);
    }

    public OMElement getOriginalAckRequestedElement() {
        return this.originalAckRequestedElement;
    }
}

