/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import java.util.ArrayList;
import java.util.Iterator;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFault;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.axis2.transport.http.HTTPConstants;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.MessageRetransmissionAdjuster;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.SandeshaWorker;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.LastMessage;
import org.apache.sandesha2.wsrm.MessageNumber;
import org.apache.sandesha2.wsrm.Sequence;
import org.apache.sandesha2.wsrm.TerminateSequence;

public class SenderWorker
extends SandeshaWorker
implements Runnable {
    private static final Log log = LogFactory.getLog(SenderWorker.class);
    private ConfigurationContext configurationContext = null;
    private SenderBean senderBean = null;
    private RMMsgContext messageToSend = null;
    private String rmVersion = null;

    public SenderWorker(ConfigurationContext configurationContext, SenderBean senderBean, String rmVersion) {
        this.configurationContext = configurationContext;
        this.senderBean = senderBean;
        this.rmVersion = rmVersion;
    }

    public void setMessage(RMMsgContext msg) {
        this.messageToSend = msg;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block86: {
            if (log.isDebugEnabled()) {
                log.debug("Enter: SenderWorker::run");
            }
            if (this.lock != null && !this.lock.ownsLock(this.workId, this)) {
                if (log.isDebugEnabled()) {
                    log.debug("Exit: SenderWorker::run, another worker holds the lock");
                }
                return;
            }
            Transaction transaction = null;
            try {
                EndpointReference replyToEPR;
                StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(this.configurationContext, this.configurationContext.getAxisConfiguration());
                SenderBeanMgr senderBeanMgr = storageManager.getSenderBeanMgr();
                transaction = storageManager.getTransaction();
                String key = this.senderBean.getMessageContextRefKey();
                MessageContext msgCtx = null;
                RMMsgContext rmMsgCtx = null;
                if (this.messageToSend != null) {
                    msgCtx = this.messageToSend.getMessageContext();
                    rmMsgCtx = this.messageToSend;
                } else {
                    msgCtx = storageManager.retrieveMessageContext(key, this.configurationContext);
                    if (msgCtx == null) {
                        return;
                    }
                    rmMsgCtx = MsgInitializer.initializeMessage(msgCtx);
                }
                String qualifiedForSending = (String)msgCtx.getProperty("Sandesha2QualifiedForSending");
                if (qualifiedForSending != null && !qualifiedForSending.equals("true")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: SenderWorker::run, !qualified for sending");
                    }
                    return;
                }
                if (msgCtx == null) {
                    if (log.isDebugEnabled()) {
                        log.debug(SandeshaMessageHelper.getMessage("sendHasUnavailableMsgEntry"));
                    }
                    return;
                }
                ArrayList msgsNotToSend = SandeshaUtil.getPropertyBean(msgCtx.getAxisOperation()).getMsgTypesToDrop();
                if (msgsNotToSend != null && msgsNotToSend.contains(new Integer(rmMsgCtx.getMessageType()))) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: SenderWorker::run, message type to be dropped " + rmMsgCtx.getMessageType());
                    }
                    return;
                }
                RequestResponseTransport t = null;
                Boolean makeConnection = (Boolean)msgCtx.getProperty("MakeConnectionResponse");
                EndpointReference toEPR = msgCtx.getTo();
                MessageContext inMsg = null;
                OperationContext op = msgCtx.getOperationContext();
                if (op != null) {
                    inMsg = op.getMessageContext("In");
                }
                if (inMsg != null) {
                    t = (RequestResponseTransport)inMsg.getProperty("RequestResponseTransportControl");
                }
                if (!(toEPR != null && !toEPR.hasAnonymousAddress() || makeConnection != null && makeConnection.booleanValue() || t != null && t.getStatus().equals(RequestResponseTransport.RequestResponseTransportStatus.WAITING))) {
                    SenderBean bean = senderBeanMgr.retrieve(this.senderBean.getMessageID());
                    if (bean != null && bean.isTransportAvailable()) {
                        bean.setTransportAvailable(false);
                        senderBeanMgr.update(bean);
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = null;
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: SenderWorker::run, no response transport for anonymous message");
                    }
                    return;
                }
                int messageType = this.senderBean.getMessageType();
                if (this.isAckPiggybackableMsgType(messageType)) {
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = storageManager.getTransaction();
                    AcknowledgementManager.piggybackAcksIfPresent(rmMsgCtx, storageManager);
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = storageManager.getTransaction();
                this.senderBean = this.updateMessage(rmMsgCtx, this.senderBean, storageManager);
                if (this.senderBean == null) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: SenderWorker::run, !continueSending");
                    }
                    return;
                }
                boolean successfullySent = false;
                if (this.senderBean.isReSend()) {
                    senderBeanMgr.update(this.senderBean);
                }
                if (log.isDebugEnabled()) {
                    log.debug("Redecorate EPR : " + msgCtx.getEnvelope().getHeader());
                }
                if ((replyToEPR = msgCtx.getReplyTo()) != null) {
                    replyToEPR = SandeshaUtil.getEPRDecorator(msgCtx.getConfigurationContext()).decorateEndpointReference(replyToEPR);
                    msgCtx.setReplyTo(replyToEPR);
                }
                if (transaction != null) {
                    transaction.commit();
                    transaction = null;
                }
                boolean processResponseForFaults = false;
                try {
                    AxisEngine engine2 = new AxisEngine(msgCtx.getConfigurationContext());
                    Handler.InvocationResponse response = Handler.InvocationResponse.CONTINUE;
                    if (storageManager.requiresMessageSerialization()) {
                        if (msgCtx.isPaused()) {
                            if (log.isDebugEnabled()) {
                                log.debug("Resuming a send for message : " + msgCtx.getEnvelope().getHeader());
                            }
                            msgCtx.setPaused(false);
                            msgCtx.setProperty("transportNonBlocking", Boolean.FALSE);
                            response = engine2.resumeSend(msgCtx);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug("Sending a message : " + msgCtx.getEnvelope().getHeader());
                            }
                            msgCtx.setProperty("transportNonBlocking", Boolean.FALSE);
                            engine2.send(msgCtx);
                        }
                    } else {
                        ArrayList retransmittablePhases = (ArrayList)msgCtx.getProperty("RMRetransmittablePhases");
                        if (retransmittablePhases != null) {
                            msgCtx.setExecutionChain(retransmittablePhases);
                        } else {
                            ArrayList emptyExecutionChain = new ArrayList();
                            msgCtx.setExecutionChain(emptyExecutionChain);
                        }
                        msgCtx.setCurrentHandlerIndex(0);
                        msgCtx.setCurrentPhaseIndex(0);
                        msgCtx.setPaused(false);
                        if (log.isDebugEnabled()) {
                            log.debug("Resuming a send for message : " + msgCtx.getEnvelope().getHeader());
                        }
                        msgCtx.setProperty("transportNonBlocking", Boolean.FALSE);
                        response = engine2.resumeSend(msgCtx);
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Engine resume returned " + response);
                    }
                    if (response != Handler.InvocationResponse.SUSPEND && t != null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Signalling transport in " + t);
                        }
                        t.signalResponseReady();
                    }
                    successfullySent = true;
                }
                catch (AxisFault e) {
                    processResponseForFaults = true;
                    this.recordError(e, rmMsgCtx, storageManager);
                }
                catch (Exception e) {
                    String message = SandeshaMessageHelper.getMessage("sendMsgError", e.toString());
                    if (log.isDebugEnabled()) {
                        log.debug(message, e);
                    }
                    this.recordError(e, rmMsgCtx, storageManager);
                }
                transaction = storageManager.getTransaction();
                SenderBean bean1 = senderBeanMgr.retrieve(this.senderBean.getMessageID());
                if (bean1 != null) {
                    if (this.senderBean.isReSend()) {
                        bean1.setTimeToSend(this.senderBean.getTimeToSend());
                        senderBeanMgr.update(bean1);
                    } else {
                        senderBeanMgr.delete(bean1.getMessageID());
                        String messageStoredKey = bean1.getMessageContextRefKey();
                        storageManager.removeMessageContext(messageStoredKey);
                    }
                }
                if (transaction != null) {
                    transaction.commit();
                }
                transaction = null;
                if ((processResponseForFaults || successfullySent) && !msgCtx.isServerSide()) {
                    this.checkForSyncResponses(msgCtx);
                }
                if (rmMsgCtx.getMessageType() != 7 || !"http://schemas.xmlsoap.org/ws/2005/02/rm".equals(rmMsgCtx.getRMNamespaceValue())) break block86;
                try {
                    transaction = storageManager.getTransaction();
                    TerminateSequence terminateSequence = (TerminateSequence)rmMsgCtx.getMessagePart(11);
                    String sequenceID = terminateSequence.getIdentifier().getIdentifier();
                    RMSBean rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sequenceID);
                    TerminateManager.terminateSendingSide(rmsBean, storageManager);
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = null;
                }
                finally {
                    if (transaction != null && transaction.isActive()) {
                        transaction.rollback();
                        transaction = null;
                    }
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught exception", e);
                }
            }
            finally {
                block87: {
                    if (this.lock != null && this.workId != null) {
                        this.lock.removeWork(this.workId);
                    }
                    if (transaction != null && transaction.isActive()) {
                        try {
                            transaction.rollback();
                        }
                        catch (SandeshaStorageException e) {
                            if (!log.isWarnEnabled()) break block87;
                            log.warn("Caught exception rolling back transaction", e);
                        }
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SenderWorker::run");
        }
    }

    private SenderBean updateMessage(RMMsgContext rmMsgContext, SenderBean senderBean, StorageManager storageManager) throws AxisFault {
        senderBean = storageManager.getSenderBeanMgr().retrieve(senderBean.getMessageID());
        if (senderBean == null) {
            return null;
        }
        int messageType = senderBean.getMessageType();
        boolean continueSending = MessageRetransmissionAdjuster.adjustRetransmittion(rmMsgContext, senderBean, rmMsgContext.getConfigurationContext(), storageManager);
        if (!continueSending) {
            return null;
        }
        Identifier id = null;
        if (messageType == 3 || messageType == 12) {
            String namespace = SpecSpecificConstants.getRMNamespaceValue(this.rmVersion);
            Sequence sequence = (Sequence)rmMsgContext.getMessagePart(6);
            if (sequence == null) {
                sequence = new Sequence(namespace);
                MessageNumber msgNumber = new MessageNumber(namespace);
                msgNumber.setMessageNumber(senderBean.getMessageNumber());
                sequence.setMessageNumber(msgNumber);
                if (senderBean.isLastMessage() && SpecSpecificConstants.isLastMessageIndicatorRequired(this.rmVersion)) {
                    sequence.setLastMessage(new LastMessage(namespace));
                }
                id = new Identifier(namespace);
                sequence.setIdentifier(id);
                rmMsgContext.setMessagePart(6, sequence);
            }
        } else if (messageType == 7) {
            TerminateSequence terminate = (TerminateSequence)rmMsgContext.getMessagePart(11);
            id = terminate.getIdentifier();
        } else if (messageType == 5) {
            CloseSequence close = (CloseSequence)rmMsgContext.getMessagePart(12);
            id = close.getIdentifier();
        } else if (messageType == 8) {
            Iterator ackRequests = rmMsgContext.getMessageParts(15);
            AckRequested ackRequest = (AckRequested)ackRequests.next();
            if (ackRequests.hasNext()) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("ackRequestMultipleParts"));
            }
            id = ackRequest.getIdentifier();
        }
        boolean ackPresent = false;
        Iterator it = rmMsgContext.getMessageParts(7);
        if (it.hasNext()) {
            ackPresent = true;
        }
        if (!ackPresent && rmMsgContext.getMessageContext().isServerSide() && (messageType == 3 || messageType == 3 || messageType == 0 || messageType == 12)) {
            String inboundSequenceId = senderBean.getInboundSequenceId();
            if (inboundSequenceId == null) {
                throw new SandeshaException("InboundSequenceID is not set for the sequence:" + id);
            }
            RMDBean incomingSequenceBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, inboundSequenceId);
            if (incomingSequenceBean != null) {
                RMMsgCreator.addAckMessage(rmMsgContext, inboundSequenceId, incomingSequenceBean, false);
            }
        }
        if (id != null && !senderBean.getSequenceID().equals(id.getIdentifier())) {
            id.setIndentifer(senderBean.getSequenceID());
            rmMsgContext.addSOAPEnvelope();
        } else if (rmMsgContext.getProperty("ackToBeWritten") != null) {
            rmMsgContext.addSOAPEnvelope();
        }
        return senderBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordError(Exception e, RMMsgContext outRMMsg, StorageManager storageManager) throws SandeshaStorageException {
        Transaction transaction = null;
        try {
            String internalSequenceId = (String)outRMMsg.getProperty("Sandesha2InternalSequenceId");
            if (internalSequenceId == null) {
                internalSequenceId = this.senderBean.getInternalSequenceID();
            }
            if (internalSequenceId != null) {
                transaction = storageManager.getTransaction();
                RMSBean bean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
                if (bean != null) {
                    bean.setLastSendError(e);
                    bean.setLastSendErrorTimestamp(System.currentTimeMillis());
                    storageManager.getRMSBeanMgr().update(bean);
                }
                if (transaction != null) {
                    transaction.commit();
                    transaction = null;
                }
            }
        }
        catch (Exception e1) {
            if (log.isErrorEnabled()) {
                log.error(e1);
            }
        }
        finally {
            if (transaction != null) {
                transaction.rollback();
                transaction = null;
            }
        }
    }

    private boolean isAckPiggybackableMsgType(int messageType) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SenderWorker::isAckPiggybackableMsgType, " + messageType);
        }
        boolean piggybackable = true;
        if (messageType == 4) {
            piggybackable = false;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SenderWorker::isAckPiggybackableMsgType, " + piggybackable);
        }
        return piggybackable;
    }

    private void checkForSyncResponses(MessageContext msgCtx) {
        block16: {
            if (log.isDebugEnabled()) {
                log.debug("Enter: SenderWorker::checkForSyncResponses, " + msgCtx.getEnvelope().getHeader());
            }
            try {
                boolean responsePresent;
                boolean bl = responsePresent = msgCtx.getProperty("TRANSPORT_IN") != null;
                if (!responsePresent) {
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: SenderWorker::checkForSyncResponses, no response present");
                    }
                    return;
                }
                MessageContext responseMessageContext = new MessageContext();
                responseMessageContext.setServerSide(true);
                responseMessageContext.setConfigurationContext(msgCtx.getConfigurationContext());
                responseMessageContext.setTransportIn(msgCtx.getTransportIn());
                responseMessageContext.setTransportOut(msgCtx.getTransportOut());
                responseMessageContext.setProperty("TRANSPORT_IN", msgCtx.getProperty("TRANSPORT_IN"));
                responseMessageContext.setServiceContext(msgCtx.getServiceContext());
                responseMessageContext.setServiceGroupContext(msgCtx.getServiceGroupContext());
                responseMessageContext.setProperty("Sandesha2MakeConnectionEntry", msgCtx.getProperty("Sandesha2MakeConnectionEntry"));
                String securityKey = "com.ibm.ws.wssecurity.WSS_RAMP_PROPERTYMAP";
                responseMessageContext.setProperty(securityKey, msgCtx.getProperty(securityKey));
                OperationContext requestMsgOpCtx = msgCtx.getOperationContext();
                responseMessageContext.setProperty("MTOM_RECEIVED", requestMsgOpCtx.getProperty("MTOM_RECEIVED"));
                responseMessageContext.setProperty(HTTPConstants.CHAR_SET_ENCODING, requestMsgOpCtx.getProperty(HTTPConstants.CHAR_SET_ENCODING));
                responseMessageContext.setProperty("ContentType", requestMsgOpCtx.getProperty("ContentType"));
                responseMessageContext.setDoingREST(msgCtx.isDoingREST());
                int mep = requestMsgOpCtx.getAxisOperation().getAxisSpecifMEPConstant();
                if (mep == 16) {
                    responseMessageContext.setOperationContext(requestMsgOpCtx);
                }
                SOAPEnvelope resenvelope = null;
                try {
                    resenvelope = TransportUtils.createSOAPMessage(responseMessageContext);
                }
                catch (AxisFault e) {
                    if (log.isDebugEnabled()) {
                        log.debug(SandeshaMessageHelper.getMessage("soapEnvNotSet"));
                        log.debug("Caught exception", e);
                    }
                    return;
                }
                if (resenvelope != null) {
                    StAXBuilder sb;
                    SOAPEnvelope env;
                    RMMsgContext responseRMMessage;
                    if (log.isDebugEnabled()) {
                        log.debug("Response " + resenvelope.getHeader());
                    }
                    responseMessageContext.setEnvelope(resenvelope);
                    Boolean addressingDisabled = (Boolean)msgCtx.getOptions().getProperty("disableAddressingForOutMessages");
                    if (addressingDisabled != null && Boolean.TRUE.equals(addressingDisabled)) {
                        OperationContext responseMsgOpCtx = requestMsgOpCtx;
                        if (requestMsgOpCtx.getAxisOperation().getMessageReceiver() == null) {
                            ServiceContext serviceCtx = responseMessageContext.getServiceContext();
                            AxisOperation op = msgCtx.getAxisService().getOperation(Sandesha2Constants.RM_IN_ONLY_OPERATION);
                            responseMsgOpCtx = ContextFactory.createOperationContext(op, serviceCtx);
                        }
                        responseMessageContext.setOperationContext(responseMsgOpCtx);
                    }
                    if ((responseRMMessage = MsgInitializer.initializeMessage(responseMessageContext)).getMessageType() == 4) {
                        responseMessageContext.setAxisOperation(SpecSpecificConstants.getWSRMOperation(4, responseRMMessage.getRMSpecVersion(), responseMessageContext.getAxisService()));
                        responseMessageContext.setOperationContext(null);
                    }
                    AxisEngine engine2 = new AxisEngine(msgCtx.getConfigurationContext());
                    Handler.InvocationResponse response = null;
                    response = this.isFaultEnvelope(resenvelope) ? engine2.receiveFault(responseMessageContext) : engine2.receive(responseMessageContext);
                    if (!Handler.InvocationResponse.SUSPEND.equals(response) && (env = responseMessageContext.getEnvelope()) != null && (sb = (StAXBuilder)responseMessageContext.getEnvelope().getBuilder()) != null) {
                        sb.close();
                    }
                }
            }
            catch (Exception e) {
                String message = SandeshaMessageHelper.getMessage("noValidSyncResponse");
                if (!log.isDebugEnabled()) break block16;
                log.debug(message, e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SenderWorker::checkForSyncResponses");
        }
    }

    private boolean isFaultEnvelope(SOAPEnvelope envelope) {
        SOAPFault fault;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SenderWorker::isFaultEnvelope, " + envelope.getBody().getFault());
        }
        if ((fault = envelope.getBody().getFault()) != null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: SenderWorker::isFaultEnvelope, TRUE");
            }
            return true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SenderWorker::isFaultEnvelope, FALSE");
        }
        return false;
    }
}

