/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import java.util.ArrayList;
import java.util.List;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.transport.RequestResponseTransport;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SequenceManager;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.SenderWorker;
import org.apache.sandesha2.workers.SequenceEntry;

public class Sender
extends SandeshaThread {
    private static final Log log = LogFactory.getLog(Sender.class);
    int nextIndex = 0;
    boolean processedMessage = false;
    long lastHousekeeping = 0L;
    private static int HOUSEKEEPING_INTERVAL = 20000;

    public Sender() {
        super(500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalRun() {
        String message;
        if (log.isDebugEnabled()) {
            log.debug("Enter: Sender::internalRun");
        }
        Transaction transaction = null;
        boolean sleep = false;
        try {
            RMSequenceBean matcher;
            ArrayList allSequencesList = this.getSequences();
            int size = allSequencesList.size();
            if (log.isDebugEnabled()) {
                log.debug("Choosing one from " + size + " sequences");
            }
            if (this.nextIndex >= size) {
                this.nextIndex = 0;
                if (size == 0 || !this.processedMessage) {
                    sleep = true;
                }
                this.processedMessage = false;
                if (System.currentTimeMillis() - this.lastHousekeeping > (long)HOUSEKEEPING_INTERVAL) {
                    this.deleteTerminatedSequences(this.storageManager);
                    this.unblockTransportThreads(this.storageManager);
                    this.checkForOrphanMessages(this.storageManager);
                    this.lastHousekeeping = System.currentTimeMillis();
                }
                if (log.isDebugEnabled()) {
                    log.debug("Exit: Sender::internalRun, looped over all sequences, sleep " + sleep);
                }
                boolean bl = sleep;
                return bl;
            }
            SequenceEntry entry = (SequenceEntry)allSequencesList.get(this.nextIndex++);
            String sequenceId = entry.getSequenceId();
            if (log.isDebugEnabled()) {
                log.debug("Chose sequence " + sequenceId);
            }
            transaction = this.storageManager.getTransaction();
            String rmVersion = null;
            boolean found = false;
            if (entry.isRmSource()) {
                matcher = new RMSBean();
                ((RMSBean)matcher).setInternalSequenceID(sequenceId);
                matcher.setTerminated(false);
                RMSBean rms = this.storageManager.getRMSBeanMgr().findUnique((RMSBean)matcher);
                if (rms != null && !rms.isTerminated() && !rms.isTimedOut()) {
                    sequenceId = rms.getSequenceID();
                    if (SequenceManager.hasSequenceTimedOut(rms, sequenceId, this.storageManager)) {
                        SequenceManager.finalizeTimedOutSequence(rms.getInternalSequenceID(), null, this.storageManager);
                    } else {
                        found = true;
                    }
                    rmVersion = rms.getRMVersion();
                }
            } else {
                matcher = new RMDBean();
                matcher.setSequenceID(sequenceId);
                matcher.setTerminated(false);
                RMDBean rmd = this.storageManager.getRMDBeanMgr().findUnique((RMDBean)matcher);
                if (rmd != null) {
                    found = true;
                    rmVersion = rmd.getRMVersion();
                }
            }
            if (!found) {
                this.stopThreadForSequence(sequenceId, entry.isRmSource());
                if (log.isDebugEnabled()) {
                    log.debug("Exit: Sender::internalRun, sequence has ended");
                }
                boolean matcher2 = false;
                return matcher2;
            }
            SenderBeanMgr mgr = this.storageManager.getSenderBeanMgr();
            SenderBean senderBean = mgr.getNextMsgToSend(sequenceId);
            if (senderBean == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Exit: Sender::internalRun, no message for this sequence");
                }
                boolean message2 = false;
                return message2;
            }
            String workId = senderBean.getMessageID() + senderBean.getTimeToSend();
            if (this.getWorkerLock().isWorkPresent(workId)) {
                if (log.isDebugEnabled()) {
                    String message3 = SandeshaMessageHelper.getMessage("workAlreadyAssigned", workId);
                    log.debug("Exit: Sender::internalRun, " + message3 + ", sleeping");
                }
                boolean message3 = true;
                return message3;
            }
            if (transaction != null) {
                transaction.commit();
                transaction = null;
            }
            SenderWorker worker = new SenderWorker(this.context, senderBean, rmVersion);
            worker.setLock(this.getWorkerLock());
            worker.setWorkId(workId);
            try {
                this.getWorkerLock().addWork(workId, worker);
                this.threadPool.execute(worker);
            }
            catch (Exception e) {
                this.getWorkerLock().removeWork(workId);
            }
            this.processedMessage = true;
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (Exception e) {
            message = SandeshaMessageHelper.getMessage("sendMsgError", e.toString());
            log.debug(message, e);
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                try {
                    transaction.rollback();
                    transaction = null;
                }
                catch (Exception e) {
                    message = SandeshaMessageHelper.getMessage("rollbackError", e.toString());
                    log.debug(message, e);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Sender::internalRun, not sleeping");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteTerminatedSequences(StorageManager storageManager) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: Sender::deleteTerminatedSequences");
        }
        RMSBean finderBean = new RMSBean();
        finderBean.setTerminated(true);
        Transaction transaction = null;
        try {
            transaction = storageManager.getTransaction();
            SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean(storageManager.getContext().getAxisConfiguration());
            long deleteTime = propertyBean.getSequenceRemovalTimeoutInterval();
            if (deleteTime < 0L) {
                deleteTime = 0L;
            }
            if (deleteTime > 0L) {
                List rmsBeans = storageManager.getRMSBeanMgr().find(finderBean);
                this.deleteRMSBeans(rmsBeans, propertyBean, deleteTime);
                finderBean.setTerminated(false);
                finderBean.setTimedOut(true);
                rmsBeans = storageManager.getRMSBeanMgr().find(finderBean);
                this.deleteRMSBeans(rmsBeans, propertyBean, deleteTime);
                RMDBean finderRMDBean = new RMDBean();
                finderRMDBean.setTerminated(true);
                List rmdBeans = storageManager.getRMDBeanMgr().find(finderRMDBean);
                for (RMDBean rmdBean : rmdBeans) {
                    long timeNow = System.currentTimeMillis();
                    long lastActivated = rmdBean.getLastActivatedTime();
                    if (lastActivated + deleteTime >= timeNow) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Deleting RMDBean " + deleteTime + " : " + rmdBean);
                    }
                    storageManager.getRMDBeanMgr().delete(rmdBean.getSequenceID());
                }
            }
            if (propertyBean.getInactivityTimeoutInterval() > 0L) {
                RMDBean finderRMDBean = new RMDBean();
                finderRMDBean.setTerminated(false);
                List rmdBeans = storageManager.getRMDBeanMgr().find(finderRMDBean);
                for (RMDBean rmdBean : rmdBeans) {
                    long timeNow = System.currentTimeMillis();
                    long lastActivated = rmdBean.getLastActivatedTime();
                    if (lastActivated + propertyBean.getInactivityTimeoutInterval() >= timeNow) continue;
                    rmdBean.setTerminated(true);
                    rmdBean.setLastActivatedTime(timeNow);
                    if (log.isDebugEnabled()) {
                        log.debug(System.currentTimeMillis() + "Marking RMDBean as terminated " + rmdBean);
                    }
                    storageManager.getRMDBeanMgr().update(rmdBean);
                }
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (SandeshaException e) {
            if (log.isErrorEnabled()) {
                log.error(e);
            }
        }
        finally {
            block24: {
                if (transaction != null && transaction.isActive()) {
                    try {
                        transaction.rollback();
                    }
                    catch (SandeshaStorageException e) {
                        if (!log.isDebugEnabled()) break block24;
                        log.debug("Caught exception rolling back transaction", e);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Sender::deleteTerminatedSequences");
        }
    }

    private void deleteRMSBeans(List rmsBeans, SandeshaPolicyBean propertyBean, long deleteTime) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: Sender::deleteRMSBeans");
        }
        for (RMSBean rmsBean : rmsBeans) {
            long timeNow = System.currentTimeMillis();
            long lastActivated = rmsBean.getLastActivatedTime();
            if (lastActivated + deleteTime >= timeNow) continue;
            if (log.isDebugEnabled()) {
                log.debug("Removing RMSBean " + rmsBean);
            }
            this.storageManager.getRMSBeanMgr().delete(rmsBean.getCreateSeqMsgID());
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Sender::deleteRMSBeans");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unblockTransportThreads(StorageManager manager) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: Sender::unblockTransportThreads");
        }
        Transaction transaction = null;
        try {
            transaction = manager.getTransaction();
            SenderBean finder = new SenderBean();
            finder.setSend(false);
            finder.setTransportAvailable(true);
            finder.setTimeToSend(System.currentTimeMillis() - 60000L);
            List beans = manager.getSenderBeanMgr().find(finder);
            for (SenderBean bean : beans) {
                MessageContext msgCtx = manager.retrieveMessageContext(bean.getMessageContextRefKey(), this.context);
                RequestResponseTransport t = null;
                MessageContext inMsg = null;
                OperationContext op = msgCtx.getOperationContext();
                if (op != null) {
                    inMsg = op.getMessageContext("In");
                }
                if (inMsg != null) {
                    t = (RequestResponseTransport)inMsg.getProperty("RequestResponseTransportControl");
                }
                if (t == null || !RequestResponseTransport.RequestResponseTransportStatus.WAITING.equals(t.getStatus())) continue;
                if (log.isWarnEnabled()) {
                    String message = SandeshaMessageHelper.getMessage("freeingTransport");
                    log.warn(message);
                }
                boolean sendAck = false;
                RMDBean inbound = null;
                String inboundSeq = bean.getInboundSequenceId();
                if (inboundSeq != null) {
                    inbound = SandeshaUtil.getRMDBeanFromSequenceId(manager, inboundSeq);
                }
                if (inbound != null) {
                    String acksTo = inbound.getAcksToEPR();
                    EndpointReference acksToEPR = new EndpointReference(acksTo);
                    if (acksTo == null || acksToEPR.hasAnonymousAddress()) {
                        sendAck = true;
                    }
                }
                if (sendAck) {
                    RMMsgContext rmMsgCtx = MsgInitializer.initializeMessage(msgCtx);
                    RMMsgContext ackRMMsgCtx = AcknowledgementManager.generateAckMessage(rmMsgCtx, inbound, inbound.getSequenceID(), this.storageManager, true);
                    AcknowledgementManager.sendAckNow(ackRMMsgCtx);
                    TransportUtils.setResponseWritten(msgCtx, true);
                    t.signalResponseReady();
                } else {
                    TransportUtils.setResponseWritten(msgCtx, false);
                    t.acknowledgeMessage(msgCtx);
                }
                bean.setTransportAvailable(false);
                bean.setTimeToSend(System.currentTimeMillis());
                manager.getSenderBeanMgr().update(bean);
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception", e);
            }
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Sender::unblockTransportThreads");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkForOrphanMessages(StorageManager manager) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: Sender::checkForOrphanMessages");
        }
        Transaction tran = null;
        try {
            tran = manager.getTransaction();
            SenderBean finder = new SenderBean();
            finder.setSend(true);
            finder.setTransportAvailable(false);
            finder.setTimeToSend(System.currentTimeMillis() - 60000L);
            List beans = manager.getSenderBeanMgr().find(finder);
            for (SenderBean bean : beans) {
                if (log.isWarnEnabled()) {
                    String message = null;
                    if (bean.getMessageType() == 3) {
                        message = SandeshaMessageHelper.getMessage("noPolling");
                    } else {
                        String messageType = Integer.toString(bean.getMessageType());
                        message = SandeshaMessageHelper.getMessage("noPollingProtocol", messageType);
                    }
                    log.warn(message);
                }
                bean.setTimeToSend(System.currentTimeMillis());
                manager.getSenderBeanMgr().update(bean);
            }
            if (tran != null && tran.isActive()) {
                tran.commit();
            }
            tran = null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception", e);
            }
        }
        finally {
            if (tran != null && tran.isActive()) {
                tran.rollback();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: Sender::checkForOrphanMessages");
        }
    }
}

