/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.context.ContextManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.workers.SandeshaWorker;
import org.apache.sandesha2.workers.WorkerLock;
import org.apache.sandesha2.wsrm.Sequence;

public class InvokerWorker
extends SandeshaWorker
implements Runnable {
    static final Log log = LogFactory.getLog(InvokerWorker.class);
    static final WorkerLock lock = new WorkerLock();
    ConfigurationContext configurationContext;
    String sequence;
    long messageNumber;
    String messageContextKey;
    boolean ignoreNextMsg;
    boolean pooledThread;
    boolean lastMessageInvoked;

    public InvokerWorker(ConfigurationContext configurationContext, InvokerBean bean) {
        this.setLock(lock);
        this.configurationContext = configurationContext;
        this.initializeFromBean(bean);
    }

    public void forceOutOfOrder() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InvokerWorker::forceOutOfOrder");
        }
        this.ignoreNextMsg = true;
        if (log.isDebugEnabled()) {
            log.debug("Exit: InvokerWorker::forceOutOfOrder");
        }
    }

    public void setPooled() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InvokerWorker::setPooled");
        }
        this.pooledThread = true;
        if (log.isDebugEnabled()) {
            log.debug("Exit: InvokerWorker::setPooled");
        }
    }

    private void initializeFromBean(InvokerBean bean) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InvokerWorker::initializeFromBean " + bean);
        }
        this.sequence = bean.getSequenceID();
        this.messageNumber = bean.getMsgNo();
        this.messageContextKey = bean.getMessageContextRefKey();
        if (log.isDebugEnabled()) {
            log.debug("Exit: InvokerWorker::initializeFromBean");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InvokerWorker::run, message " + this.messageNumber + ", sequence " + this.sequence);
        }
        Transaction tran = null;
        try {
            InvokerWorker nextWorker = null;
            Runnable nextRunnable = null;
            this.lastMessageInvoked = this.invokeMessage(null);
            while (!this.ignoreNextMsg && this.lastMessageInvoked) {
                if (log.isDebugEnabled()) {
                    log.debug("InvokerWorker:: looking for next msg to invoke");
                }
                InvokerBean finder = new InvokerBean();
                finder.setSequenceID(this.sequence);
                finder.setMsgNo(this.messageNumber + 1L);
                StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(this.configurationContext, this.configurationContext.getAxisConfiguration());
                tran = storageManager.getTransaction();
                InvokerBeanMgr mgr = storageManager.getInvokerBeanMgr();
                InvokerBean nextBean = mgr.findUnique(finder);
                if (nextBean != null) {
                    if (this.pooledThread) {
                        if (log.isDebugEnabled()) {
                            log.debug("InvokerWorker:: pooledThread");
                        }
                        this.initializeFromBean(nextBean);
                        final Transaction theTran = tran;
                        Runnable work = new Runnable(){

                            public void run() {
                                InvokerWorker.this.lastMessageInvoked = InvokerWorker.this.invokeMessage(theTran);
                            }
                        };
                        ContextManager contextMgr = SandeshaUtil.getContextManager(this.configurationContext);
                        if (contextMgr != null) {
                            work = contextMgr.wrapWithContext(work, nextBean.getContext());
                        }
                        work.run();
                        tran = null;
                    } else {
                        if (log.isDebugEnabled()) {
                            log.debug("InvokerWorker:: not pooled thread");
                        }
                        nextWorker = new InvokerWorker(this.configurationContext, nextBean);
                        nextWorker.setPooled();
                        nextWorker.setWorkId(this.workId);
                        ContextManager contextMgr = SandeshaUtil.getContextManager(this.configurationContext);
                        nextRunnable = contextMgr != null ? contextMgr.wrapWithContext(nextWorker, nextBean.getContext()) : nextWorker;
                    }
                }
                if (tran != null) {
                    tran.commit();
                }
                tran = null;
                if (nextBean != null && nextWorker == null) continue;
                break;
            }
            if (this.workId != null && lock != null) {
                lock.removeWork(this.workId);
            }
            if (nextWorker != null) {
                lock.addWork(this.workId, nextWorker);
                this.configurationContext.getThreadPool().execute(nextRunnable);
            }
        }
        catch (SandeshaException e) {
            log.debug("Exception within InvokerWorker", e);
            if (tran != null) {
                try {
                    tran.rollback();
                }
                catch (SandeshaException e2) {
                    log.debug("Exception rolling back tran", e2);
                }
            }
        }
        finally {
            if (this.workId != null && lock != null && lock.ownsLock(this.workId, this)) {
                lock.removeWork(this.workId);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: InvokerWorker::run");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeMessage(Transaction tran) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InvokerWorker::invokeMessage");
        }
        Transaction transaction = null;
        MessageContext msgToInvoke = null;
        boolean messageInvoked = true;
        if (lock != null && !lock.ownsLock(this.workId, this)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: InvokerWorker::run, another worker holds the lock");
            }
            return false;
        }
        try {
            StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(this.configurationContext, this.configurationContext.getAxisConfiguration());
            InvokerBeanMgr invokerBeanMgr = storageManager.getInvokerBeanMgr();
            transaction = tran == null ? storageManager.getTransaction() : tran;
            InvokerBean invokerBean = invokerBeanMgr.retrieve(this.messageContextKey);
            msgToInvoke = storageManager.retrieveMessageContext(this.messageContextKey, this.configurationContext);
            if (msgToInvoke == null) {
                if (log.isDebugEnabled()) {
                    log.debug("null msg");
                }
                boolean bl = false;
                return bl;
            }
            RMMsgContext rmMsg = MsgInitializer.initializeMessage(msgToInvoke);
            if (transaction != null) {
                transaction.commit();
                transaction = null;
            }
            transaction = storageManager.getTransaction();
            RMDBean rMDBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, invokerBean.getSequenceID());
            boolean highestMessage = false;
            if (!this.ignoreNextMsg) {
                long nextMsgNo = rMDBean.getNextMsgNoToProcess();
                if (invokerBean.getMsgNo() != nextMsgNo) {
                    if (log.isDebugEnabled()) {
                        log.debug("Operated message number is different from the Next Message Number to invoke");
                    }
                    boolean bl = false;
                    return bl;
                }
                rMDBean.setNextMsgNoToProcess(++nextMsgNo);
                storageManager.getRMDBeanMgr().update(rMDBean);
            }
            if (rmMsg.getMessageType() == 3) {
                Sequence sequence = (Sequence)rmMsg.getMessagePart(6);
                if (sequence.getLastMessage() != null) {
                    highestMessage = true;
                } else if (rMDBean != null && rMDBean.isTerminated()) {
                    long highestInMsgNo = rMDBean.getHighestInMessageNumber();
                    if (invokerBean.getMsgNo() == highestInMsgNo) {
                        highestMessage = true;
                    }
                }
            }
            invokerBeanMgr.delete(this.messageContextKey);
            storageManager.removeMessageContext(this.messageContextKey);
            try {
                StAXBuilder sb;
                SOAPEnvelope env;
                boolean postFailureInvocation = false;
                String postFaulureProperty = (String)msgToInvoke.getProperty("PostFailureMessage");
                if (postFaulureProperty != null && "true".equals(postFaulureProperty)) {
                    postFailureInvocation = true;
                }
                AxisEngine engine2 = new AxisEngine(msgToInvoke.getConfigurationContext());
                Handler.InvocationResponse response = null;
                if (postFailureInvocation) {
                    this.makeMessageReadyForReinjection(msgToInvoke);
                    if (log.isDebugEnabled()) {
                        log.debug("Receiving message, key=" + this.messageContextKey + ", msgCtx=" + msgToInvoke.getEnvelope().getHeader());
                    }
                    response = engine2.receive(msgToInvoke);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Resuming message, key=" + this.messageContextKey + ", msgCtx=" + msgToInvoke.getEnvelope().getHeader());
                    }
                    msgToInvoke.setPaused(false);
                    response = engine2.resumeReceive(msgToInvoke);
                }
                if (!Handler.InvocationResponse.SUSPEND.equals(response) && (env = msgToInvoke.getEnvelope()) != null && (sb = (StAXBuilder)msgToInvoke.getEnvelope().getBuilder()) != null) {
                    sb.close();
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                    transaction = storageManager.getTransaction();
                }
                if (highestMessage) {
                    TerminateManager.cleanReceivingSideAfterInvocation(invokerBean.getSequenceID(), storageManager);
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: InvokerWorker::invokeMessage Last message return " + messageInvoked);
                    }
                    boolean bl = messageInvoked;
                    return bl;
                }
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception :", e);
                }
                if (transaction != null && transaction.isActive()) {
                    transaction.rollback();
                }
                messageInvoked = false;
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (Exception e) {
            if (log.isErrorEnabled()) {
                log.error(e.toString(), e);
            }
        }
        finally {
            block52: {
                if (transaction != null && transaction.isActive()) {
                    try {
                        transaction.rollback();
                    }
                    catch (SandeshaStorageException e) {
                        if (!log.isWarnEnabled()) break block52;
                        log.warn("Caught exception rolling back transaction", e);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: InvokerWorker::invokeMessage " + messageInvoked);
        }
        return messageInvoked;
    }

    private void makeMessageReadyForReinjection(MessageContext messageContext) {
        messageContext.setProperty("WSAddressingVersion", null);
        messageContext.getOptions().setMessageId(null);
        messageContext.getOptions().setTo(null);
        messageContext.getOptions().setAction(null);
        messageContext.setProperty("Sandesha2AppProcessingDone", "true");
    }
}

