/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.workers;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.context.ContextManager;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.workers.InvokerWorker;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.SequenceEntry;

public class Invoker
extends SandeshaThread {
    private static final Log log = LogFactory.getLog(Invoker.class);
    int nextIndex = 0;
    boolean processedMessage = false;

    public Invoker() {
        super(1000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void forceInvokeOfAllMessagesCurrentlyOnSequence(ConfigurationContext ctx, String sequenceID, boolean allowLaterDeliveryOfMissingMessages) throws SandeshaException {
        block12: {
            StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(ctx, ctx.getAxisConfiguration());
            InvokerBeanMgr storageMapMgr = storageManager.getInvokerBeanMgr();
            RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
            RMDBean rMDBean = rmdBeanMgr.retrieve(sequenceID);
            if (rMDBean == null) break block12;
            long firstMessageInOutOfOrderWindow = rMDBean.getNextMsgNoToProcess();
            InvokerBean selector = new InvokerBean();
            selector.setSequenceID(sequenceID);
            Iterator stMapIt = storageMapMgr.find(selector).iterator();
            long highestMsgNumberInvoked = 0L;
            Transaction transaction = null;
            while (stMapIt.hasNext()) {
                try {
                    transaction = storageManager.getTransaction();
                    InvokerBean invoker = (InvokerBean)stMapIt.next();
                    String workId = sequenceID;
                    InvokerWorker worker = new InvokerWorker(ctx, invoker);
                    worker.forceOutOfOrder();
                    worker.setPooled();
                    worker.setWorkId(workId);
                    Runnable work = worker;
                    ContextManager contextMgr = SandeshaUtil.getContextManager(ctx);
                    if (contextMgr != null) {
                        work = contextMgr.wrapWithContext(work, invoker.getContext());
                    }
                    worker.getLock().addWork(workId, worker);
                    ctx.getThreadPool().execute(work);
                    long msgNumber = invoker.getMsgNo();
                    if (msgNumber > highestMsgNumberInvoked) {
                        highestMsgNumberInvoked = invoker.getMsgNo();
                        rMDBean.setNextMsgNoToProcess(highestMsgNumberInvoked + 1L);
                        if (allowLaterDeliveryOfMissingMessages) {
                            Range r = new Range(firstMessageInOutOfOrderWindow, highestMsgNumberInvoked);
                            RangeString rangeString = null;
                            rangeString = rMDBean.getOutOfOrderRanges() == null ? new RangeString() : rMDBean.getOutOfOrderRanges();
                            rangeString.addRange(r);
                            rMDBean.setOutOfOrderRanges(rangeString);
                        }
                        rmdBeanMgr.update(rMDBean);
                    }
                    if (transaction != null && transaction.isActive()) {
                        transaction.commit();
                    }
                    transaction = null;
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Exception", e);
                }
                finally {
                    if (transaction == null || !transaction.isActive()) continue;
                    transaction.rollback();
                    transaction = null;
                }
            }
        }
    }

    private void addOutOfOrderInvokerBeansToList(String sequenceID, StorageManager storageManager, List list) throws SandeshaException {
        RMDBean rmdBean;
        if (log.isDebugEnabled()) {
            log.debug("Enter: InOrderInvoker::addOutOfOrderInvokerBeansToList " + sequenceID + ", " + list);
        }
        if ((rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceID)) != null && rmdBean.getOutOfOrderRanges() != null) {
            RangeString rangeString = rmdBean.getOutOfOrderRanges();
            InvokerBean selector = new InvokerBean();
            selector.setSequenceID(sequenceID);
            for (InvokerBean invokerBean : storageManager.getInvokerBeanMgr().find(selector)) {
                if (!rangeString.isMessageNumberInRanges(invokerBean.getMsgNo())) continue;
                list.add(invokerBean);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: InOrderInvoker::addOutOfOrderInvokerBeansToList");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalRun() {
        String message;
        if (log.isDebugEnabled()) {
            log.debug("Enter: Invoker::internalRun");
        }
        boolean sleep = false;
        Transaction transaction = null;
        try {
            RMDBeanMgr nextMsgMgr = this.storageManager.getRMDBeanMgr();
            InvokerBeanMgr storageMapMgr = this.storageManager.getInvokerBeanMgr();
            transaction = this.storageManager.getTransaction();
            ArrayList allSequencesList = this.getSequences();
            int size = allSequencesList.size();
            log.debug("Choosing one from " + size + " sequences");
            if (this.nextIndex >= size) {
                this.nextIndex = 0;
                if (size == 0 || !this.processedMessage) {
                    sleep = true;
                }
                this.processedMessage = false;
                if (log.isDebugEnabled()) {
                    log.debug("Exit: Invoker::internalRun, looped over all sequences, sleep " + sleep);
                }
                boolean bl = sleep;
                return bl;
            }
            SequenceEntry entry = (SequenceEntry)allSequencesList.get(this.nextIndex++);
            String sequenceId = entry.getSequenceId();
            log.debug("Chose sequence " + sequenceId);
            RMDBean nextMsgBean = nextMsgMgr.retrieve(sequenceId);
            if (nextMsgBean == null) {
                log.debug("Next message not set correctly. Removing invalid entry.");
                this.stopThreadForSequence(sequenceId, entry.isRmSource());
                allSequencesList = this.getSequences();
                if (allSequencesList.size() == 0) {
                    sleep = true;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Exit: Invoker::internalRun, sleep " + sleep);
                }
                boolean bl = sleep;
                return bl;
            }
            long nextMsgno = nextMsgBean.getNextMsgNoToProcess();
            if (nextMsgno <= 0L) {
                sleep = true;
                if (log.isDebugEnabled()) {
                    log.debug("Invalid Next Message Number " + nextMsgno);
                }
                String message2 = SandeshaMessageHelper.getMessage("invalidMsgNumber", Long.toString(nextMsgno));
                throw new SandeshaException(message2);
            }
            InvokerBean selector = new InvokerBean();
            selector.setSequenceID(sequenceId);
            selector.setMsgNo(nextMsgno);
            List invokerBeans = storageMapMgr.find(selector);
            this.addOutOfOrderInvokerBeansToList(sequenceId, this.storageManager, invokerBeans);
            if (invokerBeans.size() == 0) {
                if (log.isDebugEnabled()) {
                    log.debug("Exit: Invoker::internalRun, no beans to invoke on sequence " + sequenceId + ", sleep " + sleep);
                }
                boolean bl = sleep;
                return bl;
            }
            Iterator stMapIt = invokerBeans.iterator();
            if (stMapIt.hasNext()) {
                InvokerBean bean = (InvokerBean)stMapIt.next();
                boolean beanIsOutOfOrderMsg = bean.getMsgNo() != nextMsgno;
                String workId = sequenceId;
                if (this.getWorkerLock().isWorkPresent(workId)) {
                    sleep = true;
                    String message3 = SandeshaMessageHelper.getMessage("workAlreadyAssigned", workId);
                    if (log.isDebugEnabled()) {
                        log.debug("Exit: Invoker::internalRun, " + message3 + ", sleep " + sleep);
                    }
                    boolean bl = sleep;
                    return bl;
                }
                if (transaction != null) {
                    transaction.commit();
                    transaction = null;
                }
                InvokerWorker worker = new InvokerWorker(this.context, bean);
                if (beanIsOutOfOrderMsg) {
                    worker.forceOutOfOrder();
                }
                worker.setPooled();
                worker.setWorkId(workId);
                Runnable work = worker;
                ContextManager contextMgr = SandeshaUtil.getContextManager(this.context);
                if (contextMgr != null) {
                    work = contextMgr.wrapWithContext(work, bean.getContext());
                }
                try {
                    if (worker.getLock().addWork(workId, worker)) {
                        this.threadPool.execute(work);
                    }
                }
                catch (Exception e) {
                    worker.getLock().removeWork(workId);
                }
                this.processedMessage = true;
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (Exception e) {
            message = SandeshaMessageHelper.getMessage("invokeMsgError");
            if (log.isDebugEnabled()) {
                log.debug(message, e);
            }
        }
        finally {
            block48: {
                if (transaction != null && transaction.isActive()) {
                    try {
                        transaction.rollback();
                    }
                    catch (Exception e) {
                        message = SandeshaMessageHelper.getMessage("rollbackError", e.toString());
                        if (!log.isDebugEnabled()) break block48;
                        log.debug(message, e);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: InOrderInvoker::internalRun");
        }
        return sleep;
    }
}

