/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SandeshaUtil;

public class WSRMMessageSender {
    private static final Log log = LogFactory.getLog(WSRMMessageSender.class);
    private MessageContext msgContext;
    private StorageManager storageManager;
    private ConfigurationContext configurationContext;
    private String toAddress;
    private String sequenceKey;
    private String internalSequenceID;
    private boolean sequenceExists;
    private String outSequenceID;
    private String rmVersion;
    private RMSBean rmsBean;

    protected void setupOutMessage(RMMsgContext rmMsgCtx) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: WSRMParentProcessor::setupOutMessage");
        }
        this.msgContext = rmMsgCtx.getMessageContext();
        this.configurationContext = this.msgContext.getConfigurationContext();
        Options options = this.msgContext.getOptions();
        this.storageManager = SandeshaUtil.getSandeshaStorageManager(this.configurationContext, this.configurationContext.getAxisConfiguration());
        this.internalSequenceID = (String)rmMsgCtx.getProperty("Sandesha2InternalSequenceId");
        this.toAddress = rmMsgCtx.getTo().getAddress();
        this.sequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
        if (this.sequenceKey == null) {
            this.sequenceKey = (String)this.configurationContext.getAxisConfiguration().getParameterValue(SandeshaClientConstants.SEQUENCE_KEY);
        }
        if (this.internalSequenceID == null) {
            this.internalSequenceID = SandeshaUtil.getInternalSequenceID(this.toAddress, this.sequenceKey);
        }
        this.sequenceExists = false;
        this.outSequenceID = null;
        this.rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(this.storageManager, this.internalSequenceID);
        if (this.rmsBean == null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: WSRMParentProcessor::setupOutMessage Sequence doesn't exist");
            }
            throw new SandeshaException(SandeshaMessageHelper.getMessage("couldNotSendTerminateSeqNotFound", this.internalSequenceID));
        }
        if (this.rmsBean.getSequenceID() != null) {
            this.sequenceExists = true;
            this.outSequenceID = this.rmsBean.getSequenceID();
        } else {
            this.outSequenceID = "uuid:tempID";
        }
        this.rmVersion = this.rmsBean.getRMVersion();
        if (this.rmVersion == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotDecideRMVersion"));
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: WSRMParentProcessor::setupOutMessage");
        }
    }

    protected void sendOutgoingMessage(RMMsgContext rmMsgCtx, int msgType, long delay) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: WSRMParentProcessor::sendOutgoingMessage " + msgType + ", " + delay);
        }
        rmMsgCtx.setFlow(2);
        this.getMsgContext().setProperty("Sandesha2AppProcessingDone", "true");
        rmMsgCtx.setTo(new EndpointReference(this.toAddress));
        String transportTo = this.rmsBean.getTransportTo();
        if (transportTo != null) {
            rmMsgCtx.setProperty("TransportURL", transportTo);
        }
        rmMsgCtx.setProperty("WSRMSequenceId", this.outSequenceID);
        rmMsgCtx.setProperty("Sandesha2InternalSequenceId", this.internalSequenceID);
        rmMsgCtx.addSOAPEnvelope();
        RMMsgCreator.secureOutboundMessage(this.getRMSBean(), this.msgContext);
        String key = SandeshaUtil.getUUID();
        SenderBean senderBean = new SenderBean();
        senderBean.setMessageType(msgType);
        senderBean.setMessageContextRefKey(key);
        senderBean.setTimeToSend(System.currentTimeMillis() + delay);
        senderBean.setMessageID(this.msgContext.getMessageID());
        senderBean.setInternalSequenceID(this.internalSequenceID);
        if (this.sequenceExists) {
            senderBean.setSend(true);
            senderBean.setSequenceID(this.outSequenceID);
        } else {
            senderBean.setSend(false);
        }
        EndpointReference to = this.msgContext.getTo();
        if (to != null) {
            senderBean.setToAddress(to.getAddress());
        }
        if (to == null || to.hasAnonymousAddress()) {
            senderBean.setTransportAvailable(false);
        }
        this.msgContext.setProperty("Sandesha2QualifiedForSending", "false");
        senderBean.setReSend(false);
        SenderBeanMgr retramsmitterMgr = this.storageManager.getSenderBeanMgr();
        SandeshaUtil.executeAndStore(rmMsgCtx, key, this.storageManager);
        retramsmitterMgr.insert(senderBean);
        if (log.isDebugEnabled()) {
            log.debug("Exit: WSRMParentProcessor::sendOutgoingMessage");
        }
    }

    public final StorageManager getStorageManager() {
        return this.storageManager;
    }

    public final String getInternalSequenceID() {
        return this.internalSequenceID;
    }

    public final MessageContext getMsgContext() {
        return this.msgContext;
    }

    public final String getOutSequenceID() {
        return this.outSequenceID;
    }

    public final boolean isSequenceExists() {
        return this.sequenceExists;
    }

    public final String getSequenceKey() {
        return this.sequenceKey;
    }

    public final String getToAddress() {
        return this.toAddress;
    }

    public final ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    public final String getRMVersion() {
        return this.rmVersion;
    }

    public final RMSBean getRMSBean() {
        return this.rmsBean;
    }
}

