/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.HashMap;
import java.util.List;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.AcknowledgementManager;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;

public class TerminateManager {
    private static Log log = LogFactory.getLog(TerminateManager.class);
    private static String CLEANED_ON_TERMINATE_MSG = "CleanedOnTerminateMsg";
    private static String CLEANED_AFTER_INVOCATION = "CleanedAfterInvocation";
    public static HashMap receivingSideCleanMap = new HashMap();

    public static void checkAndTerminate(RMMsgContext relatedMessage, StorageManager storageManager, RMSBean rmsBean) throws SandeshaStorageException, AxisFault {
        long lastOutMessage;
        if (log.isDebugEnabled()) {
            log.debug("Enter: TerminateManager::checkAndTerminate " + rmsBean);
        }
        if ((lastOutMessage = rmsBean.getLastOutMessage()) > 0L && !rmsBean.isTerminateAdded()) {
            boolean complete = AcknowledgementManager.verifySequenceCompletion(rmsBean.getClientCompletedMessages(), lastOutMessage);
            String rmVersion = rmsBean.getRMVersion();
            String replyToAddress = rmsBean.getReplyToEPR();
            if (complete && "Spec_2007_02".equals(rmVersion) && SandeshaUtil.isWSRMAnonymous(replyToAddress)) {
                RMDBean findBean = new RMDBean();
                findBean.setPollingMode(true);
                findBean.setToAddress(replyToAddress);
                RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
                List beans = rmdBeanMgr.find(findBean);
                if (beans.isEmpty()) {
                    rmsBean.setTerminationPauserForCS(true);
                    storageManager.getRMSBeanMgr().update(rmsBean);
                    complete = false;
                }
            }
            EndpointReference replyTo = new EndpointReference(replyToAddress);
            if (complete && "Spec_2005_02".equals(rmVersion) && replyTo.hasAnonymousAddress()) {
                SenderBean matcher = new SenderBean();
                matcher.setMessageType(3);
                matcher.setSequenceID(rmsBean.getSequenceID());
                List matches = storageManager.getSenderBeanMgr().find(matcher);
                if (!matches.isEmpty()) {
                    complete = false;
                }
            }
            if (complete) {
                TerminateManager.addTerminateSequenceMessage(relatedMessage, rmsBean.getInternalSequenceID(), rmsBean.getSequenceID(), storageManager);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: TerminateManager::checkAndTerminate");
        }
    }

    public static void cleanReceivingSideOnTerminateMessage(ConfigurationContext configContext, String sequenceId, StorageManager storageManager) throws SandeshaException {
        SenderBean findAckBean = new SenderBean();
        findAckBean.setSequenceID(sequenceId);
        findAckBean.setMessageType(4);
        SenderBeanMgr senderBeanMgr = storageManager.getSenderBeanMgr();
        for (SenderBean ackBean : senderBeanMgr.find(findAckBean)) {
            senderBeanMgr.delete(ackBean.getMessageID());
            storageManager.removeMessageContext(ackBean.getMessageContextRefKey());
        }
        boolean inOrderInvocation = SandeshaUtil.getDefaultPropertyBean(configContext.getAxisConfiguration()).isInOrder();
        if (!inOrderInvocation) {
            receivingSideCleanMap.put(sequenceId, CLEANED_ON_TERMINATE_MSG);
            TerminateManager.cleanReceivingSideAfterInvocation(sequenceId, storageManager);
        } else {
            String cleanStatus = (String)receivingSideCleanMap.get(sequenceId);
            if (cleanStatus != null && CLEANED_AFTER_INVOCATION.equals(cleanStatus)) {
                receivingSideCleanMap.remove(sequenceId);
            } else {
                receivingSideCleanMap.put(sequenceId, CLEANED_ON_TERMINATE_MSG);
            }
        }
    }

    public static void cleanReceivingSideAfterInvocation(String sequenceId, StorageManager storageManager) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: TerminateManager::cleanReceivingSideAfterInvocation " + sequenceId);
        }
        InvokerBeanMgr invokerBeanMgr = storageManager.getInvokerBeanMgr();
        InvokerBean invokerFindBean = new InvokerBean();
        invokerFindBean.setSequenceID(sequenceId);
        List collection = invokerBeanMgr.find(invokerFindBean);
        for (InvokerBean invokerBean : collection) {
            String messageStoreKey = invokerBean.getMessageContextRefKey();
            invokerBeanMgr.delete(messageStoreKey);
            storageManager.removeMessageContext(messageStoreKey);
        }
        String cleanStatus = (String)receivingSideCleanMap.get(sequenceId);
        if (cleanStatus != null && CLEANED_ON_TERMINATE_MSG.equals(cleanStatus)) {
            receivingSideCleanMap.remove(sequenceId);
        } else {
            receivingSideCleanMap.put(sequenceId, CLEANED_AFTER_INVOCATION);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: TerminateManager::cleanReceivingSideAfterInvocation");
        }
    }

    public static void terminateSendingSide(RMSBean rmsBean, StorageManager storageManager) throws SandeshaException {
        rmsBean.setTerminated(true);
        rmsBean.setTerminateAdded(true);
        storageManager.getRMSBeanMgr().update(rmsBean);
        TerminateManager.cleanSendingSideData(rmsBean.getInternalSequenceID(), storageManager);
    }

    public static void timeOutSendingSideSequence(String internalSequenceId, StorageManager storageManager) throws SandeshaException {
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
        rmsBean.setTimedOut(true);
        rmsBean.setLastActivatedTime(System.currentTimeMillis());
        storageManager.getRMSBeanMgr().update(rmsBean);
        TerminateManager.cleanSendingSideData(internalSequenceId, storageManager);
    }

    private static void cleanSendingSideData(String internalSequenceId, StorageManager storageManager) throws SandeshaException {
        SenderBeanMgr retransmitterBeanMgr = storageManager.getSenderBeanMgr();
        List collection = retransmitterBeanMgr.find(internalSequenceId);
        for (SenderBean retransmitterBean : collection) {
            retransmitterBeanMgr.delete(retransmitterBean.getMessageID());
            String messageStoreKey = retransmitterBean.getMessageContextRefKey();
            storageManager.removeMessageContext(messageStoreKey);
        }
    }

    public static void addTerminateSequenceMessage(RMMsgContext referenceMessage, String internalSequenceID, String outSequenceId, StorageManager storageManager) throws AxisFault {
        RMSBean rmsBean;
        if (log.isDebugEnabled()) {
            log.debug("Enter: TerminateManager::addTerminateSequenceMessage " + outSequenceId + ", " + internalSequenceID);
        }
        if ((rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceID)).isTerminateAdded()) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: TerminateManager::addTerminateSequenceMessage - terminate was added previously.");
            }
            return;
        }
        RMMsgContext terminateRMMessage = RMMsgCreator.createTerminateSequenceMessage(referenceMessage, rmsBean, storageManager);
        terminateRMMessage.setFlow(2);
        terminateRMMessage.setProperty("Sandesha2AppProcessingDone", "true");
        EndpointReference toEPR = null;
        if (rmsBean.getOfferedEndPoint() != null) {
            toEPR = new EndpointReference(rmsBean.getOfferedEndPoint());
        }
        if (toEPR == null && rmsBean.getToEPR() != null && (toEPR = new EndpointReference(rmsBean.getToEPR())) == null) {
            String message = SandeshaMessageHelper.getMessage("toEPRNotValid", null);
            throw new SandeshaException(message);
        }
        if (toEPR != null) {
            terminateRMMessage.setTo(toEPR);
        }
        if (rmsBean.getReplyToEPR() != null) {
            terminateRMMessage.setReplyTo(new EndpointReference(rmsBean.getReplyToEPR()));
        }
        String rmVersion = rmsBean.getRMVersion();
        terminateRMMessage.setWSAAction(SpecSpecificConstants.getTerminateSequenceAction(rmVersion));
        terminateRMMessage.setSOAPAction(SpecSpecificConstants.getTerminateSequenceSOAPAction(rmVersion));
        if (rmsBean.getTransportTo() != null) {
            terminateRMMessage.setProperty("TransportURL", rmsBean.getTransportTo());
        }
        terminateRMMessage.addSOAPEnvelope();
        String key = SandeshaUtil.getUUID();
        SenderBean terminateBean = new SenderBean();
        terminateBean.setInternalSequenceID(internalSequenceID);
        terminateBean.setSequenceID(outSequenceId);
        terminateBean.setMessageContextRefKey(key);
        terminateBean.setMessageType(7);
        terminateBean.setTimeToSend(System.currentTimeMillis() + 100L);
        terminateBean.setMessageID(terminateRMMessage.getMessageId());
        terminateBean.setSend(true);
        terminateRMMessage.getMessageContext().setProperty("Sandesha2QualifiedForSending", "false");
        terminateBean.setReSend(false);
        terminateBean.setSequenceID(outSequenceId);
        terminateBean.setMessageType(7);
        terminateBean.setInternalSequenceID(internalSequenceID);
        EndpointReference to = terminateRMMessage.getTo();
        if (to != null) {
            terminateBean.setToAddress(to.getAddress());
        }
        if (to == null || to.hasAnonymousAddress()) {
            terminateBean.setTransportAvailable(false);
        }
        rmsBean.setTerminateAdded(true);
        storageManager.getRMSBeanMgr().update(rmsBean);
        terminateRMMessage.setProperty("Sandesha2SetSendToTrue", "true");
        SandeshaUtil.executeAndStore(terminateRMMessage, key, storageManager);
        SenderBeanMgr retramsmitterMgr = storageManager.getSenderBeanMgr();
        retramsmitterMgr.insert(terminateBean);
        if (log.isDebugEnabled()) {
            log.debug("Exit: TerminateManager::addTerminateSequenceMessage");
        }
    }
}

