/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.util.CopyUtils;
import org.apache.axiom.om.util.UUIDGenerator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.context.ServiceGroupContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisServiceGroup;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.engine.Handler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.addressing.EPRDecorator;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.context.ContextManager;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.RMSequenceBean;
import org.apache.sandesha2.transport.Sandesha2TransportOutDesc;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.AcknowledgementRange;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.CloseSequenceResponse;
import org.apache.sandesha2.wsrm.Sequence;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;

public class SandeshaUtil {
    private static Log log = LogFactory.getLog(SandeshaUtil.class);
    private static AxisModule axisModule = null;

    private SandeshaUtil() {
    }

    public static AxisModule getAxisModule() {
        return axisModule;
    }

    public static void setAxisModule(AxisModule module) {
        axisModule = module;
    }

    public static String getUUID() {
        String uuid = UUIDGenerator.getUUID();
        return uuid;
    }

    public static ArrayList getAckRangeArrayList(RangeString completedMessageRanges, String rmNamespaceValue) throws SandeshaException {
        ArrayList<AcknowledgementRange> ackRanges = new ArrayList<AcknowledgementRange>();
        Range[] ranges = completedMessageRanges.getRanges();
        for (int i = 0; i < ranges.length; ++i) {
            AcknowledgementRange ackRange = new AcknowledgementRange(rmNamespaceValue);
            ackRange.setLowerValue(ranges[i].lowerValue);
            ackRange.setUpperValue(ranges[i].upperValue);
            ackRanges.add(ackRange);
        }
        return ackRanges;
    }

    public static void startWorkersForSequence(ConfigurationContext context, RMSequenceBean sequence) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaUtil::startWorkersForSequence, sequence " + sequence);
        }
        StorageManager mgr = SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration());
        boolean polling = sequence.isPollingMode();
        SandeshaThread sender = mgr.getSender();
        SandeshaThread invoker = mgr.getInvoker();
        PollingManager pollMgr = mgr.getPollingManager();
        if (polling && pollMgr == null) {
            String message = SandeshaMessageHelper.getMessage("makeConnectionDisabled");
            throw new SandeshaException(message);
        }
        if (sequence instanceof RMSBean) {
            String sequenceId = ((RMSBean)sequence).getInternalSequenceID();
            sender.runThreadForSequence(context, sequenceId, true);
            if (polling) {
                pollMgr.runThreadForSequence(context, sequenceId, true);
            }
        } else {
            String sequenceId = sequence.getSequenceID();
            sender.runThreadForSequence(context, sequenceId, false);
            if (invoker != null) {
                invoker.runThreadForSequence(context, sequenceId, false);
            }
            if (polling) {
                pollMgr.runThreadForSequence(context, sequenceId, false);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaUtil::startWorkersForSequence");
        }
    }

    public static String getMessageTypeString(int messageType) {
        switch (messageType) {
            case 1: {
                return "CreateSequence";
            }
            case 2: {
                return "CreateSequenceResponse";
            }
            case 4: {
                return "Acknowledgement";
            }
            case 3: {
                return "Application";
            }
            case 7: {
                return "TerminateSequence";
            }
            case 8: {
                return "AckRequest";
            }
            case 5: {
                return "CloseSequence";
            }
            case 6: {
                return "CloseSequenceResponse";
            }
            case 9: {
                return "TerminateSequenceResponse";
            }
            case 10: {
                return "Fault";
            }
            case 11: {
                return "MakeConnection";
            }
            case 12: {
                return "LastMessage";
            }
            case 0: {
                return "Unknown";
            }
        }
        return "Error";
    }

    public static String getServerSideIncomingSeqIdFromInternalSeqId(String internalSequenceId) throws SandeshaException {
        String startStr = "Sandesha2InternalSequence:";
        if (!internalSequenceId.startsWith(startStr)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("invalidInternalSequenceID", internalSequenceId));
        }
        String incomingSequenceId = internalSequenceId.substring(startStr.length());
        return incomingSequenceId;
    }

    public static StorageManager getSandeshaStorageManager(ConfigurationContext context, AxisDescription description) throws SandeshaException {
        String STORAGE_MANAGER_INSTANCE = "storageManagerInstance";
        StorageManager storageManagerInstance = (StorageManager)context.getProperty("storageManagerInstance");
        if (storageManagerInstance == null) {
            String value;
            Parameter parameter = description.getParameter("Sandesha2StorageManager");
            if (parameter == null) {
                parameter = new Parameter("Sandesha2StorageManager", "inmemory");
            }
            if ("inmemory".equals(value = (String)parameter.getValue())) {
                storageManagerInstance = SandeshaUtil.getInMemoryStorageManager(context);
            } else if ("persistent".equals(value)) {
                storageManagerInstance = SandeshaUtil.getPermanentStorageManager(context);
            } else {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotGetStorageManager"));
            }
            context.setProperty("storageManagerInstance", storageManagerInstance);
        }
        return storageManagerInstance;
    }

    public static StorageManager getInMemoryStorageManager(ConfigurationContext context) throws SandeshaException {
        StorageManager inMemoryStorageManager = null;
        AxisConfiguration config2 = context.getAxisConfiguration();
        Parameter parameter = config2.getParameter("inmemory");
        if (parameter != null) {
            inMemoryStorageManager = (StorageManager)parameter.getValue();
        }
        if (inMemoryStorageManager != null) {
            return inMemoryStorageManager;
        }
        try {
            String storageManagerClassStr = SandeshaUtil.getDefaultPropertyBean(context.getAxisConfiguration()).getInMemoryStorageManagerClass();
            inMemoryStorageManager = SandeshaUtil.getStorageManagerInstance(storageManagerClassStr, context);
            parameter = new Parameter("inmemory", inMemoryStorageManager);
            config2.addParameter(parameter);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitInMemoryStorageManager", e.toString());
            throw new SandeshaException(message, e);
        }
        return inMemoryStorageManager;
    }

    public static StorageManager getPermanentStorageManager(ConfigurationContext context) throws SandeshaException {
        StorageManager permanentStorageManager = null;
        AxisConfiguration config2 = context.getAxisConfiguration();
        Parameter parameter = config2.getParameter("persistent");
        if (parameter != null) {
            permanentStorageManager = (StorageManager)parameter.getValue();
        }
        if (permanentStorageManager != null) {
            return permanentStorageManager;
        }
        try {
            String storageManagerClassStr = SandeshaUtil.getDefaultPropertyBean(context.getAxisConfiguration()).getPermanentStorageManagerClass();
            permanentStorageManager = SandeshaUtil.getStorageManagerInstance(storageManagerClassStr, context);
            parameter = new Parameter("persistent", permanentStorageManager);
            config2.addParameter(parameter);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitPersistentStorageManager", e.toString());
            throw new SandeshaException(message, e);
        }
        return permanentStorageManager;
    }

    private static StorageManager getStorageManagerInstance(String className, ConfigurationContext context) throws SandeshaException {
        StorageManager storageManager = null;
        try {
            StorageManager mgr;
            Class<?> configContextClass;
            ClassLoader classLoader = null;
            AxisConfiguration config2 = context.getAxisConfiguration();
            Parameter classLoaderParam = config2.getParameter("Sandesha2ModuleClassLoader");
            if (classLoaderParam != null) {
                classLoader = (ClassLoader)classLoaderParam.getValue();
            }
            if (classLoader == null) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("classLoaderNotFound"));
            }
            Class<?> c = classLoader.loadClass(className);
            Constructor<?> constructor = c.getConstructor(configContextClass = context.getClass());
            Object obj = constructor.newInstance(context);
            if (obj == null || !(obj instanceof StorageManager)) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("storageManagerMustImplement"));
            }
            storageManager = mgr = (StorageManager)obj;
            return storageManager;
        }
        catch (Exception e) {
            String message = SandeshaMessageHelper.getMessage("cannotGetStorageManager");
            if (log.isErrorEnabled()) {
                log.error(message, e);
            }
            throw new SandeshaException(message, e);
        }
    }

    public static int getSOAPVersion(SOAPEnvelope envelope) throws SandeshaException {
        String namespaceName = envelope.getNamespace().getNamespaceURI();
        if (namespaceName.equals("http://schemas.xmlsoap.org/soap/envelope/")) {
            return 1;
        }
        if (namespaceName.equals("http://www.w3.org/2003/05/soap-envelope")) {
            return 2;
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("unknownSoapVersion", namespaceName));
    }

    public static MessageContext createNewRelatedMessageContext(RMMsgContext referenceRMMessage, AxisOperation operation) throws SandeshaException {
        try {
            String[] propertyNames;
            String[] propertyNames2;
            MessageContext referenceMessage = referenceRMMessage.getMessageContext();
            ConfigurationContext configContext = referenceMessage.getConfigurationContext();
            AxisConfiguration axisConfiguration = configContext.getAxisConfiguration();
            MessageContext newMessageContext = new MessageContext();
            newMessageContext.setConfigurationContext(configContext);
            Options newOptions = new Options();
            newMessageContext.setOptions(newOptions);
            if (referenceMessage.getAxisServiceGroup() != null) {
                newMessageContext.setAxisServiceGroup(referenceMessage.getAxisServiceGroup());
                if (referenceMessage.getServiceGroupContext() != null) {
                    newMessageContext.setServiceGroupContext(referenceMessage.getServiceGroupContext());
                    newMessageContext.setServiceGroupContextId(referenceMessage.getServiceGroupContextId());
                } else {
                    ServiceGroupContext serviceGroupContext = new ServiceGroupContext(configContext, referenceMessage.getAxisServiceGroup());
                    newMessageContext.setServiceGroupContext(serviceGroupContext);
                }
            } else {
                AxisServiceGroup axisServiceGroup = new AxisServiceGroup(axisConfiguration);
                ServiceGroupContext serviceGroupContext = new ServiceGroupContext(configContext, axisServiceGroup);
                newMessageContext.setAxisServiceGroup(axisServiceGroup);
                newMessageContext.setServiceGroupContext(serviceGroupContext);
            }
            if (referenceMessage.getAxisService() != null) {
                newMessageContext.setAxisService(referenceMessage.getAxisService());
                if (referenceMessage.getServiceContext() != null) {
                    newMessageContext.setServiceContext(referenceMessage.getServiceContext());
                    newMessageContext.setServiceContextID(referenceMessage.getServiceContextID());
                } else {
                    ServiceContext serviceContext = new ServiceContext(referenceMessage.getAxisService(), newMessageContext.getServiceGroupContext());
                    newMessageContext.setServiceContext(serviceContext);
                }
            }
            newMessageContext.setAxisOperation(operation);
            OperationContext operationContext = new OperationContext(operation, newMessageContext.getServiceContext());
            newMessageContext.setOperationContext(operationContext);
            operationContext.addMessageContext(newMessageContext);
            SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(referenceMessage.getEnvelope()));
            newMessageContext.setEnvelope(factory.getDefaultEnvelope());
            newMessageContext.setTransportIn(referenceMessage.getTransportIn());
            newMessageContext.setTransportOut(referenceMessage.getTransportOut());
            SandeshaUtil.copyNecessaryPropertiesFromRelatedContext(referenceMessage, newMessageContext);
            newMessageContext.setProperty("TRANSPORT_OUT", referenceMessage.getProperty("TRANSPORT_OUT"));
            newMessageContext.setProperty("OutTransportInfo", referenceMessage.getProperty("OutTransportInfo"));
            newMessageContext.setProperty("TRANSPORT_HEADERS", referenceMessage.getProperty("TRANSPORT_HEADERS"));
            newMessageContext.setProperty("TRANSPORT_IN", referenceMessage.getProperty("TRANSPORT_IN"));
            newMessageContext.setProperty("TRANSPORT_OUT", referenceMessage.getProperty("TRANSPORT_OUT"));
            AxisModule axisModule = SandeshaUtil.getAxisModule();
            Parameter propertiesFromRefMsg = axisModule.getParameter("propertiesToCopyFromReferenceMessageAsStringArray");
            if (propertiesFromRefMsg != null && (propertyNames2 = (String[])propertiesFromRefMsg.getValue()) != null) {
                for (int i = 0; i < propertyNames2.length; ++i) {
                    String propertyName = propertyNames2[i];
                    Object val = referenceMessage.getProperty(propertyName);
                    if (val == null) continue;
                    newMessageContext.setProperty(propertyName, val);
                }
            }
            Parameter propertiesFromRefReqMsg = axisModule.getParameter("propertiesToCopyFromReferenceRequestMessageAsStringArray");
            OperationContext referenceOpCtx = referenceMessage.getOperationContext();
            MessageContext referenceRequestMessage = null;
            if (referenceOpCtx != null) {
                referenceRequestMessage = referenceOpCtx.getMessageContext("In");
            }
            if (propertiesFromRefReqMsg != null && referenceRequestMessage != null && (propertyNames = (String[])propertiesFromRefReqMsg.getValue()) != null) {
                for (int i = 0; i < propertyNames.length; ++i) {
                    String propertyName = propertyNames[i];
                    Object val = referenceRequestMessage.getProperty(propertyName);
                    if (val == null) continue;
                    newMessageContext.setProperty(propertyName, val);
                }
            }
            return newMessageContext;
        }
        catch (AxisFault e) {
            log.debug(e.getMessage());
            throw new SandeshaException(e.getMessage());
        }
    }

    public static SandeshaPolicyBean getDefaultPropertyBean(AxisConfiguration axisConfiguration) throws SandeshaException {
        Parameter parameter = axisConfiguration.getParameter("Sandesha2PropertyBean");
        if (parameter == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("defaultPropertyBeanNotSet"));
        }
        SandeshaPolicyBean sandeshaPropertyBean = (SandeshaPolicyBean)parameter.getValue();
        return sandeshaPropertyBean;
    }

    private static void copyNecessaryPropertiesFromRelatedContext(MessageContext fromMessage, MessageContext toMessage) throws AxisFault {
        MessageContext requestMsg;
        OperationContext opCtx;
        toMessage.setProperty("TransportURL", fromMessage.getProperty("TransportURL"));
        String addressingVersion = (String)fromMessage.getProperty("WSAddressingVersion");
        if (addressingVersion == null && (opCtx = fromMessage.getOperationContext()) != null && (requestMsg = opCtx.getMessageContext("In")) != null) {
            addressingVersion = (String)requestMsg.getProperty("WSAddressingVersion");
        }
        toMessage.setProperty("WSAddressingVersion", addressingVersion);
        toMessage.setProperty("disableAddressingForOutMessages", fromMessage.getProperty("disableAddressingForOutMessages"));
    }

    public static ArrayList getArrayListFromString(String str) throws SandeshaException {
        if (str == null || "".equals(str)) {
            return new ArrayList();
        }
        if (str.length() < 2) {
            String message = SandeshaMessageHelper.getMessage("invalidStringArray", str);
            log.debug(message);
            throw new SandeshaException(message);
        }
        int length = str.length();
        if (str.charAt(0) != '[' || str.charAt(length - 1) != ']') {
            String message = SandeshaMessageHelper.getMessage("invalidStringArray", str);
            log.debug(message);
            throw new SandeshaException(message);
        }
        ArrayList<String> retArr = new ArrayList<String>();
        String subStr = str.substring(1, length - 1);
        String[] parts = subStr.split(",");
        for (int i = 0; i < parts.length; ++i) {
            if ("".equals(parts[i])) continue;
            retArr.add(parts[i].trim());
        }
        return retArr;
    }

    public static String getInternalSequenceID(String to, String sequenceKey) {
        if (to == null && sequenceKey == null) {
            return null;
        }
        if (to == null) {
            return sequenceKey;
        }
        if (sequenceKey == null) {
            return to;
        }
        return "Sandesha2InternalSequence:" + to + ":" + sequenceKey;
    }

    public static String getOutgoingSideInternalSequenceID(String sequenceID) {
        return "Sandesha2InternalSequence:" + sequenceID;
    }

    public static final RMSBean getRMSBeanFromInternalSequenceId(StorageManager storageManager, String internalSequenceID) throws SandeshaException {
        RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
        RMSBean bean = new RMSBean();
        bean.setInternalSequenceID(internalSequenceID);
        bean = rmsBeanMgr.findUnique(bean);
        return bean;
    }

    public static final RMSBean getRMSBeanFromSequenceId(StorageManager storageManager, String sequenceID) throws SandeshaException {
        RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
        RMSBean bean = new RMSBean();
        bean.setSequenceID(sequenceID);
        bean = rmsBeanMgr.findUnique(bean);
        return bean;
    }

    public static RMDBean getRMDBeanFromSequenceId(StorageManager storageManager, String sequenceID) throws SandeshaException {
        RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
        RMDBean bean = rmdBeanMgr.retrieve(sequenceID);
        return bean;
    }

    public static String getSequenceIDFromInternalSequenceID(String internalSequenceID, StorageManager storageManager) throws SandeshaException {
        RMSBean rMSBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceID);
        String sequeunceID = null;
        if (rMSBean != null && rMSBean.getSequenceID() != null && !rMSBean.getSequenceID().equals("uuid:tempID")) {
            sequeunceID = rMSBean.getSequenceID();
        }
        return sequeunceID;
    }

    public static String getExecutionChainString(ArrayList executionChain) {
        Iterator iter = executionChain.iterator();
        String executionChainStr = "";
        while (iter.hasNext()) {
            Handler handler = (Handler)iter.next();
            String name = handler.getName();
            executionChainStr = executionChainStr + "." + name;
        }
        return executionChainStr;
    }

    public static boolean isDuplicateInOnlyMessage(MessageContext msgContext) {
        AxisOperation operation = msgContext.getAxisOperation();
        String localName = operation.getName().getLocalPart();
        if (log.isDebugEnabled()) {
            log.debug("isDuplicateInOnlyMessage:: '" + localName + "' comp with '" + Sandesha2Constants.RM_DUPLICATE_IN_ONLY_OPERATION.getLocalPart() + "'");
        }
        return localName.equals(Sandesha2Constants.RM_DUPLICATE_IN_ONLY_OPERATION.getLocalPart());
    }

    public static boolean isDuplicateInOutMessage(MessageContext msgContext) {
        AxisOperation operation = msgContext.getAxisOperation();
        String localName = operation.getName().getLocalPart();
        if (log.isDebugEnabled()) {
            log.debug("isDuplicateInOnlyMessage:: '" + localName + "' comp with '" + Sandesha2Constants.RM_DUPLICATE_IN_OUT_OPERATION.getLocalPart() + "'");
        }
        return localName.equals(Sandesha2Constants.RM_DUPLICATE_IN_OUT_OPERATION.getLocalPart());
    }

    public static boolean isAllMsgsAckedUpto(long highestInMsgNo, String internalSequenceId, StorageManager storageManager) throws SandeshaException {
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
        RangeString ackedMsgRanges = rmsBean.getClientCompletedMessages();
        long smallestMsgNo = 1L;
        Range interestedRange = new Range(smallestMsgNo, highestInMsgNo);
        boolean allComplete = false;
        if (ackedMsgRanges != null && ackedMsgRanges.isRangeCompleted(interestedRange)) {
            allComplete = true;
        }
        return allComplete;
    }

    public static SandeshaPolicyBean getPropertyBean(AxisDescription axisDescription) throws SandeshaException {
        Parameter parameter = axisDescription.getParameter("Sandesha2PropertyBean");
        if (parameter == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("propertyBeanNotSet"));
        }
        SandeshaPolicyBean propertyBean = (SandeshaPolicyBean)parameter.getValue();
        if (propertyBean == null) {
            String message = SandeshaMessageHelper.getMessage("policyBeanNotFound");
            throw new SandeshaException(message);
        }
        return propertyBean;
    }

    public static String getSequenceIDFromRMMessage(RMMsgContext rmMessageContext) throws SandeshaException {
        int messageType = rmMessageContext.getMessageType();
        String sequenceID = null;
        if (messageType == 3) {
            Sequence sequence = (Sequence)rmMessageContext.getMessagePart(6);
            sequenceID = sequence.getIdentifier().getIdentifier();
        } else if (messageType == 4) {
            Iterator sequenceAckIter = rmMessageContext.getMessageParts(7);
            SequenceAcknowledgement sequenceAcknowledgement = (SequenceAcknowledgement)sequenceAckIter.next();
            sequenceID = sequenceAcknowledgement.getIdentifier().getIdentifier();
        } else if (messageType == 8) {
            Iterator ackRequestIter = rmMessageContext.getMessageParts(15);
            AckRequested ackReq = (AckRequested)ackRequestIter.next();
            sequenceID = ackReq.getIdentifier().getIdentifier();
        } else if (messageType == 5) {
            CloseSequence closeSequence = (CloseSequence)rmMessageContext.getMessagePart(12);
            sequenceID = closeSequence.getIdentifier().getIdentifier();
        } else if (messageType == 6) {
            CloseSequenceResponse closeSequenceResponse = (CloseSequenceResponse)rmMessageContext.getMessagePart(13);
            sequenceID = closeSequenceResponse.getIdentifier().getIdentifier();
        }
        return sequenceID;
    }

    public static String getSequenceKeyFromInternalSequenceID(String internalSequenceID, String to) {
        String toEPRString;
        String postPrefixString;
        int indexOfToEPR;
        if (to == null) {
            return internalSequenceID;
        }
        int postPrefixStringIndex = internalSequenceID.indexOf("Sandesha2InternalSequence");
        if (postPrefixStringIndex >= 0 && (indexOfToEPR = (postPrefixString = internalSequenceID.substring(postPrefixStringIndex + "Sandesha2InternalSequence".length())).indexOf(toEPRString = ":" + to + ":")) >= 0) {
            return postPrefixString.substring(indexOfToEPR + toEPRString.length());
        }
        return null;
    }

    public static EPRDecorator getEPRDecorator(ConfigurationContext context) throws SandeshaException {
        EPRDecorator decorator = null;
        AxisConfiguration config2 = context.getAxisConfiguration();
        Parameter p = config2.getParameter("Sandesha2EPRDecorator");
        if (p != null) {
            decorator = (EPRDecorator)p.getValue();
        }
        if (decorator != null) {
            return decorator;
        }
        try {
            String decoratorClassStr = SandeshaUtil.getDefaultPropertyBean(context.getAxisConfiguration()).getEPRDecoratorClass();
            decorator = SandeshaUtil.getEPRDecoratorInstance(decoratorClassStr, context);
            p = new Parameter("Sandesha2EPRDecorator", decorator);
            config2.addParameter(p);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitEPRDecorator", e.toString());
            throw new SandeshaException(message, e);
        }
        return decorator;
    }

    private static EPRDecorator getEPRDecoratorInstance(String className, ConfigurationContext context) throws SandeshaException {
        try {
            ClassLoader classLoader = null;
            AxisConfiguration config2 = context.getAxisConfiguration();
            Parameter classLoaderParam = config2.getParameter("Sandesha2ModuleClassLoader");
            if (classLoaderParam != null) {
                classLoader = (ClassLoader)classLoaderParam.getValue();
            }
            if (classLoader == null) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("classLoaderNotFound"));
            }
            Class<?> c = classLoader.loadClass(className);
            Class<?> configContextClass = context.getClass();
            Constructor<?> constructor = c.getConstructor(configContextClass);
            Object obj = constructor.newInstance(context);
            if (!(obj instanceof EPRDecorator)) {
                String message = SandeshaMessageHelper.getMessage("eprDecoratorMustImplement", className);
                throw new SandeshaException(message);
            }
            return (EPRDecorator)obj;
        }
        catch (Exception e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitEPRDecorator", e.toString());
            throw new SandeshaException(message, e);
        }
    }

    public static SecurityManager getSecurityManager(ConfigurationContext context) throws SandeshaException {
        SecurityManager util = null;
        AxisConfiguration config2 = context.getAxisConfiguration();
        Parameter p = config2.getParameter("Sandesha2SecurityManager");
        if (p != null) {
            util = (SecurityManager)p.getValue();
        }
        if (util != null) {
            return util;
        }
        try {
            String securityManagerClassStr = SandeshaUtil.getDefaultPropertyBean(context.getAxisConfiguration()).getSecurityManagerClass();
            util = SandeshaUtil.getSecurityManagerInstance(securityManagerClassStr, context);
            p = new Parameter("Sandesha2SecurityManager", util);
            config2.addParameter(p);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitSecurityManager", e.toString());
            throw new SandeshaException(message, e);
        }
        return util;
    }

    private static SecurityManager getSecurityManagerInstance(String className, ConfigurationContext context) throws SandeshaException {
        try {
            ClassLoader classLoader = null;
            AxisConfiguration config2 = context.getAxisConfiguration();
            Parameter classLoaderParam = config2.getParameter("Sandesha2ModuleClassLoader");
            if (classLoaderParam != null) {
                classLoader = (ClassLoader)classLoaderParam.getValue();
            }
            if (classLoader == null) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("classLoaderNotFound"));
            }
            Class<?> c = classLoader.loadClass(className);
            Class<?> configContextClass = context.getClass();
            Constructor<?> constructor = c.getConstructor(configContextClass);
            Object obj = constructor.newInstance(context);
            if (!(obj instanceof SecurityManager)) {
                String message = SandeshaMessageHelper.getMessage("securityManagerMustImplement", className);
                throw new SandeshaException(message);
            }
            return (SecurityManager)obj;
        }
        catch (Exception e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitSecurityManager", e.toString());
            throw new SandeshaException(message, e);
        }
    }

    public static ContextManager getContextManager(ConfigurationContext context) throws SandeshaException {
        ContextManager mgr = null;
        AxisConfiguration config2 = context.getAxisConfiguration();
        Parameter p = config2.getParameter("Sandesha2ContextManager");
        if (p != null) {
            mgr = (ContextManager)p.getValue();
        }
        if (mgr != null) {
            return mgr;
        }
        try {
            String securityManagerClassStr = SandeshaUtil.getDefaultPropertyBean(context.getAxisConfiguration()).getContextManagerClass();
            mgr = SandeshaUtil.getContextManagerInstance(securityManagerClassStr, context);
            p = new Parameter("Sandesha2ContextManager", mgr);
            config2.addParameter(p);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitContextManager", e.toString());
            throw new SandeshaException(message, e);
        }
        return mgr;
    }

    private static ContextManager getContextManagerInstance(String className, ConfigurationContext context) throws SandeshaException {
        try {
            ClassLoader classLoader = null;
            AxisConfiguration config2 = context.getAxisConfiguration();
            Parameter classLoaderParam = config2.getParameter("Sandesha2ModuleClassLoader");
            if (classLoaderParam != null) {
                classLoader = (ClassLoader)classLoaderParam.getValue();
            }
            if (classLoader == null) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("classLoaderNotFound"));
            }
            Class<?> c = classLoader.loadClass(className);
            Class<?> configContextClass = context.getClass();
            Constructor<?> constructor = c.getConstructor(configContextClass);
            Object obj = constructor.newInstance(context);
            if (!(obj instanceof ContextManager)) {
                String message = SandeshaMessageHelper.getMessage("contextManagerMustImplement", className);
                throw new SandeshaException(message);
            }
            return (ContextManager)obj;
        }
        catch (Exception e) {
            String message = SandeshaMessageHelper.getMessage("cannotInitContextManager", e.toString());
            throw new SandeshaException(message, e);
        }
    }

    public static boolean isWSRMAnonymous(String address) {
        return address != null && address.startsWith("http://docs.oasis-open.org/ws-rx/wsmc/200702/anonymous?id=");
    }

    public static void executeAndStore(RMMsgContext rmMsgContext, String storageKey, StorageManager manager) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaUtil::executeAndStore, " + storageKey);
        }
        MessageContext msgContext = rmMsgContext.getMessageContext();
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        if (manager.requiresMessageSerialization()) {
            msgContext.setProperty("Sandesha2QualifiedForSending", "true");
            StorageManager store = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
            store.storeMessageContext(storageKey, msgContext);
        } else {
            msgContext.setProperty("Sandesha2MessageStoreKey", storageKey);
            TransportOutDescription transportOut = msgContext.getTransportOut();
            msgContext.setProperty("Sandesha2OriginalTransportSender", transportOut);
            msgContext.setProperty("Sandesha2SetSendToTrue", "true");
            Sandesha2TransportOutDesc sandesha2TransportOutDesc = new Sandesha2TransportOutDesc();
            msgContext.setTransportOut(sandesha2TransportOutDesc);
            AxisEngine engine2 = new AxisEngine(configurationContext);
            Boolean isTransportNonBlocking = (Boolean)msgContext.getProperty("transportNonBlocking");
            if (isTransportNonBlocking != null && isTransportNonBlocking.booleanValue()) {
                msgContext.setProperty("transportNonBlocking", Boolean.FALSE);
            }
            if (msgContext.isPaused()) {
                engine2.resumeSend(msgContext);
            } else {
                engine2.send(msgContext);
            }
            msgContext.setProperty("transportNonBlocking", isTransportNonBlocking);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaUtil::executeAndStore");
        }
    }

    public static void modifyExecutionChainForStoring(MessageContext message, StorageManager manager) throws SandeshaException {
        Object property = message.getProperty("RMRetransmittablePhases");
        if (property != null) {
            return;
        }
        if (manager.requiresMessageSerialization()) {
            return;
        }
        TransportOutDescription transportOutDescription = message.getTransportOut();
        if (!(transportOutDescription instanceof Sandesha2TransportOutDesc)) {
            return;
        }
        ArrayList executionChain = message.getExecutionChain();
        ArrayList retransmittablePhaseNames = SandeshaUtil.getRetransmittablePhaseNameList();
        ArrayList<Handler> retransmittablePhases = new ArrayList<Handler>();
        Iterator it = executionChain.iterator();
        while (it.hasNext()) {
            Handler handler = (Handler)it.next();
            if (!retransmittablePhaseNames.contains(handler.getName())) continue;
            retransmittablePhases.add(handler);
            it.remove();
        }
        message.setProperty("RMRetransmittablePhases", retransmittablePhases);
    }

    private static ArrayList getRetransmittablePhaseNameList() {
        String security = "Security";
        ArrayList<String> phases = new ArrayList<String>();
        phases.add(security);
        return phases;
    }

    public static MessageContext cloneMessageContext(MessageContext oldMsg) throws AxisFault {
        MessageContext newMsg = new MessageContext();
        newMsg.setOptions(new Options(oldMsg.getOptions()));
        SOAPEnvelope oldEnvelope = oldMsg.getEnvelope();
        if (oldEnvelope != null) {
            SOAPEnvelope newEnvelope = SandeshaUtil.copySOAPEnvelope(oldMsg.getEnvelope());
            newMsg.setEnvelope(newEnvelope);
        }
        newMsg.setConfigurationContext(oldMsg.getConfigurationContext());
        newMsg.setAxisService(oldMsg.getAxisService());
        newMsg.setTransportOut(oldMsg.getTransportOut());
        newMsg.setTransportIn(oldMsg.getTransportIn());
        return newMsg;
    }

    public static SOAPEnvelope copySOAPEnvelope(SOAPEnvelope sourceEnv) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaUtil::copySOAPEnvelope");
        }
        SOAPEnvelope targetEnv = CopyUtils.copy(sourceEnv);
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaUtil::copySOAPEnvelope");
        }
        return targetEnv;
    }

    public static SOAPEnvelope removeMustUnderstand(SOAPEnvelope envelope) {
        SOAPHeader header;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaUtil::removeMustUnderstand");
        }
        if ((header = envelope.getHeader()) != null) {
            Iterator childrenOfOldEnv = header.getChildElements();
            while (childrenOfOldEnv.hasNext()) {
                SOAPHeaderBlock oldEnvHeaderBlock = (SOAPHeaderBlock)childrenOfOldEnv.next();
                QName oldEnvHeaderBlockQName = oldEnvHeaderBlock.getQName();
                if (oldEnvHeaderBlockQName == null || !oldEnvHeaderBlock.isProcessed() || !oldEnvHeaderBlock.getMustUnderstand()) continue;
                oldEnvHeaderBlock.setMustUnderstand(false);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaUtil::removeMustUnderstand");
        }
        return envelope;
    }

    public static EndpointReference cloneEPR(EndpointReference epr) {
        EndpointReference newEPR = new EndpointReference(epr.getAddress());
        Map referenceParams = epr.getAllReferenceParameters();
        if (referenceParams != null) {
            for (Object key : referenceParams.keySet()) {
                Object referenceParam = referenceParams.get(key);
                if (!(referenceParam instanceof OMElement)) continue;
                OMElement clonedElement = ((OMElement)referenceParam).cloneOMElement();
                clonedElement.setText("false");
                newEPR.addReferenceParameter(clonedElement);
            }
        }
        return newEPR;
    }

    public static boolean isMessageUnreliable(MessageContext mc) {
        Parameter unreliableParam;
        if (log.isDebugEnabled()) {
            log.debug("Entry: SandeshaUtil::isMessageUnreliable");
        }
        boolean result = false;
        String unreliable = (String)mc.getProperty(SandeshaClientConstants.UNRELIABLE_MESSAGE);
        if ("true".equals(unreliable)) {
            if (log.isDebugEnabled()) {
                log.debug("Unreliable message context");
            }
            result = true;
        }
        if (!result && mc.getAxisOperation() != null && null != (unreliableParam = mc.getAxisOperation().getParameter(SandeshaClientConstants.UNRELIABLE_MESSAGE)) && "true".equals(unreliableParam.getValue())) {
            if (log.isDebugEnabled()) {
                log.debug("Unreliable operation");
            }
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaUtil::isMessageUnreliable, " + result);
        }
        return result;
    }

    public static final String getStackTraceFromException(Exception e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(baos);
        e.printStackTrace(pw);
        pw.flush();
        String stackTrace = baos.toString();
        return stackTrace;
    }

    public static EndpointReference rewriteEPR(RMSBean sourceBean, EndpointReference epr, ConfigurationContext configContext) throws SandeshaException {
        String address;
        SandeshaPolicyBean policy;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaUtil::rewriteEPR " + epr);
        }
        if (!(policy = SandeshaUtil.getPropertyBean(configContext.getAxisConfiguration())).isEnableRMAnonURI()) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: SandeshaUtil::rewriteEPR, anon uri is disabled");
            }
            return epr;
        }
        if (epr == null) {
            epr = new EndpointReference(null);
        }
        if ((address = epr.getAddress()) == null || "http://www.w3.org/2005/08/addressing/anonymous".equals(address) || "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(address)) {
            String uuid = sourceBean.getAnonymousUUID();
            if (uuid == null) {
                uuid = "http://docs.oasis-open.org/ws-rx/wsmc/200702/anonymous?id=" + SandeshaUtil.getUUID();
                sourceBean.setAnonymousUUID(uuid);
            }
            if (log.isDebugEnabled()) {
                log.debug("Rewriting EPR with anon URI " + uuid);
            }
            epr.setAddress(uuid);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaUtil::rewriteEPR " + epr);
        }
        return epr;
    }

    public static boolean isInOrder(MessageContext context) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaUtil::isInOrder");
        }
        SandeshaPolicyBean policy = SandeshaUtil.getPropertyBean(context.getConfigurationContext().getAxisConfiguration());
        boolean result = policy.isInOrder();
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaUtil::isInOrder, " + result);
        }
        return result;
    }
}

