/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.sandesha2.util.Range;

public class RangeString
implements Serializable {
    private static final long serialVersionUID = -3487094584241136861L;
    private static Pattern pattern = null;
    private final TreeMap rangeMap = new TreeMap();

    public RangeString() {
        this((String)null);
    }

    public RangeString(String s) {
        if (s != null && !s.equals("")) {
            if (pattern == null) {
                pattern = Pattern.compile("\\[(.+?),(.+?)\\]");
            }
            Matcher m = pattern.matcher(s);
            while (m.find()) {
                String token = m.group();
                this.addRange(new Range(token));
            }
        }
    }

    public RangeString(RangeString rs) {
        for (Map.Entry e : rs.rangeMap.entrySet()) {
            Range sr = (Range)e.getValue();
            this.rangeMap.put(e.getKey(), new Range(sr.lowerValue, sr.upperValue));
        }
    }

    private Range getNextRangeBelow(long msgNumber) {
        long cachedKey = -1L;
        if (this.rangeMap.containsKey(new Long(msgNumber))) {
            cachedKey = msgNumber;
        } else {
            Iterator iterator = this.rangeMap.keySet().iterator();
            while (iterator.hasNext()) {
                long key = (Long)iterator.next();
                if (key > cachedKey && key <= msgNumber) {
                    cachedKey = key;
                    continue;
                }
                if (key <= msgNumber) continue;
                break;
            }
        }
        if (cachedKey != -1L) {
            Range r = (Range)this.rangeMap.get(new Long(cachedKey));
            return r;
        }
        return null;
    }

    private void cleanUpRangesEnvelopedAndDiscoverNewRangesAdded(Range envelopeRange, long startOfRangeLookup, long endOfRangeLookup, RangeString newRangesAdded) {
        boolean checkRequired;
        boolean bl = checkRequired = !this.rangeMap.isEmpty();
        if (checkRequired) {
            for (long index = startOfRangeLookup; index <= endOfRangeLookup && index > 0L; ++index) {
                Long currentKey = new Long(index);
                Range existingRange = (Range)this.rangeMap.get(currentKey);
                if (existingRange != null) {
                    if (existingRange.upperValue > envelopeRange.upperValue) {
                        envelopeRange.upperValue = existingRange.upperValue;
                        index = existingRange.upperValue;
                    }
                    this.rangeMap.remove(currentKey);
                    continue;
                }
                if (newRangesAdded == null) continue;
                newRangesAdded.addRange(new Range(index, index), false);
            }
        } else if (newRangesAdded != null) {
            newRangesAdded.addRange(new Range(startOfRangeLookup, endOfRangeLookup), false);
        }
    }

    private Range getRangeImmediatelyAbove(Range targetRange) {
        return (Range)this.rangeMap.get(new Long(targetRange.upperValue + 1L));
    }

    public boolean isMessageNumberInRanges(long messageNumber) {
        return this.getRangeForMessageNumber(messageNumber) != null;
    }

    public Range getRangeForMessageNumber(long messageNumber) {
        Range below = this.getNextRangeBelow(messageNumber);
        if (below != null && below.rangeContainsValue(messageNumber)) {
            return below;
        }
        return null;
    }

    public boolean isRangeCompleted(Range interestedRange) {
        Range containingRange = this.getNextRangeBelow(interestedRange.lowerValue);
        return containingRange != null && containingRange.upperValue >= interestedRange.upperValue;
    }

    public String toString() {
        String returnString = "";
        for (Map.Entry e : ((SortedMap)this.rangeMap.clone()).entrySet()) {
            returnString = returnString + e.getValue();
        }
        return returnString;
    }

    public Range[] getRanges() {
        Set entrySet = this.rangeMap.entrySet();
        Range[] ranges = new Range[entrySet.size()];
        int i = 0;
        Iterator iter = entrySet.iterator();
        while (iter.hasNext()) {
            ranges[i] = (Range)iter.next().getValue();
            ++i;
        }
        return ranges;
    }

    public List getContainedElementsAsNumbersList() {
        LinkedList<Long> returnList = new LinkedList<Long>();
        Range[] ranges = this.getRanges();
        for (int i = 0; i < ranges.length; ++i) {
            for (long current = ranges[i].lowerValue; current <= ranges[i].upperValue; ++current) {
                returnList.add(new Long(current));
            }
        }
        return returnList;
    }

    public RangeString addRange(Range r) {
        return this.addRange(r, true);
    }

    private RangeString addRange(Range r, boolean newRangeProcessingRequired) {
        Range above;
        Range finalRange = r;
        RangeString newRangesAdded = null;
        if (newRangeProcessingRequired) {
            newRangesAdded = new RangeString();
        }
        long envelopCheckingStartPoint = r.lowerValue;
        boolean rangeAdded = false;
        long indexKey = r.lowerValue;
        Range below = this.getNextRangeBelow(indexKey);
        if (below != null) {
            if (below.equals(r)) {
                return newRangesAdded;
            }
            if (below.upperValue < r.upperValue && below.upperValue >= r.lowerValue - 1L) {
                long startingRange = below.upperValue + 1L;
                below.upperValue = r.upperValue;
                rangeAdded = true;
                finalRange = below;
                this.cleanUpRangesEnvelopedAndDiscoverNewRangesAdded(finalRange, startingRange, r.upperValue, newRangesAdded);
                envelopCheckingStartPoint = r.upperValue + 1L;
            } else if (below.upperValue >= r.upperValue) {
                return newRangesAdded;
            }
        }
        if ((above = this.getRangeImmediatelyAbove(finalRange)) != null) {
            Long removeKey = new Long(above.lowerValue);
            if (rangeAdded) {
                finalRange.upperValue = above.upperValue;
                this.cleanUpRangesEnvelopedAndDiscoverNewRangesAdded(finalRange, envelopCheckingStartPoint, above.lowerValue, newRangesAdded);
            } else {
                rangeAdded = true;
                this.cleanUpRangesEnvelopedAndDiscoverNewRangesAdded(above, r.lowerValue, r.upperValue, newRangesAdded);
                above.lowerValue = r.lowerValue;
                this.rangeMap.put(new Long(above.lowerValue), above);
                finalRange = above;
            }
            this.rangeMap.remove(removeKey);
        }
        if (!rangeAdded) {
            Long newIndex = new Long(r.lowerValue);
            this.cleanUpRangesEnvelopedAndDiscoverNewRangesAdded(r, r.lowerValue, r.upperValue, newRangesAdded);
            this.rangeMap.put(new Long(r.lowerValue), r);
        }
        return newRangesAdded;
    }
}

