/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.Iterator;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.CloseSequenceResponse;
import org.apache.sandesha2.wsrm.CreateSequence;
import org.apache.sandesha2.wsrm.CreateSequenceResponse;
import org.apache.sandesha2.wsrm.LastMessage;
import org.apache.sandesha2.wsrm.MakeConnection;
import org.apache.sandesha2.wsrm.RMElements;
import org.apache.sandesha2.wsrm.Sequence;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;
import org.apache.sandesha2.wsrm.TerminateSequence;
import org.apache.sandesha2.wsrm.TerminateSequenceResponse;

public class MsgInitializer {
    public static RMMsgContext initializeMessage(MessageContext ctx) throws AxisFault {
        RMMsgContext rmMsgCtx = new RMMsgContext(ctx);
        MsgInitializer.populateRMMsgContext(ctx, rmMsgCtx);
        return rmMsgCtx;
    }

    private static void populateRMMsgContext(MessageContext msgCtx, RMMsgContext rmMsgContext) throws AxisFault {
        String makeConnectionNamespace;
        String addressingNamespace = (String)msgCtx.getProperty("WSAddressingVersion");
        if (addressingNamespace == null && !msgCtx.isServerSide()) {
            addressingNamespace = "http://www.w3.org/2005/08/addressing";
        }
        RMElements elements = new RMElements(addressingNamespace);
        elements.fromSOAPEnvelope(msgCtx.getEnvelope(), msgCtx.getWSAAction());
        String rmNamespace = null;
        if (elements.getCreateSequence() != null) {
            rmMsgContext.setMessagePart(9, elements.getCreateSequence());
            rmNamespace = elements.getCreateSequence().getNamespaceValue();
        }
        if (elements.getCreateSequenceResponse() != null) {
            rmMsgContext.setMessagePart(10, elements.getCreateSequenceResponse());
            rmNamespace = elements.getCreateSequenceResponse().getNamespaceValue();
        }
        if (elements.getSequence() != null) {
            rmMsgContext.setMessagePart(6, elements.getSequence());
            rmNamespace = elements.getSequence().getNamespaceValue();
        }
        Iterator iter = elements.getSequenceAcknowledgements();
        while (iter.hasNext()) {
            SequenceAcknowledgement sequenceAck = (SequenceAcknowledgement)iter.next();
            rmMsgContext.setMessagePart(7, sequenceAck);
            rmNamespace = sequenceAck.getNamespaceValue();
        }
        if (elements.getTerminateSequence() != null) {
            rmMsgContext.setMessagePart(11, elements.getTerminateSequence());
            rmNamespace = elements.getTerminateSequence().getNamespaceValue();
        }
        if (elements.getTerminateSequenceResponse() != null) {
            rmMsgContext.setMessagePart(14, elements.getTerminateSequenceResponse());
            rmNamespace = elements.getTerminateSequenceResponse().getNamespaceValue();
        }
        iter = elements.getAckRequests();
        while (iter.hasNext()) {
            AckRequested ackRequest = (AckRequested)iter.next();
            rmMsgContext.setMessagePart(15, ackRequest);
            rmNamespace = ackRequest.getNamespaceValue();
        }
        if (elements.getCloseSequence() != null) {
            rmMsgContext.setMessagePart(12, elements.getCloseSequence());
            rmNamespace = elements.getCloseSequence().getNamespaceValue();
        }
        if (elements.getCloseSequenceResponse() != null) {
            rmMsgContext.setMessagePart(13, elements.getCloseSequenceResponse());
            rmNamespace = elements.getCloseSequenceResponse().getNamespaceValue();
        }
        if (elements.getUsesSequenceSTR() != null) {
            rmMsgContext.setMessagePart(16, elements.getUsesSequenceSTR());
        }
        if (elements.getMakeConnection() != null) {
            rmMsgContext.setMessagePart(17, elements.getMakeConnection());
            makeConnectionNamespace = elements.getMakeConnection().getNamespaceValue();
            if ("http://docs.oasis-open.org/ws-rx/wsmc/200702".equals(makeConnectionNamespace)) {
                rmNamespace = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
            }
        }
        if (elements.getMessagePending() != null) {
            rmMsgContext.setMessagePart(18, elements.getMessagePending());
            makeConnectionNamespace = elements.getMessagePending().getNamespaceValue();
            if ("http://docs.oasis-open.org/ws-rx/wsmc/200702".equals(makeConnectionNamespace)) {
                rmNamespace = "http://docs.oasis-open.org/ws-rx/wsrm/200702";
            }
        }
        if (elements.getSequenceFault() != null) {
            rmMsgContext.setMessagePart(19, elements.getSequenceFault());
        }
        rmMsgContext.setRMNamespaceValue(rmNamespace);
        String sequenceID = null;
        CreateSequence createSequence = elements.getCreateSequence();
        CreateSequenceResponse createSequenceResponse = elements.getCreateSequenceResponse();
        TerminateSequence terminateSequence = elements.getTerminateSequence();
        TerminateSequenceResponse terminateSequenceResponse = elements.getTerminateSequenceResponse();
        Iterator sequenceAcknowledgementsIter = elements.getSequenceAcknowledgements();
        Sequence sequence = elements.getSequence();
        Iterator ackRequestedIter = elements.getAckRequests();
        CloseSequence closeSequence = elements.getCloseSequence();
        CloseSequenceResponse closeSequenceResponse = elements.getCloseSequenceResponse();
        MakeConnection makeConnection = elements.getMakeConnection();
        if (createSequence != null) {
            rmMsgContext.setMessageType(1);
        } else if (createSequenceResponse != null) {
            rmMsgContext.setMessageType(2);
            sequenceID = createSequenceResponse.getIdentifier().getIdentifier();
        } else if (terminateSequence != null) {
            rmMsgContext.setMessageType(7);
            sequenceID = terminateSequence.getIdentifier().getIdentifier();
        } else if (terminateSequenceResponse != null) {
            rmMsgContext.setMessageType(9);
            sequenceID = terminateSequenceResponse.getIdentifier().getIdentifier();
        } else if (sequence != null) {
            Sequence seq = (Sequence)rmMsgContext.getMessagePart(6);
            LastMessage lastMessage = seq.getLastMessage();
            SOAPEnvelope envelope = rmMsgContext.getSOAPEnvelope();
            if (lastMessage != null && envelope.getBody().getFirstOMChild() == null) {
                rmMsgContext.setMessageType(12);
            } else {
                rmMsgContext.setMessageType(3);
            }
            sequenceID = sequence.getIdentifier().getIdentifier();
        } else if (sequenceAcknowledgementsIter.hasNext()) {
            rmMsgContext.setMessageType(4);
            SequenceAcknowledgement sequenceAcknowledgement = (SequenceAcknowledgement)sequenceAcknowledgementsIter.next();
            if (!sequenceAcknowledgementsIter.hasNext()) {
                sequenceID = sequenceAcknowledgement.getIdentifier().getIdentifier();
            }
        } else if (ackRequestedIter.hasNext()) {
            rmMsgContext.setMessageType(8);
            AckRequested ackRequest = (AckRequested)ackRequestedIter.next();
            if (!ackRequestedIter.hasNext()) {
                sequenceID = ackRequest.getIdentifier().getIdentifier();
            }
        } else if (closeSequence != null) {
            rmMsgContext.setMessageType(5);
            sequenceID = closeSequence.getIdentifier().getIdentifier();
        } else if (closeSequenceResponse != null) {
            rmMsgContext.setMessageType(6);
            sequenceID = closeSequenceResponse.getIdentifier().getIdentifier();
        } else if (makeConnection != null) {
            rmMsgContext.setMessageType(11);
            if (makeConnection.getIdentifier() != null) {
                sequenceID = makeConnection.getIdentifier().getIdentifier();
            } else if (makeConnection.getAddress() == null) {
                throw new SandeshaException("Invalid MakeConnection message. Either Address or Identifier must be present");
            }
        } else {
            rmMsgContext.setMessageType(0);
        }
        if (sequenceID != null) {
            rmMsgContext.setProperty("WSRMSequenceId", sequenceID);
        }
    }
}

