/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.util;

import java.util.List;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;

public class AcknowledgementManager {
    private static Log log = LogFactory.getLog(AcknowledgementManager.class);

    public static void piggybackAcksIfPresent(RMMsgContext rmMessageContext, StorageManager storageManager) throws SandeshaException {
        List rmdBeans;
        if (log.isDebugEnabled()) {
            log.debug("Enter: AcknowledgementManager::piggybackAcksIfPresent");
        }
        SenderBeanMgr retransmitterBeanMgr = storageManager.getSenderBeanMgr();
        EndpointReference target = rmMessageContext.getTo();
        if (target == null || target.hasAnonymousAddress()) {
            if (target != null && SandeshaUtil.isWSRMAnonymous(target.getAddress())) {
                RMDBean findBean = new RMDBean();
                findBean.setAcksToEPR(target.getAddress());
                findBean.setTerminated(false);
                rmdBeans = storageManager.getRMDBeanMgr().find(findBean);
                for (RMDBean sequence : rmdBeans) {
                    if (sequence.getHighestInMessageNumber() <= 0L) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("Piggybacking ack for sequence: " + sequence.getSequenceID());
                    }
                    RMMsgCreator.addAckMessage(rmMessageContext, sequence.getSequenceID(), sequence, false);
                }
            } else {
                RMDBean inboundBean;
                String inboundSequence = (String)rmMessageContext.getProperty("Sandesha2InboundSequenceId");
                if (inboundSequence != null && (inboundBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, inboundSequence)) != null && !inboundBean.isTerminated()) {
                    String acksTo = inboundBean.getAcksToEPR();
                    EndpointReference acksToEPR = new EndpointReference(acksTo);
                    if (acksTo == null || acksToEPR.hasAnonymousAddress()) {
                        if (log.isDebugEnabled()) {
                            log.debug("Piggybacking ack for inbound sequence: " + inboundSequence);
                        }
                        RMMsgCreator.addAckMessage(rmMessageContext, inboundSequence, inboundBean, false);
                    }
                }
            }
            if (log.isDebugEnabled()) {
                log.debug("Exit: AcknowledgementManager::piggybackAcksIfPresent, anon");
            }
        }
        RMDBean findRMDBean = new RMDBean();
        findRMDBean.setAcksToEPR(target.getAddress());
        findRMDBean.setTerminated(false);
        rmdBeans = storageManager.getRMDBeanMgr().find(findRMDBean);
        for (RMDBean sequence : rmdBeans) {
            String sequenceId = sequence.getSequenceID();
            SenderBean findBean = new SenderBean();
            findBean.setMessageType(4);
            findBean.setSend(true);
            findBean.setSequenceID(sequenceId);
            findBean.setToAddress(target.getAddress());
            SenderBean ackBean = retransmitterBeanMgr.findUnique(findBean);
            long timeNow = System.currentTimeMillis();
            if (ackBean != null && ackBean.getTimeToSend() > timeNow) {
                retransmitterBeanMgr.delete(ackBean.getMessageID());
                storageManager.removeMessageContext(ackBean.getMessageContextRefKey());
                if (log.isDebugEnabled()) {
                    log.debug("Piggybacking ack for sequence: " + sequenceId);
                }
                RMMsgCreator.addAckMessage(rmMessageContext, sequenceId, sequence, false);
                continue;
            }
            if (rmMessageContext.getMessageType() != 7) continue;
            if (log.isDebugEnabled()) {
                log.debug("Adding extra acks, as this is a terminate");
            }
            if (sequence.getHighestInMessageNumber() <= 0L) continue;
            if (log.isDebugEnabled()) {
                log.debug("Piggybacking ack for sequence: " + sequenceId);
            }
            RMMsgCreator.addAckMessage(rmMessageContext, sequenceId, sequence, false);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: AcknowledgementManager::piggybackAcksIfPresent");
        }
    }

    public static RMMsgContext generateAckMessage(RMMsgContext referenceRMMessage, RMDBean rmdBean, String sequenceId, StorageManager storageManager, boolean serverSide) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: AcknowledgementManager::generateAckMessage " + rmdBean);
        }
        MessageContext referenceMsg = referenceRMMessage.getMessageContext();
        EndpointReference acksTo = new EndpointReference(rmdBean.getAcksToEPR());
        if (acksTo.getAddress() == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("acksToStrNotSet"));
        }
        AxisOperation ackOperation = SpecSpecificConstants.getWSRMOperation(4, rmdBean.getRMVersion(), referenceMsg.getAxisService());
        MessageContext ackMsgCtx = SandeshaUtil.createNewRelatedMessageContext(referenceRMMessage, ackOperation);
        ackMsgCtx.setProperty("Sandesha2AppProcessingDone", "true");
        RMMsgContext ackRMMsgCtx = MsgInitializer.initializeMessage(ackMsgCtx);
        ackRMMsgCtx.setFlow(2);
        ackRMMsgCtx.setRMNamespaceValue(referenceRMMessage.getRMNamespaceValue());
        ackMsgCtx.setMessageID(SandeshaUtil.getUUID());
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(referenceMsg.getEnvelope()));
        SOAPEnvelope envelope = factory.getDefaultEnvelope();
        ackMsgCtx.setEnvelope(envelope);
        ackMsgCtx.setTo(acksTo);
        ackMsgCtx.setServerSide(serverSide);
        RMMsgCreator.addAckMessage(ackRMMsgCtx, sequenceId, rmdBean, true);
        if (log.isDebugEnabled()) {
            log.debug("Exit: AcknowledgementManager::generateAckMessage");
        }
        return ackRMMsgCtx;
    }

    public static boolean verifySequenceCompletion(RangeString ackRanges, long lastMessageNo) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: AcknowledgementManager::verifySequenceCompletion");
        }
        boolean result = false;
        Range complete = new Range(1L, lastMessageNo);
        if (ackRanges.isRangeCompleted(complete)) {
            result = true;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: AcknowledgementManager::verifySequenceCompletion " + result);
        }
        return result;
    }

    public static void addAckBeanEntry(RMMsgContext ackRMMsgContext, String sequenceId, long timeToSend, StorageManager storageManager) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: AcknowledgementManager::addAckBeanEntry");
        }
        ackRMMsgContext.addSOAPEnvelope();
        MessageContext ackMsgContext = ackRMMsgContext.getMessageContext();
        SenderBeanMgr retransmitterBeanMgr = storageManager.getSenderBeanMgr();
        String key = SandeshaUtil.getUUID();
        SenderBean ackBean = new SenderBean();
        ackBean.setMessageContextRefKey(key);
        ackBean.setMessageID(ackMsgContext.getMessageID());
        ackBean.setReSend(false);
        ackBean.setSequenceID(sequenceId);
        EndpointReference to = ackMsgContext.getTo();
        if (to != null) {
            ackBean.setToAddress(to.getAddress());
        }
        ackBean.setSend(true);
        ackMsgContext.setProperty("Sandesha2QualifiedForSending", "false");
        ackBean.setMessageType(4);
        SenderBean findBean = new SenderBean();
        findBean.setMessageType(4);
        findBean.setSend(true);
        findBean.setReSend(false);
        findBean.setSequenceID(sequenceId);
        List coll = retransmitterBeanMgr.find(findBean);
        for (SenderBean oldAckBean : coll) {
            if (oldAckBean.getTimeToSend() < timeToSend) {
                timeToSend = oldAckBean.getTimeToSend();
            }
            retransmitterBeanMgr.delete(oldAckBean.getMessageID());
            storageManager.removeMessageContext(oldAckBean.getMessageContextRefKey());
        }
        ackBean.setTimeToSend(timeToSend);
        ackMsgContext.setProperty("Sandesha2QualifiedForSending", "false");
        ackMsgContext.setProperty("Sandesha2SetSendToTrue", "true");
        SandeshaUtil.executeAndStore(ackRMMsgContext, key, storageManager);
        retransmitterBeanMgr.insert(ackBean);
        if (log.isDebugEnabled()) {
            log.debug("Exit: AcknowledgementManager::addAckBeanEntry");
        }
    }

    public static void sendAckNow(RMMsgContext ackRMMsgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: AcknowledgementManager::sendAckNow");
        }
        ackRMMsgContext.addSOAPEnvelope();
        MessageContext ackMsgContext = ackRMMsgContext.getMessageContext();
        ConfigurationContext configContext = ackMsgContext.getConfigurationContext();
        if (ackRMMsgContext.getMessageContext().getOperationContext() == null) {
            AxisOperation op = ackMsgContext.getAxisOperation();
            OperationContext opCtx = ContextFactory.createOperationContext(op, ackRMMsgContext.getMessageContext().getServiceContext());
            ackRMMsgContext.getMessageContext().setOperationContext(opCtx);
        }
        ackRMMsgContext.getMessageContext().setServerSide(true);
        AxisEngine engine2 = new AxisEngine(configContext);
        engine2.send(ackMsgContext);
        if (log.isDebugEnabled()) {
            log.debug("Exit: AcknowledgementManager::sendAckNow");
        }
    }
}

