/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMBean;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;

public class InMemoryTransaction
implements Transaction {
    private static final Log log = LogFactory.getLog(InMemoryTransaction.class);
    private InMemoryStorageManager manager;
    private String threadName;
    private Integer threadId;
    private ArrayList enlistedBeans = new ArrayList();
    private InMemoryTransaction waitingForTran = null;
    private boolean sentMessages = false;
    private boolean active = true;

    InMemoryTransaction(InMemoryStorageManager manager, String threadName, Integer id) {
        if (log.isDebugEnabled()) {
            log.debug("Entry: InMemoryTransaction::<init>");
        }
        this.manager = manager;
        this.threadName = threadName;
        this.threadId = id;
        if (log.isDebugEnabled()) {
            log.debug("Exit: InMemoryTransaction::<init>, " + this);
        }
    }

    public void commit() {
        this.releaseLocks();
        if (this.sentMessages) {
            this.manager.getSender().wakeThread();
        }
        this.active = false;
    }

    public void rollback() {
        this.releaseLocks();
        this.active = false;
    }

    public boolean isActive() {
        return this.active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enlist(RMBean bean) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug("Entry: InMemoryTransaction::enlist, " + bean);
        }
        if (bean != null) {
            RMBean rMBean = bean;
            synchronized (rMBean) {
                InMemoryTransaction other = (InMemoryTransaction)bean.getTransaction();
                while (other != null && other != this) {
                    this.waitingForTran = other;
                    if (!this.enlistedBeans.isEmpty()) {
                        HashSet<InMemoryTransaction> set = new HashSet<InMemoryTransaction>();
                        set.add(this);
                        while (other != null) {
                            if (set.contains(other)) {
                                String message = SandeshaMessageHelper.getMessage("deadlock", this.toString(), bean.toString());
                                SandeshaStorageException e = new SandeshaStorageException(message);
                                if (log.isWarnEnabled()) {
                                    log.warn(message);
                                }
                                this.waitingForTran = null;
                                this.releaseLocks();
                                if (log.isDebugEnabled()) {
                                    log.debug(message, e);
                                }
                                throw e;
                            }
                            set.add(other);
                            other = other.waitingForTran;
                        }
                    }
                    boolean warn = false;
                    try {
                        if (log.isDebugEnabled()) {
                            log.debug("This " + this + " waiting for " + this.waitingForTran);
                        }
                        long pre = System.currentTimeMillis();
                        bean.wait(2000L);
                        long post = System.currentTimeMillis();
                        if (post - pre > 20000L) {
                            warn = true;
                        }
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    if ((other = (InMemoryTransaction)bean.getTransaction()) == null || !warn) continue;
                    String message = SandeshaMessageHelper.getMessage("possibledeadlock", this.toString(), bean.toString());
                    if (!log.isDebugEnabled()) continue;
                    log.debug(message);
                }
                this.waitingForTran = null;
                if (other == null) {
                    if (log.isDebugEnabled()) {
                        log.debug(this + " locking bean");
                    }
                    bean.setTransaction(this);
                    this.enlistedBeans.add(bean);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: InMemoryTransaction::enlist");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLocks() {
        if (log.isDebugEnabled()) {
            log.debug("Entry: InMemoryTransaction::releaseLocks, " + this);
        }
        this.manager.removeTransaction(this);
        Iterator beans = this.enlistedBeans.iterator();
        while (beans.hasNext()) {
            RMBean bean;
            RMBean rMBean = bean = (RMBean)beans.next();
            synchronized (rMBean) {
                bean.setTransaction(null);
                bean.notify();
            }
        }
        this.enlistedBeans.clear();
        if (log.isDebugEnabled()) {
            log.debug("Exit: InMemoryTransaction::releaseLocks");
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[InMemoryTransaction, id:");
        result.append(this.threadId);
        result.append(", name: ");
        result.append(this.threadName);
        result.append(", locks: ");
        result.append(this.enlistedBeans.size());
        result.append("]");
        return result.toString();
    }

    public void setSentMessages(boolean sentMessages) {
        this.sentMessages = sentMessages;
    }

    Integer getThreadId() {
        return this.threadId;
    }
}

