/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMBean;
import org.apache.sandesha2.storage.inmemory.InMemoryInvokerBeanMgr;
import org.apache.sandesha2.storage.inmemory.InMemoryRMDBeanMgr;
import org.apache.sandesha2.storage.inmemory.InMemoryRMSBeanMgr;
import org.apache.sandesha2.storage.inmemory.InMemorySenderBeanMgr;
import org.apache.sandesha2.storage.inmemory.InMemoryTransaction;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.workers.SandeshaThread;
import org.apache.sandesha2.workers.Sender;

public class InMemoryStorageManager
extends StorageManager {
    private static Log log = LogFactory.getLog(InMemoryStorageManager.class);
    private static InMemoryStorageManager instance = null;
    private RMSBeanMgr rMSBeanMgr = null;
    private RMDBeanMgr rMDBeanMgr = null;
    private SenderBeanMgr senderBeanMgr = null;
    private InvokerBeanMgr invokerBeanMgr = null;
    private Sender sender = null;
    private PollingManager pollingManager = null;
    private ConcurrentHashMap transactions = new ConcurrentHashMap();
    private boolean useSerialization = false;
    private ConcurrentHashMap storageMap = new ConcurrentHashMap();

    public InMemoryStorageManager(ConfigurationContext context) throws SandeshaException {
        super(context);
        SandeshaPolicyBean policy = SandeshaUtil.getPropertyBean(context.getAxisConfiguration());
        this.useSerialization = policy.isUseMessageSerialization();
        boolean polling = policy.isEnableMakeConnection();
        this.rMSBeanMgr = new InMemoryRMSBeanMgr(this, context);
        this.rMDBeanMgr = new InMemoryRMDBeanMgr(this, context);
        this.senderBeanMgr = new InMemorySenderBeanMgr(this, context);
        this.invokerBeanMgr = new InMemoryInvokerBeanMgr(this, context);
        this.sender = new Sender();
        if (polling) {
            this.pollingManager = new PollingManager();
        }
    }

    private Integer getCurrentThreadKey() {
        return new Integer(System.identityHashCode(Thread.currentThread()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Transaction getTransaction() {
        InMemoryTransaction result = null;
        Integer key = this.getCurrentThreadKey();
        String name = Thread.currentThread().getName();
        ConcurrentHashMap concurrentHashMap = this.transactions;
        synchronized (concurrentHashMap) {
            result = (InMemoryTransaction)this.transactions.get(key);
            if (result == null) {
                result = new InMemoryTransaction(this, name, key);
                this.transactions.put(key, result);
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Possible re-used transaction: " + result);
                }
                result = null;
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InMemoryTransaction getInMemoryTransaction() {
        InMemoryTransaction result = null;
        Integer key = this.getCurrentThreadKey();
        ConcurrentHashMap concurrentHashMap = this.transactions;
        synchronized (concurrentHashMap) {
            result = (InMemoryTransaction)this.transactions.get(key);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTransaction(InMemoryTransaction t) {
        ConcurrentHashMap concurrentHashMap = this.transactions;
        synchronized (concurrentHashMap) {
            this.transactions.remove(t.getThreadId());
        }
    }

    public SandeshaThread getInvoker() {
        return null;
    }

    public SandeshaThread getSender() {
        return this.sender;
    }

    public PollingManager getPollingManager() {
        return this.pollingManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void enlistBean(RMBean bean) throws SandeshaStorageException {
        InMemoryTransaction t = null;
        Integer key = this.getCurrentThreadKey();
        ConcurrentHashMap concurrentHashMap = this.transactions;
        synchronized (concurrentHashMap) {
            t = (InMemoryTransaction)this.transactions.get(key);
            if (t == null) {
                String message = SandeshaMessageHelper.getMessage("noTransaction");
                SandeshaStorageException e = new SandeshaStorageException(message);
                if (log.isDebugEnabled()) {
                    log.debug(message, e);
                }
                throw e;
            }
        }
        t.enlist(bean);
    }

    public RMSBeanMgr getRMSBeanMgr() {
        return this.rMSBeanMgr;
    }

    public RMDBeanMgr getRMDBeanMgr() {
        return this.rMDBeanMgr;
    }

    public SenderBeanMgr getSenderBeanMgr() {
        return this.senderBeanMgr;
    }

    public InvokerBeanMgr getInvokerBeanMgr() {
        return this.invokerBeanMgr;
    }

    public static InMemoryStorageManager getInstance(ConfigurationContext context) throws SandeshaException {
        if (instance == null) {
            instance = new InMemoryStorageManager(context);
        }
        return instance;
    }

    public MessageContext retrieveMessageContext(String key, ConfigurationContext context) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InMemoryStorageManager::retrieveMessageContext, key: " + key);
        }
        MessageContext messageContext = null;
        try {
            if (this.useSerialization) {
                SerializedStorageEntry entry = (SerializedStorageEntry)this.storageMap.get(key);
                if (entry != null) {
                    if (entry.message != null) {
                        messageContext = entry.message;
                        entry.message = null;
                    } else {
                        MessageContext inMsgCtx;
                        ByteArrayInputStream stream = new ByteArrayInputStream(entry.data);
                        ObjectInputStream is = new ObjectInputStream(stream);
                        messageContext = (MessageContext)is.readObject();
                        messageContext.activate(entry.context);
                        OperationContext opCtx = messageContext.getOperationContext();
                        if (opCtx != null && (inMsgCtx = opCtx.getMessageContext("In")) != null) {
                            inMsgCtx.setProperty("RequestResponseTransportControl", entry.inTransportControl);
                            inMsgCtx.setProperty("TRANSPORT_OUT", entry.inTransportOut);
                            inMsgCtx.setProperty("OutTransportInfo", entry.inTransportOutInfo);
                        }
                        messageContext.setProperty("RequestResponseTransportControl", entry.transportControl);
                        messageContext.setProperty("TRANSPORT_OUT", entry.transportOut);
                        messageContext.setProperty("OutTransportInfo", entry.transportOutInfo);
                    }
                }
            } else {
                StorageEntry entry = (StorageEntry)this.storageMap.get(key);
                if (entry != null) {
                    messageContext = entry.msgContext;
                    SOAPEnvelope clonedEnvelope = SandeshaUtil.copySOAPEnvelope(entry.envelope);
                    messageContext.setEnvelope(clonedEnvelope);
                }
            }
        }
        catch (Exception e) {
            String message = SandeshaMessageHelper.getMessage("failedToLoadMessage", e.toString());
            if (log.isDebugEnabled()) {
                log.debug(message);
            }
            throw new SandeshaStorageException(message, e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: InMemoryStorageManager::retrieveMessageContext, " + messageContext);
        }
        return messageContext;
    }

    public void storeMessageContext(String key, MessageContext msgContext) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InMemoryStorageManager::storeMessageContext, key: " + key);
        }
        if (key == null) {
            key = SandeshaUtil.getUUID();
        }
        try {
            if (this.useSerialization) {
                MessageContext inMsgCtx;
                ByteArrayOutputStream stream = new ByteArrayOutputStream();
                SandeshaUtil.removeMustUnderstand(msgContext.getEnvelope());
                ObjectOutputStream s = new ObjectOutputStream(stream);
                s.writeObject(msgContext);
                s.close();
                SerializedStorageEntry entry = new SerializedStorageEntry();
                entry.message = msgContext;
                entry.data = stream.toByteArray();
                entry.context = msgContext.getConfigurationContext();
                OperationContext opCtx = msgContext.getOperationContext();
                if (opCtx != null && (inMsgCtx = opCtx.getMessageContext("In")) != null) {
                    entry.inTransportControl = inMsgCtx.getProperty("RequestResponseTransportControl");
                    entry.inTransportOut = inMsgCtx.getProperty("TRANSPORT_OUT");
                    entry.inTransportOutInfo = inMsgCtx.getProperty("OutTransportInfo");
                }
                entry.transportControl = msgContext.getProperty("RequestResponseTransportControl");
                entry.transportOut = msgContext.getProperty("TRANSPORT_OUT");
                entry.transportOutInfo = msgContext.getProperty("OutTransportInfo");
                this.storageMap.put(key, entry);
            } else {
                StorageEntry entry = new StorageEntry();
                entry.msgContext = msgContext;
                entry.envelope = msgContext.getEnvelope();
                this.storageMap.put(key, entry);
            }
        }
        catch (Exception e) {
            String message = SandeshaMessageHelper.getMessage("failedToStoreMessage", e.toString());
            if (log.isDebugEnabled()) {
                log.debug(message);
            }
            throw new SandeshaStorageException(message, e);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: InMemoryStorageManager::storeMessageContext, key: " + key);
        }
    }

    public void updateMessageContext(String key, MessageContext msgContext) throws SandeshaStorageException {
        Object oldEntry;
        if (log.isDebugEnabled()) {
            log.debug("Enter: InMemoryStorageManager::updateMessageContext, key: " + key);
        }
        if ((oldEntry = this.storageMap.remove(key)) == null) {
            throw new SandeshaStorageException(SandeshaMessageHelper.getMessage("entryNotPresentForUpdating"));
        }
        this.storeMessageContext(key, msgContext);
        if (log.isDebugEnabled()) {
            log.debug("Exit: InMemoryStorageManager::updateMessageContext, key: " + key);
        }
    }

    public void removeMessageContext(String key) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: InMemoryStorageManager::removeMessageContext, key: " + key);
        }
        this.storageMap.remove(key);
        if (log.isDebugEnabled()) {
            log.debug("Exit: InMemoryStorageManager::removeMessageContext, key: " + key);
        }
    }

    public void initStorage(AxisModule moduleDesc) {
    }

    public boolean hasUserTransaction(MessageContext msg) {
        return false;
    }

    public boolean requiresMessageSerialization() {
        return this.useSerialization;
    }

    private class StorageEntry {
        MessageContext msgContext;
        SOAPEnvelope envelope;

        private StorageEntry() {
        }
    }

    private class SerializedStorageEntry {
        MessageContext message;
        byte[] data;
        ConfigurationContext context;
        Object transportControl;
        Object transportOut;
        Object transportOutInfo;
        Object inTransportControl;
        Object inTransportOut;
        Object inTransportOutInfo;

        private SerializedStorageEntry() {
        }
    }
}

