/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.util.List;
import org.apache.axis2.context.AbstractContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.storage.inmemory.InMemoryBeanMgr;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;

public class InMemorySenderBeanMgr
extends InMemoryBeanMgr
implements SenderBeanMgr {
    private static final Log log = LogFactory.getLog(InMemorySenderBeanMgr.class);

    public InMemorySenderBeanMgr(InMemoryStorageManager mgr, AbstractContext context) {
        super(mgr, context, "RetransmitterBeanMap");
    }

    public boolean delete(String MessageId) throws SandeshaStorageException {
        return super.delete(MessageId);
    }

    public SenderBean retrieve(String MessageId) throws SandeshaStorageException {
        return (SenderBean)super.retrieve(MessageId);
    }

    public boolean insert(SenderBean bean) throws SandeshaStorageException {
        if (bean.getMessageID() == null) {
            throw new SandeshaStorageException(SandeshaMessageHelper.getMessage("nullMsgId"));
        }
        boolean result = super.insert(bean.getMessageID(), bean);
        this.mgr.getInMemoryTransaction().setSentMessages(true);
        return result;
    }

    public List find(String internalSequenceID) throws SandeshaStorageException {
        SenderBean temp = new SenderBean();
        temp.setInternalSequenceID(internalSequenceID);
        return super.find(temp);
    }

    public List find(SenderBean bean) throws SandeshaStorageException {
        return super.find(bean);
    }

    public SenderBean getNextMsgToSend(String sequenceId) throws SandeshaStorageException {
        if (log.isDebugEnabled()) {
            log.debug("Entry: InMemorySenderBeanManager::getNextMessageToSend " + sequenceId);
        }
        SenderBean matcher = new SenderBean();
        matcher.setSend(true);
        matcher.setSequenceID(sequenceId);
        matcher.setTimeToSend(System.currentTimeMillis());
        matcher.setTransportAvailable(true);
        List matches = super.find(matcher);
        if (log.isDebugEnabled()) {
            log.debug("Found " + matches.size() + " messages");
        }
        SenderBean result = null;
        for (SenderBean bean : matches) {
            if (bean.getTimeToSend() < 0L || bean.getSentCount() > 0 && !bean.isReSend() || !bean.match(matcher)) continue;
            if (result == null) {
                result = bean;
                continue;
            }
            if (result.getTimeToSend() <= bean.getTimeToSend()) continue;
            result = bean;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: InMemorySenderBeanManager::getNextMessageToSend " + result);
        }
        return result;
    }

    public boolean update(SenderBean bean) throws SandeshaStorageException {
        boolean result = super.update(bean.getMessageID(), bean);
        this.mgr.getInMemoryTransaction().setSentMessages(true);
        return result;
    }

    public SenderBean findUnique(SenderBean bean) throws SandeshaException {
        return (SenderBean)super.findUnique(bean);
    }

    public SenderBean retrieveFromMessageRefKey(String messageContextRefKey) {
        throw new UnsupportedOperationException("Deprecated method");
    }
}

