/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.inmemory;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.apache.axis2.context.AbstractContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.beans.RMBean;
import org.apache.sandesha2.storage.inmemory.InMemoryStorageManager;

abstract class InMemoryBeanMgr {
    private static final Log log = LogFactory.getLog(InMemoryBeanMgr.class);
    protected Hashtable table;
    protected InMemoryStorageManager mgr;

    protected InMemoryBeanMgr(InMemoryStorageManager mgr, AbstractContext context, String key) {
        this.mgr = mgr;
        Object obj = context.getProperty(key);
        if (obj != null) {
            this.table = (Hashtable)obj;
        } else {
            this.table = new Hashtable();
            context.setProperty(key, this.table);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean insert(Object key, RMBean bean) throws SandeshaStorageException {
        this.mgr.enlistBean(bean);
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            this.table.put(key, bean);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean delete(Object key) throws SandeshaStorageException {
        RMBean bean = null;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            bean = (RMBean)this.table.get(key);
        }
        if (bean != null) {
            this.mgr.enlistBean(bean);
            hashtable = this.table;
            synchronized (hashtable) {
                bean = (RMBean)this.table.remove(key);
            }
        }
        return bean != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RMBean retrieve(Object key) throws SandeshaStorageException {
        RMBean bean = null;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            bean = (RMBean)this.table.get(key);
        }
        if (bean != null) {
            this.mgr.enlistBean(bean);
            hashtable = this.table;
            synchronized (hashtable) {
                bean = (RMBean)this.table.get(key);
            }
        }
        return bean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean update(Object key, RMBean bean) throws SandeshaStorageException {
        this.mgr.enlistBean(bean);
        RMBean oldBean = null;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            oldBean = (RMBean)this.table.get(key);
            this.table.put(key, bean);
        }
        if (oldBean == null) {
            return false;
        }
        this.mgr.enlistBean(oldBean);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List find(RMBean matchInfo) throws SandeshaStorageException {
        ArrayList<Object> beans = new ArrayList<Object>();
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            if (matchInfo == null) {
                beans.addAll(this.table.values());
            } else {
                for (RMBean candidate : this.table.values()) {
                    if (!candidate.match(matchInfo)) continue;
                    beans.add(candidate);
                }
            }
        }
        Iterator i = beans.iterator();
        while (i.hasNext()) {
            this.mgr.enlistBean((RMBean)i.next());
        }
        Hashtable hashtable2 = this.table;
        synchronized (hashtable2) {
            i = beans.iterator();
            while (i.hasNext()) {
                RMBean bean = (RMBean)i.next();
                if (this.table.containsValue(bean)) continue;
                i.remove();
            }
        }
        return beans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RMBean findUnique(RMBean matchInfo) throws SandeshaStorageException {
        RMBean result = this.findUniqueNoLock(matchInfo);
        if (result != null) {
            this.mgr.enlistBean(result);
            Hashtable hashtable = this.table;
            synchronized (hashtable) {
                if (!this.table.containsValue(result)) {
                    result = null;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RMBean findUniqueNoLock(RMBean matchInfo) throws SandeshaStorageException {
        RMBean result = null;
        Hashtable hashtable = this.table;
        synchronized (hashtable) {
            for (RMBean candidate : this.table.values()) {
                if (!candidate.match(matchInfo)) continue;
                if (result == null) {
                    result = candidate;
                    continue;
                }
                String message = SandeshaMessageHelper.getMessage("nonUniqueResult", result.toString(), candidate.toString());
                SandeshaStorageException e = new SandeshaStorageException(message);
                log.error(message, e);
                throw e;
            }
        }
        return result;
    }
}

