/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage.beans;

import org.apache.sandesha2.storage.beans.RMBean;

public class SenderBean
extends RMBean {
    private static final long serialVersionUID = 5776347847725156786L;
    private String messageID;
    private String messageContextRefKey;
    private String internalSequenceID;
    private String sequenceID;
    private String toAddress;
    private String inboundSequence;
    private boolean send;
    private int sentCount = 0;
    private long messageNumber = 0L;
    private boolean reSend = true;
    private long timeToSend = 0L;
    private int messageType = 0;
    private boolean lastMessage = false;
    private long inboundMessageNumber;
    private boolean transportAvailable = true;
    private int flags = 0;
    private static final int SEND_FLAG = 1;
    private static final int SEND_COUNT_FLAG = 16;
    private static final int MSG_NUMBER_FLAG = 256;
    private static final int RESEND_FLAG = 4096;
    private static final int TIME_TO_SEND_FLAG = 65536;
    private static final int MSG_TYPE_FLAG = 0x100000;
    private static final int LAST_MSG_FLAG = 0x1000000;
    private static final int IN_MSG_NUM_FLAG = 0x10000000;
    private static final int TRANSPORT_FLAG = 2;

    public SenderBean() {
    }

    public SenderBean(String messageID, String key, boolean send, long timeToSend, String internalSequenceID, long messageNumber) {
        this.setMessageID(messageID);
        this.setMessageContextRefKey(key);
        this.setTimeToSend(timeToSend);
        this.setSend(send);
        this.setInternalSequenceID(internalSequenceID);
        this.setMessageNumber(messageNumber);
    }

    public String getMessageContextRefKey() {
        return this.messageContextRefKey;
    }

    public void setMessageContextRefKey(String messageContextRefKey) {
        this.messageContextRefKey = messageContextRefKey;
    }

    public String getMessageID() {
        return this.messageID;
    }

    public void setMessageID(String messageID) {
        this.messageID = messageID;
    }

    public boolean isSend() {
        return this.send;
    }

    public void setSend(boolean send) {
        this.send = send;
        this.flags |= 1;
    }

    public String getInternalSequenceID() {
        return this.internalSequenceID;
    }

    public void setInternalSequenceID(String internalSequenceId) {
        this.internalSequenceID = internalSequenceId;
    }

    public int getSentCount() {
        return this.sentCount;
    }

    public void setSentCount(int sentCount) {
        this.sentCount = sentCount;
        this.flags |= 0x10;
    }

    public long getMessageNumber() {
        return this.messageNumber;
    }

    public void setMessageNumber(long messageNumber) {
        this.messageNumber = messageNumber;
        this.flags |= 0x100;
    }

    public boolean isReSend() {
        return this.reSend;
    }

    public void setReSend(boolean reSend) {
        this.reSend = reSend;
        this.flags |= 0x1000;
    }

    public long getTimeToSend() {
        return this.timeToSend;
    }

    public void setTimeToSend(long timeToSend) {
        this.timeToSend = timeToSend;
        this.flags |= 0x10000;
    }

    public int getMessageType() {
        return this.messageType;
    }

    public void setMessageType(int messagetype) {
        this.messageType = messagetype;
        this.flags |= 0x100000;
    }

    public String getSequenceID() {
        return this.sequenceID;
    }

    public void setSequenceID(String sequenceID) {
        this.sequenceID = sequenceID;
    }

    public String getToAddress() {
        return this.toAddress;
    }

    public void setToAddress(String toAddress) {
        this.toAddress = toAddress;
    }

    public boolean isLastMessage() {
        return this.lastMessage;
    }

    public void setLastMessage(boolean lastMessage) {
        this.lastMessage = lastMessage;
        this.flags |= 0x1000000;
    }

    public long getInboundMessageNumber() {
        return this.inboundMessageNumber;
    }

    public void setInboundMessageNumber(long inboundMessageNumber) {
        this.inboundMessageNumber = inboundMessageNumber;
        this.flags |= 0x10000000;
    }

    public String getInboundSequenceId() {
        return this.inboundSequence;
    }

    public void setInboundSequenceId(String inboundSequence) {
        this.inboundSequence = inboundSequence;
    }

    public boolean isTransportAvailable() {
        return this.transportAvailable;
    }

    public void setTransportAvailable(boolean transportAvailable) {
        this.transportAvailable = transportAvailable;
        this.flags |= 2;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.getClass().getName());
        result.append("\nSequence Id    : ");
        result.append(this.sequenceID);
        result.append("\nInternal Seq Id: ");
        result.append(this.internalSequenceID);
        result.append("\nTo             : ");
        result.append(this.toAddress);
        result.append("\nMessage Number : ");
        result.append(this.messageNumber);
        result.append("\nMessage Type   : ");
        result.append(this.messageType);
        result.append("\nMessage Key    : ");
        result.append(this.messageContextRefKey);
        result.append("\nSend           : ");
        result.append(this.send);
        result.append("\nResend         : ");
        result.append(this.reSend);
        result.append("\nSent count     : ");
        result.append(this.sentCount);
        result.append("\nTime to send   : ");
        result.append(this.timeToSend);
        result.append("\nTransport avail: ");
        result.append(this.transportAvailable);
        return result.toString();
    }

    public boolean match(RMBean matchInfo) {
        SenderBean bean = (SenderBean)matchInfo;
        boolean match = true;
        if (bean.getMessageID() != null && !bean.getMessageID().equals(this.getMessageID())) {
            match = false;
        } else if (bean.getMessageContextRefKey() != null && !bean.getMessageContextRefKey().equals(this.getMessageContextRefKey())) {
            match = false;
        } else if (bean.getInternalSequenceID() != null && !bean.getInternalSequenceID().equals(this.getInternalSequenceID())) {
            match = false;
        } else if (bean.getSequenceID() != null && !bean.getSequenceID().equals(this.getSequenceID())) {
            match = false;
        } else if (bean.getToAddress() != null && !bean.getToAddress().equals(this.getToAddress())) {
            match = false;
        } else if (bean.getInboundSequenceId() != null && !bean.getInboundSequenceId().equals(this.getInboundSequenceId())) {
            match = false;
        } else if ((bean.flags & 1) != 0 && bean.isSend() != this.isSend()) {
            match = false;
        } else if ((bean.flags & 0x10) != 0 && bean.getSentCount() != this.getSentCount()) {
            match = false;
        } else if ((bean.flags & 0x100) != 0 && bean.getMessageNumber() != this.getMessageNumber()) {
            match = false;
        } else if ((bean.flags & 0x1000) != 0 && bean.isReSend() != this.isReSend()) {
            match = false;
        } else if ((bean.flags & 0x10000) != 0 && bean.getTimeToSend() < this.getTimeToSend()) {
            match = false;
        } else if ((bean.flags & 0x100000) != 0 && bean.getMessageType() != this.getMessageType()) {
            match = false;
        } else if ((bean.flags & 0x1000000) != 0 && bean.isLastMessage() != this.isLastMessage()) {
            match = false;
        } else if ((bean.flags & 0x10000000) != 0 && bean.getInboundMessageNumber() != this.getInboundMessageNumber()) {
            match = false;
        } else if ((bean.flags & 2) != 0 && bean.isTransportAvailable() != this.isTransportAvailable()) {
            match = false;
        }
        return match;
    }
}

