/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.storage;

import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisModule;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.InvokerBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.workers.SandeshaThread;

public abstract class StorageManager {
    private ConfigurationContext context;

    public StorageManager(ConfigurationContext context) {
        this.context = context;
    }

    public ConfigurationContext getContext() {
        return this.context;
    }

    public void setContext(ConfigurationContext context) {
        if (context != null) {
            this.context = context;
        }
    }

    public void shutdown() {
        this.getSender().stopRunning();
        SandeshaThread thread = this.getInvoker();
        if (thread != null) {
            thread.stopRunning();
        }
        if ((thread = this.getPollingManager()) != null) {
            thread.stopRunning();
        }
    }

    public abstract void initStorage(AxisModule var1) throws SandeshaStorageException;

    public abstract Transaction getTransaction();

    public abstract SandeshaThread getSender();

    public abstract SandeshaThread getInvoker();

    public abstract PollingManager getPollingManager();

    public abstract RMSBeanMgr getRMSBeanMgr();

    public abstract RMDBeanMgr getRMDBeanMgr();

    public abstract SenderBeanMgr getSenderBeanMgr();

    public abstract InvokerBeanMgr getInvokerBeanMgr();

    public abstract void storeMessageContext(String var1, MessageContext var2) throws SandeshaStorageException;

    public abstract void updateMessageContext(String var1, MessageContext var2) throws SandeshaStorageException;

    public abstract MessageContext retrieveMessageContext(String var1, ConfigurationContext var2) throws SandeshaStorageException;

    public abstract void removeMessageContext(String var1) throws SandeshaStorageException;

    public abstract boolean hasUserTransaction(MessageContext var1) throws SandeshaStorageException;

    public abstract boolean requiresMessageSerialization();
}

