/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgreceivers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.receivers.AbstractMessageReceiver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.msgprocessors.MsgProcessorFactory;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;

public class RMMessageReceiver
extends AbstractMessageReceiver {
    private static final Log log = LogFactory.getLog(RMMessageReceiver.class);

    public final void receive(MessageContext msgCtx) throws AxisFault {
        MsgProcessor msgProcessor;
        if (log.isDebugEnabled()) {
            log.debug("Entry: RMMessageReceiver::receive");
        }
        RMMsgContext rmMsgCtx = null;
        rmMsgCtx = msgCtx.getProperty("RMMessageContext") != null ? (RMMsgContext)msgCtx.getProperty("RMMessageContext") : MsgInitializer.initializeMessage(msgCtx);
        if (log.isDebugEnabled()) {
            log.debug("MsgReceiver got type: " + SandeshaUtil.getMessageTypeString(rmMsgCtx.getMessageType()));
        }
        if ((msgProcessor = MsgProcessorFactory.getMessageProcessor(rmMsgCtx)) != null) {
            Parameter unreliableParam;
            Transaction transaction = null;
            if (msgCtx.getAxisService() != null && null != (unreliableParam = msgCtx.getAxisService().getParameter(SandeshaClientConstants.UNRELIABLE_MESSAGE)) && "true".equals(unreliableParam.getValue())) {
                if (rmMsgCtx.getMessageType() != 1) {
                    throw new AxisFault(SandeshaMessageHelper.getMessage("reliableMessagingNotEnabled", msgCtx.getAxisService().getName()));
                }
                FaultManager.makeCreateSequenceRefusedFault(rmMsgCtx, SandeshaMessageHelper.getMessage("reliableMessagingNotEnabled", msgCtx.getAxisService().getName()), new Exception());
                log.debug("Exit: RMMessageReceiver::receive, Service has disabled RM ");
                return;
            }
            try {
                ConfigurationContext context = msgCtx.getConfigurationContext();
                StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration());
                transaction = storageManager.getTransaction();
                msgProcessor.processInMessage(rmMsgCtx, transaction);
                if (transaction != null && transaction.isActive()) {
                    transaction.commit();
                }
                transaction = null;
            }
            catch (Exception e) {
                if (log.isDebugEnabled()) {
                    log.debug("Exception caught during processInMessage", e);
                }
                msgCtx.pause();
                if (!(e instanceof AxisFault)) {
                    String message = SandeshaMessageHelper.getMessage("inMsgError", e.toString());
                    throw new AxisFault(message, e);
                }
                throw (AxisFault)e;
            }
            finally {
                if (transaction != null && transaction.isActive()) {
                    try {
                        transaction.rollback();
                    }
                    catch (Exception e1) {
                        String message = SandeshaMessageHelper.getMessage("rollbackError", e1.toString());
                        log.debug(message, e1);
                    }
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: RMMessageReceiver::receive");
        }
    }
}

