/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.MessageRetransmissionAdjuster;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.workers.SenderWorker;
import org.apache.sandesha2.wsrm.Address;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.MakeConnection;
import org.apache.sandesha2.wsrm.MessagePending;

public class MakeConnectionProcessor
implements MsgProcessor {
    private static final Log log = LogFactory.getLog(MakeConnectionProcessor.class);

    public boolean processInMessage(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: MakeConnectionProcessor::processInMessage " + rmMsgCtx.getSOAPEnvelope().getBody());
        }
        MakeConnection makeConnection = (MakeConnection)rmMsgCtx.getMessagePart(17);
        Address address = makeConnection.getAddress();
        Identifier identifier = makeConnection.getIdentifier();
        ConfigurationContext configurationContext = rmMsgCtx.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        SenderBeanMgr senderBeanMgr = storageManager.getSenderBeanMgr();
        SenderBean findSenderBean = new SenderBean();
        findSenderBean.setSend(true);
        findSenderBean.setTransportAvailable(false);
        if (address != null) {
            findSenderBean.setToAddress(address.getAddress());
        }
        if (identifier != null) {
            findSenderBean.setSequenceID(identifier.getIdentifier());
        }
        findSenderBean.setTimeToSend(System.currentTimeMillis());
        List collection = senderBeanMgr.find(findSenderBean);
        Iterator it = collection.iterator();
        while (it.hasNext()) {
            SenderBean bean = (SenderBean)it.next();
            if (bean.isReSend() || bean.getSentCount() <= 0) continue;
            it.remove();
        }
        int size = collection.size();
        int itemToPick = -1;
        boolean pending = false;
        if (size > 0) {
            Random random = new Random();
            itemToPick = random.nextInt(size);
        }
        if (size > 1) {
            pending = true;
        }
        Iterator it2 = collection.iterator();
        SenderBean senderBean = null;
        for (int item = 0; item < size; ++item) {
            senderBean = (SenderBean)it2.next();
            if (item == itemToPick) break;
        }
        if (senderBean == null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: MakeConnectionProcessor::processInMessage, no matching message found");
            }
            return false;
        }
        if (transaction != null && transaction.isActive()) {
            transaction.commit();
            transaction = storageManager.getTransaction();
        }
        MakeConnectionProcessor.replyToPoll(rmMsgCtx, senderBean, storageManager, pending, makeConnection.getNamespaceValue(), transaction);
        if (log.isDebugEnabled()) {
            log.debug("Exit: MakeConnectionProcessor::processInMessage");
        }
        return false;
    }

    public static void replyToPoll(RMMsgContext pollMessage, SenderBean matchingMessage, StorageManager storageManager, boolean pending, String namespace, Transaction transaction) throws AxisFault {
        TransportOutDescription transportOut;
        if (log.isDebugEnabled()) {
            log.debug("Enter: MakeConnectionProcessor::replyToPoll");
        }
        if ((transportOut = pollMessage.getMessageContext().getTransportOut()) == null) {
            String message = SandeshaMessageHelper.getMessage("cantSendMakeConnectionNoTransportOut");
            if (log.isDebugEnabled()) {
                log.debug(message);
            }
            throw new SandeshaException(message);
        }
        String messageStorageKey = matchingMessage.getMessageContextRefKey();
        MessageContext returnMessage = storageManager.retrieveMessageContext(messageStorageKey, pollMessage.getConfigurationContext());
        if (returnMessage == null) {
            String message = "Cannot find the message stored with the key:" + messageStorageKey;
            if (log.isDebugEnabled()) {
                log.debug(message);
            }
            return;
        }
        if (pending) {
            MakeConnectionProcessor.addMessagePendingHeader(returnMessage, namespace);
        }
        boolean continueSending = true;
        RMMsgContext returnRMMsg = MsgInitializer.initializeMessage(returnMessage);
        if (returnRMMsg.getRMNamespaceValue() == null) {
            String sequenceID;
            if (log.isDebugEnabled()) {
                log.debug("Looking up rmNamespace from RMS bean");
            }
            if ((sequenceID = matchingMessage.getSequenceID()) != null) {
                RMSBean rmsBean = new RMSBean();
                rmsBean.setSequenceID(sequenceID);
                rmsBean = storageManager.getRMSBeanMgr().findUnique(rmsBean);
                if (rmsBean != null) {
                    returnRMMsg.setRMNamespaceValue(SpecSpecificConstants.getRMNamespaceValue(rmsBean.getRMVersion()));
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Could not find RMS bean for polled msg");
                    }
                    continueSending = false;
                    storageManager.getSenderBeanMgr().delete(matchingMessage.getMessageID());
                }
            }
        }
        if (continueSending) {
            MakeConnectionProcessor.setTransportProperties(returnMessage, pollMessage);
            OperationContext context = pollMessage.getMessageContext().getOperationContext();
            if (context == null) {
                AxisOperation oldOperation = returnMessage.getAxisOperation();
                context = ContextFactory.createOperationContext(oldOperation, returnMessage.getServiceContext());
                context.addMessageContext(pollMessage.getMessageContext());
                pollMessage.getMessageContext().setOperationContext(context);
            }
            context.addMessageContext(returnMessage);
            returnMessage.setOperationContext(context);
            returnMessage.setProperty("MakeConnectionResponse", Boolean.TRUE);
            continueSending = MessageRetransmissionAdjuster.adjustRetransmittion(returnRMMsg, matchingMessage, returnRMMsg.getConfigurationContext(), storageManager);
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
        }
        if (continueSending) {
            SenderWorker worker = new SenderWorker(pollMessage.getConfigurationContext(), matchingMessage, returnRMMsg.getRMSpecVersion());
            worker.setMessage(returnRMMsg);
            worker.run();
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: MakeConnectionProcessor::replyToPoll");
        }
    }

    private static void addMessagePendingHeader(MessageContext returnMessage, String namespace) throws SandeshaException {
        MessagePending messagePending = new MessagePending(namespace);
        messagePending.setPending(true);
        messagePending.toSOAPEnvelope(returnMessage.getEnvelope());
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx, Transaction transaction) {
        return false;
    }

    private static void setTransportProperties(MessageContext returnMessage, RMMsgContext makeConnectionMessage) {
        returnMessage.setProperty("TRANSPORT_OUT", makeConnectionMessage.getProperty("TRANSPORT_OUT"));
        returnMessage.setProperty("OutTransportInfo", makeConnectionMessage.getProperty("OutTransportInfo"));
        Object contentType = makeConnectionMessage.getProperty("ContentType");
        returnMessage.setProperty("ContentType", contentType);
        returnMessage.setTransportOut(makeConnectionMessage.getMessageContext().getTransportOut());
    }
}

