/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.Options;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.Sequence;

public class LastMessageProcessor
implements MsgProcessor {
    private static final Log log = LogFactory.getLog(LastMessageProcessor.class);

    public boolean processInMessage(RMMsgContext rmMsgCtx, Transaction transaction) throws AxisFault {
        LastMessageProcessor.processLastMessage(rmMsgCtx);
        return true;
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx, Transaction transaction) {
        return false;
    }

    public static void processLastMessage(RMMsgContext rmMsgCtx) throws AxisFault {
        RMDBean rmdBean;
        String outBoundInternalSequence;
        if (log.isDebugEnabled()) {
            log.debug("Enter: LastMessageProcessor::processLastMessage");
        }
        if (!"Spec_2005_02".equals(rmMsgCtx.getRMSpecVersion())) {
            return;
        }
        Sequence sequence = (Sequence)rmMsgCtx.getMessagePart(6);
        String sequenceId = sequence.getIdentifier().getIdentifier();
        ConfigurationContext configurationContext = rmMsgCtx.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, outBoundInternalSequence = (rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceId)).getOutboundInternalSequence());
        if (rmsBean != null && rmsBean.getLastOutMessage() <= 0L) {
            MessageContext msgContext = rmMsgCtx.getMessageContext();
            AxisOperation operation = SpecSpecificConstants.getWSRMOperation(12, rmMsgCtx.getRMSpecVersion(), msgContext.getAxisService());
            MessageContext outMessageContext = SandeshaUtil.createNewRelatedMessageContext(rmMsgCtx, operation);
            outMessageContext.setServerSide(true);
            outMessageContext.setTransportOut(msgContext.getTransportOut());
            outMessageContext.setProperty("OutTransportInfo", msgContext.getProperty("OutTransportInfo"));
            outMessageContext.setProperty("TRANSPORT_OUT", msgContext.getProperty("TRANSPORT_OUT"));
            SOAPFactory factory = (SOAPFactory)msgContext.getEnvelope().getOMFactory();
            SOAPEnvelope envelope = factory.getDefaultEnvelope();
            outMessageContext.setEnvelope(envelope);
            if (outMessageContext.getOptions() == null) {
                outMessageContext.setOptions(new Options());
            }
            OperationContext operationContext = outMessageContext.getOperationContext();
            String inboundSequenceId = (String)msgContext.getProperty("Sandesha2InboundSequenceId");
            operationContext.setProperty("Sandesha2InboundSequenceId", inboundSequenceId);
            Long inboundMSgNo = (Long)msgContext.getProperty("Sandesha2InboundMessageNumber");
            operationContext.setProperty("Sandesha2InboundMessageNumber", inboundMSgNo);
            outMessageContext.getOptions().setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
            outMessageContext.setProperty("Sandesha2InboundLastMessage", Boolean.TRUE);
            outMessageContext.setProperty("RequestResponseTransportControl", msgContext.getProperty("RequestResponseTransportControl"));
            AxisEngine engine2 = new AxisEngine(configurationContext);
            engine2.send(outMessageContext);
            TransportUtils.setResponseWritten(msgContext, true);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: LastMessageProcessor::processLastMessage");
        }
    }
}

