/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import org.apache.axiom.soap.SOAPBody;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.addressing.RelatesTo;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.wsrm.Accept;
import org.apache.sandesha2.wsrm.CreateSequenceResponse;

public class CreateSeqResponseMsgProcessor
implements MsgProcessor {
    private static final Log log = LogFactory.getLog(CreateSeqResponseMsgProcessor.class);

    public boolean processInMessage(RMMsgContext createSeqResponseRMMsgCtx, Transaction transaction) throws AxisFault {
        SandeshaPolicyBean policy;
        String internalSequenceId;
        if (log.isDebugEnabled()) {
            log.debug("Enter: CreateSeqResponseMsgProcessor::processInMessage");
        }
        ConfigurationContext configCtx = createSeqResponseRMMsgCtx.getMessageContext().getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx, configCtx.getAxisConfiguration());
        CreateSequenceResponse createSeqResponsePart = (CreateSequenceResponse)createSeqResponseRMMsgCtx.getMessagePart(10);
        if (createSeqResponsePart == null) {
            String message = SandeshaMessageHelper.getMessage("noCreateSeqResponse");
            log.debug(message);
            throw new SandeshaException(message);
        }
        String newOutSequenceId = createSeqResponsePart.getIdentifier().getIdentifier();
        if (newOutSequenceId == null) {
            String message = SandeshaMessageHelper.getMessage("newSeqIdIsNull");
            log.debug(message);
            throw new SandeshaException(message);
        }
        RelatesTo relatesTo = createSeqResponseRMMsgCtx.getMessageContext().getRelatesTo();
        String createSeqMsgId = null;
        if (relatesTo != null) {
            createSeqMsgId = relatesTo.getValue();
        } else {
            OperationContext context = createSeqResponseRMMsgCtx.getMessageContext().getOperationContext();
            MessageContext createSeq = context.getMessageContext("Out");
            if (createSeq != null) {
                createSeqMsgId = createSeq.getMessageID();
            }
        }
        if (createSeqMsgId == null) {
            String message = SandeshaMessageHelper.getMessage("relatesToNotAvailable");
            log.error(message);
            throw new SandeshaException(message);
        }
        SenderBeanMgr retransmitterMgr = storageManager.getSenderBeanMgr();
        RMSBeanMgr rmsBeanMgr = storageManager.getRMSBeanMgr();
        RMSBean rmsBean = rmsBeanMgr.retrieve(createSeqMsgId);
        if (rmsBean == null) {
            String message = SandeshaMessageHelper.getMessage("createSeqEntryNotFound");
            log.debug(message);
            throw new SandeshaException(message);
        }
        String tokenData = rmsBean.getSecurityTokenData();
        if (tokenData != null) {
            SecurityManager secManager = SandeshaUtil.getSecurityManager(configCtx);
            MessageContext crtSeqResponseCtx = createSeqResponseRMMsgCtx.getMessageContext();
            SOAPBody body = crtSeqResponseCtx.getEnvelope().getBody();
            SecurityToken token = secManager.recoverSecurityToken(tokenData);
            secManager.checkProofOfPossession(token, body, crtSeqResponseCtx);
        }
        if ((internalSequenceId = rmsBean.getInternalSequenceID()) == null || "".equals(internalSequenceId)) {
            String message = SandeshaMessageHelper.getMessage("tempSeqIdNotSet");
            log.debug(message);
            throw new SandeshaException(message);
        }
        createSeqResponseRMMsgCtx.setProperty("Sandesha2InternalSequenceId", internalSequenceId);
        if (rmsBean.getSequenceID() != null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: CreateSeqResponseMsgProcessor::processInMessage, sequence id is already set. Existing id:" + rmsBean.getSequenceID() + ", new id:" + newOutSequenceId);
            }
            return false;
        }
        rmsBean.setSequenceID(newOutSequenceId);
        if ("Spec_2007_02".equals(createSeqResponseRMMsgCtx.getRMSpecVersion()) && (policy = SandeshaUtil.getPropertyBean(configCtx.getAxisConfiguration())).isEnableMakeConnection()) {
            String acksTo = rmsBean.getAcksToEPR();
            EndpointReference reference = new EndpointReference(acksTo);
            if (acksTo == null || reference.hasAnonymousAddress()) {
                rmsBean.setPollingMode(true);
            }
        }
        SenderBean createSeqBean = retransmitterMgr.retrieve(createSeqMsgId);
        retransmitterMgr.delete(createSeqBean.getMessageID());
        storageManager.removeMessageContext(rmsBean.getCreateSequenceMsgStoreKey());
        Accept accept = createSeqResponsePart.getAccept();
        if (accept != null) {
            MessageContext createSequnceMessage;
            OperationContext operationContext;
            if (rmsBean.getOfferedSequence() == null) {
                String message = SandeshaMessageHelper.getMessage("accptButNoSequenceOffered");
                log.debug(message);
                throw new SandeshaException(message);
            }
            RMDBean rMDBean = new RMDBean();
            EndpointReference acksToEPR = accept.getAcksTo().getEPR();
            rMDBean.setAcksToEPR(acksToEPR.getAddress());
            rMDBean.setSequenceID(rmsBean.getOfferedSequence());
            rMDBean.setNextMsgNoToProcess(1L);
            rMDBean.setOutboundInternalSequence(rmsBean.getInternalSequenceID());
            String referenceMsgStoreKey = rmsBean.getReferenceMessageStoreKey();
            MessageContext referenceMsg = storageManager.retrieveMessageContext(referenceMsgStoreKey, configCtx);
            String newMessageStoreKey = SandeshaUtil.getUUID();
            storageManager.storeMessageContext(newMessageStoreKey, referenceMsg);
            rMDBean.setReferenceMessageKey(newMessageStoreKey);
            if ("Spec_2007_02".equals(createSeqResponseRMMsgCtx.getRMSpecVersion()) && rmsBean.isPollingMode()) {
                rMDBean.setPollingMode(true);
            }
            String rmSpecVersion = createSeqResponseRMMsgCtx.getRMSpecVersion();
            rMDBean.setRMVersion(rmSpecVersion);
            EndpointReference toEPR = createSeqResponseRMMsgCtx.getTo();
            if (toEPR == null && (operationContext = createSeqResponseRMMsgCtx.getMessageContext().getOperationContext()) != null && (createSequnceMessage = operationContext.getMessageContext("Out")) != null) {
                toEPR = createSequnceMessage.getReplyTo();
            }
            if (toEPR != null) {
                rMDBean.setToAddress(toEPR.getAddress());
            }
            rMDBean.setServerCompletedMessages(new RangeString());
            RMDBeanMgr rmdBeanMgr = storageManager.getRMDBeanMgr();
            rMDBean.setSecurityTokenData(rmsBean.getSecurityTokenData());
            rMDBean.setLastActivatedTime(System.currentTimeMillis());
            rmdBeanMgr.insert(rMDBean);
            SandeshaUtil.startWorkersForSequence(configCtx, rMDBean);
        }
        rmsBean.setLastActivatedTime(System.currentTimeMillis());
        rmsBeanMgr.update(rmsBean);
        SandeshaUtil.startWorkersForSequence(configCtx, rmsBean);
        SenderBean target = new SenderBean();
        target.setInternalSequenceID(internalSequenceId);
        target.setSend(false);
        for (SenderBean tempBean : retransmitterMgr.find(target)) {
            tempBean.setSend(true);
            tempBean.setSequenceID(newOutSequenceId);
            retransmitterMgr.update(tempBean);
        }
        createSeqResponseRMMsgCtx.pause();
        if (log.isDebugEnabled()) {
            log.debug("Exit: CreateSeqResponseMsgProcessor::processInMessage " + Boolean.TRUE);
        }
        return true;
    }

    public boolean processOutMessage(RMMsgContext rmMsgCtx, Transaction transaction) {
        if (log.isDebugEnabled()) {
            log.debug("Enter: CreateSeqResponseMsgProcessor::processOutMessage");
            log.debug("Exit: CreateSeqResponseMsgProcessor::processOutMessage " + Boolean.FALSE);
        }
        return false;
    }
}

