/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.Iterator;
import org.apache.axiom.om.OMElement;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.polling.PollingManager;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.TerminateManager;
import org.apache.sandesha2.wsrm.AcknowledgementRange;
import org.apache.sandesha2.wsrm.SequenceAcknowledgement;

public class AcknowledgementProcessor {
    private static final Log log = LogFactory.getLog(AcknowledgementProcessor.class);

    public void processAckHeaders(RMMsgContext message) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: AcknowledgementProcessor::processAckHeaders");
        }
        Iterator iter = message.getMessageParts(7);
        while (iter.hasNext()) {
            SequenceAcknowledgement sa = (SequenceAcknowledgement)iter.next();
            this.processAckHeader(message, sa.getOriginalSequenceAckElement(), sa);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: AcknowledgementProcessor::processAckHeaders");
        }
    }

    private void processAckHeader(RMMsgContext rmMsgCtx, OMElement soapHeader, SequenceAcknowledgement sequenceAck) throws AxisFault {
        PollingManager manager;
        RMDBeanMgr rMDBeanMgr;
        RMDBean rMDBean;
        if (log.isDebugEnabled()) {
            log.debug("Enter: AcknowledgementProcessor::processAckHeader " + soapHeader);
        }
        boolean piggybackedAck = rmMsgCtx.getMessageType() != 4;
        MessageContext msgCtx = rmMsgCtx.getMessageContext();
        ConfigurationContext configCtx = msgCtx.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx, configCtx.getAxisConfiguration());
        SenderBeanMgr retransmitterMgr = storageManager.getSenderBeanMgr();
        String outSequenceId = sequenceAck.getIdentifier().getIdentifier();
        if (outSequenceId == null || "".equals(outSequenceId)) {
            String message = SandeshaMessageHelper.getMessage("outSeqIDIsNull");
            log.debug(message);
            throw new SandeshaException(message);
        }
        RMSBean rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, outSequenceId);
        if (rmsBean == null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: AcknowledgementProcessor::processAckHeader, Sequence bean not found");
            }
            return;
        }
        if (FaultManager.checkForUnknownSequence(rmMsgCtx, outSequenceId, storageManager, piggybackedAck, rmsBean, null)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: AcknowledgementProcessor::processAckHeader, Unknown sequence");
            }
            return;
        }
        if (FaultManager.checkForSequenceTerminated(rmMsgCtx, outSequenceId, rmsBean, piggybackedAck)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: AcknowledgementProcessor::processAckHeader, Sequence terminated");
            }
            return;
        }
        String internalSequenceId = rmsBean.getInternalSequenceID();
        if (rmsBean.getSecurityTokenData() != null) {
            SecurityManager secManager = SandeshaUtil.getSecurityManager(configCtx);
            SecurityToken token = secManager.recoverSecurityToken(rmsBean.getSecurityTokenData());
            secManager.checkProofOfPossession(token, soapHeader, msgCtx);
        }
        if (log.isDebugEnabled()) {
            log.debug("Got Ack for RM Sequence: " + outSequenceId + ", internalSeqId: " + internalSequenceId);
        }
        Iterator ackRangeIterator = sequenceAck.getAcknowledgementRanges().iterator();
        if (FaultManager.checkForInvalidAcknowledgement(rmMsgCtx, sequenceAck, storageManager, rmsBean, piggybackedAck)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: AcknowledgementProcessor::processAckHeader, Invalid Ack range ");
            }
            return;
        }
        String replyToAddress = rmsBean.getReplyToEPR();
        EndpointReference replyTo = new EndpointReference(replyToAddress);
        boolean anonReplyTo = replyTo.hasAnonymousAddress();
        String rmVersion = rmMsgCtx.getRMSpecVersion();
        boolean isV1_0 = "Spec_2005_02".equals(rmVersion);
        RangeString completedMessages = rmsBean.getClientCompletedMessages();
        long numberOfNewMessagesAcked = 0L;
        while (ackRangeIterator.hasNext()) {
            long upper;
            AcknowledgementRange ackRange = (AcknowledgementRange)ackRangeIterator.next();
            long lower = ackRange.getLowerValue();
            Range ackedRange = new Range(lower, upper = ackRange.getUpperValue());
            if (completedMessages.isRangeCompleted(ackedRange)) continue;
            Range[] newRanges = completedMessages.addRange(ackedRange).getRanges();
            for (int rangeIndex = 0; rangeIndex < newRanges.length; ++rangeIndex) {
                for (long messageNo = newRanges[rangeIndex].lowerValue; messageNo <= newRanges[rangeIndex].upperValue; ++messageNo) {
                    MessageContext applicationMessage;
                    AxisOperation operation;
                    ++numberOfNewMessagesAcked;
                    SenderBean matcher = new SenderBean();
                    matcher.setSequenceID(outSequenceId);
                    matcher.setMessageNumber(messageNo);
                    SenderBean retransmitterBean = retransmitterMgr.findUnique(matcher);
                    if (retransmitterBean == null) continue;
                    if (retransmitterBean.getSentCount() == 0) {
                        FaultManager.makeInvalidAcknowledgementFault(rmMsgCtx, sequenceAck, ackRange, storageManager, piggybackedAck);
                        if (log.isDebugEnabled()) {
                            log.debug("Exit: AcknowledgementProcessor::processAckHeader, Invalid Ack");
                        }
                        return;
                    }
                    String storageKey = retransmitterBean.getMessageContextRefKey();
                    boolean syncResponseNeeded = false;
                    if (isV1_0 && anonReplyTo && (operation = (applicationMessage = storageManager.retrieveMessageContext(storageKey, configCtx)).getAxisOperation()) != null) {
                        int mep = operation.getAxisSpecifMEPConstant();
                        boolean bl = syncResponseNeeded = mep == 16;
                    }
                    if (syncResponseNeeded) continue;
                    retransmitterMgr.delete(retransmitterBean.getMessageID());
                    storageManager.removeMessageContext(storageKey);
                }
            }
        }
        rmsBean.setLastActivatedTime(System.currentTimeMillis());
        if (rmsBean.getOfferedSequence() != null && (rMDBean = (rMDBeanMgr = storageManager.getRMDBeanMgr()).retrieve(outSequenceId)) != null && rMDBean.isPollingMode() && (manager = storageManager.getPollingManager()) != null) {
            manager.schedulePollingRequest(rMDBean.getSequenceID(), false);
        }
        if (numberOfNewMessagesAcked > 0L) {
            rmsBean.setClientCompletedMessages(completedMessages);
        }
        storageManager.getRMSBeanMgr().update(rmsBean);
        TerminateManager.checkAndTerminate(rmMsgCtx, storageManager, rmsBean);
        if (log.isDebugEnabled()) {
            log.debug("Exit: AcknowledgementProcessor::processAckHeader");
        }
    }
}

