/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.msgprocessors;

import java.util.Iterator;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ContextFactory;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.engine.AxisEngine;
import org.apache.axis2.transport.TransportUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beanmanagers.SenderBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.SenderBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.RMMsgCreator;
import org.apache.sandesha2.util.SOAPAbstractFactory;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.util.WSRMMessageSender;
import org.apache.sandesha2.wsrm.AckRequested;

public class AckRequestedProcessor
extends WSRMMessageSender {
    private static final Log log = LogFactory.getLog(AckRequestedProcessor.class);

    public boolean processAckRequestedHeaders(RMMsgContext message) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: AckRequestedProcessor::processAckRequestHeaders");
        }
        boolean msgCtxPaused = false;
        Iterator ackRequests = message.getMessageParts(15);
        while (ackRequests.hasNext()) {
            AckRequested ackReq = (AckRequested)ackRequests.next();
            boolean paused = this.processAckRequestedHeader(message, ackReq.getOriginalAckRequestedElement(), ackReq);
            if (msgCtxPaused) continue;
            msgCtxPaused = paused;
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: AckRequestedProcessor::processAckRequestHeaders " + msgCtxPaused);
        }
        return msgCtxPaused;
    }

    public boolean processAckRequestedHeader(RMMsgContext rmMsgCtx, OMElement soapHeader, AckRequested ackRequested) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: AckRequestedProcessor::processAckRequestedHeader " + soapHeader);
        }
        boolean piggybackedAckRequest = rmMsgCtx.getMessageType() != 8;
        String sequenceId = ackRequested.getIdentifier().getIdentifier();
        MessageContext msgContext = rmMsgCtx.getMessageContext();
        ConfigurationContext configurationContext = msgContext.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceId);
        if (rmdBean != null && rmdBean.getSecurityTokenData() != null) {
            SecurityManager secManager = SandeshaUtil.getSecurityManager(configurationContext);
            SecurityToken token = secManager.recoverSecurityToken(rmdBean.getSecurityTokenData());
            secManager.checkProofOfPossession(token, soapHeader, msgContext);
        }
        if (FaultManager.checkForUnknownSequence(rmMsgCtx, sequenceId, storageManager, piggybackedAckRequest, null, rmdBean)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: AckRequestedProcessor::processAckRequestedHeader, Unknown sequence ");
            }
            return false;
        }
        if (rmdBean == null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: SequenceProcessor::processReliableMessage, could not find RMD");
            }
            return false;
        }
        if (FaultManager.checkForSequenceTerminated(rmMsgCtx, sequenceId, rmdBean, piggybackedAckRequest)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: AckRequestedProcessor::processAckRequestedHeader, Sequence terminated");
            }
            return false;
        }
        EndpointReference acksTo = new EndpointReference(rmdBean.getAcksToEPR());
        String acksToStr = acksTo.getAddress();
        if (acksToStr == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("acksToStrNotSet"));
        }
        AxisOperation ackOperation = SpecSpecificConstants.getWSRMOperation(4, rmdBean.getRMVersion(), msgContext.getAxisService());
        MessageContext ackMsgCtx = SandeshaUtil.createNewRelatedMessageContext(rmMsgCtx, ackOperation);
        ackMsgCtx.setProperty("Sandesha2AppProcessingDone", "true");
        RMMsgContext ackRMMsgCtx = MsgInitializer.initializeMessage(ackMsgCtx);
        ackRMMsgCtx.setRMNamespaceValue(rmMsgCtx.getRMNamespaceValue());
        ackMsgCtx.setMessageID(SandeshaUtil.getUUID());
        SOAPFactory factory = SOAPAbstractFactory.getSOAPFactory(SandeshaUtil.getSOAPVersion(msgContext.getEnvelope()));
        SOAPEnvelope envelope = factory.getDefaultEnvelope();
        try {
            ackMsgCtx.setEnvelope(envelope);
        }
        catch (AxisFault e3) {
            throw new SandeshaException(e3.getMessage());
        }
        ackMsgCtx.setTo(acksTo);
        ackMsgCtx.setReplyTo(msgContext.getTo());
        RMMsgCreator.addAckMessage(ackRMMsgCtx, sequenceId, rmdBean, true);
        ackRMMsgCtx.getMessageContext().setServerSide(true);
        if (acksTo.hasAnonymousAddress()) {
            AxisEngine engine2 = new AxisEngine(ackRMMsgCtx.getMessageContext().getConfigurationContext());
            if (rmMsgCtx.getMessageContext().getOperationContext() == null) {
                ServiceContext serviceCtx = msgContext.getServiceContext();
                OperationContext opCtx = ContextFactory.createOperationContext(ackOperation, serviceCtx);
                rmMsgCtx.getMessageContext().setOperationContext(opCtx);
            }
            try {
                engine2.send(ackRMMsgCtx.getMessageContext());
            }
            catch (AxisFault e1) {
                throw new SandeshaException(e1.getMessage());
            }
        } else {
            SenderBeanMgr senderBeanMgr = storageManager.getSenderBeanMgr();
            String key = SandeshaUtil.getUUID();
            SenderBean ackBean = new SenderBean();
            ackBean.setMessageContextRefKey(key);
            ackBean.setMessageID(ackMsgCtx.getMessageID());
            ackBean.setReSend(false);
            ackBean.setSequenceID(sequenceId);
            EndpointReference to = ackMsgCtx.getTo();
            if (to != null) {
                ackBean.setToAddress(to.getAddress());
            }
            ackBean.setSend(true);
            ackMsgCtx.setProperty("Sandesha2QualifiedForSending", "false");
            ackBean.setMessageType(4);
            SandeshaPolicyBean propertyBean = SandeshaUtil.getPropertyBean(msgContext.getAxisOperation());
            long ackInterval = propertyBean.getAcknowledgementInterval();
            long timeToSend = System.currentTimeMillis() + ackInterval;
            SenderBean findBean = new SenderBean();
            findBean.setMessageType(4);
            findBean.setSend(true);
            findBean.setReSend(false);
            List coll = senderBeanMgr.find(findBean);
            Iterator it = coll.iterator();
            if (it.hasNext()) {
                SenderBean oldAckBean = (SenderBean)it.next();
                timeToSend = oldAckBean.getTimeToSend();
                senderBeanMgr.delete(oldAckBean.getMessageID());
            }
            ackBean.setTimeToSend(timeToSend);
            msgContext.setProperty("Sandesha2QualifiedForSending", "false");
            SandeshaUtil.executeAndStore(ackRMMsgCtx, key, storageManager);
            senderBeanMgr.insert(ackBean);
            msgContext.pause();
            if (log.isDebugEnabled()) {
                log.debug("Exit: AckRequestedProcessor::processAckRequestedHeader " + Boolean.TRUE);
            }
            return true;
        }
        TransportUtils.setResponseWritten(rmMsgCtx.getMessageContext(), true);
        return false;
    }

    public boolean processOutgoingAckRequestMessage(RMMsgContext ackRequestRMMsg) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: AckRequestedProcessor::processOutgoingAckRequestMessage");
        }
        this.setupOutMessage(ackRequestRMMsg);
        AxisOperation ackOperation = SpecSpecificConstants.getWSRMOperation(4, this.getRMVersion(), this.getMsgContext().getAxisService());
        this.getMsgContext().setAxisOperation(ackOperation);
        ServiceContext serviceCtx = this.getMsgContext().getServiceContext();
        OperationContext opcontext = ContextFactory.createOperationContext(ackOperation, serviceCtx);
        opcontext.setParent(this.getMsgContext().getServiceContext());
        this.getConfigurationContext().registerOperationContext(ackRequestRMMsg.getMessageId(), opcontext);
        this.getMsgContext().setOperationContext(opcontext);
        Iterator iterator = ackRequestRMMsg.getMessageParts(15);
        AckRequested ackRequested = null;
        while (iterator.hasNext()) {
            ackRequested = (AckRequested)iterator.next();
        }
        if (iterator.hasNext()) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("ackRequestMultipleParts"));
        }
        if (ackRequested == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("noAckRequestPartFound"));
        }
        ackRequestRMMsg.setWSAAction(SpecSpecificConstants.getAckRequestAction(this.getRMVersion()));
        ackRequestRMMsg.setSOAPAction(SpecSpecificConstants.getAckRequestSOAPAction(this.getRMVersion()));
        this.sendOutgoingMessage(ackRequestRMMsg, 8, 0L);
        ackRequestRMMsg.pause();
        if (log.isDebugEnabled()) {
            log.debug("Exit: AckRequestedProcessor::processOutgoingAckRequestMessage " + Boolean.TRUE);
        }
        return true;
    }
}

