/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.handlers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.context.OperationContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.AckRequestedProcessor;
import org.apache.sandesha2.msgprocessors.ApplicationMsgProcessor;
import org.apache.sandesha2.msgprocessors.MsgProcessor;
import org.apache.sandesha2.msgprocessors.MsgProcessorFactory;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;

public class SandeshaOutHandler
extends AbstractHandler {
    private static final long serialVersionUID = 8261092322051924103L;
    private static final Log log = LogFactory.getLog(SandeshaOutHandler.class.getName());

    public Handler.InvocationResponse invoke(MessageContext msgCtx) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaOutHandler::invoke, " + msgCtx.getEnvelope().getHeader());
        }
        Handler.InvocationResponse returnValue = Handler.InvocationResponse.CONTINUE;
        ConfigurationContext context = msgCtx.getConfigurationContext();
        if (context == null) {
            String message = SandeshaMessageHelper.getMessage("configContextNotSet");
            log.debug(message);
            throw new AxisFault(message);
        }
        AxisService axisService = msgCtx.getAxisService();
        if (axisService == null) {
            String message = SandeshaMessageHelper.getMessage("axisServiceIsNull");
            log.debug(message);
            throw new AxisFault(message);
        }
        if (SandeshaUtil.isMessageUnreliable(msgCtx)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: SandeshaOutHandler::invoke, Skipping sandesha processing for unreliable message " + returnValue);
            }
            return returnValue;
        }
        if (msgCtx.isProcessingFault()) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: SandeshaOutHandler::invoke, Skipping sandesha processing for fault message " + returnValue);
            }
            return returnValue;
        }
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration());
        SandeshaUtil.modifyExecutionChainForStoring(msgCtx, storageManager);
        String DONE = (String)msgCtx.getProperty("Sandesha2AppProcessingDone");
        if (null != DONE && "true".equals(DONE)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: SandeshaOutHandler::invoke, Application processing done " + returnValue);
            }
            return returnValue;
        }
        msgCtx.setProperty("Sandesha2AppProcessingDone", "true");
        Transaction transaction = null;
        try {
            OperationContext opCtx;
            AckRequestedProcessor ackRequestedProcessor;
            transaction = storageManager.getTransaction();
            RMMsgContext rmMsgCtx = MsgInitializer.initializeMessage(msgCtx);
            MsgProcessor msgProcessor = null;
            int messageType = rmMsgCtx.getMessageType();
            if (log.isDebugEnabled()) {
                log.debug("Message Type: " + messageType);
            }
            if (messageType == 0) {
                if (msgCtx.isServerSide()) {
                    String inboundSequence = (String)msgCtx.getProperty("Sandesha2InboundSequenceId");
                    Long msgNum = (Long)msgCtx.getProperty("Sandesha2InboundMessageNumber");
                    if (inboundSequence != null && msgNum != null) {
                        msgProcessor = new ApplicationMsgProcessor(inboundSequence, msgNum);
                    }
                } else {
                    msgProcessor = new ApplicationMsgProcessor();
                }
            } else {
                msgProcessor = MsgProcessorFactory.getMessageProcessor(rmMsgCtx);
            }
            if (msgProcessor != null) {
                if (msgProcessor.processOutMessage(rmMsgCtx, transaction)) {
                    returnValue = Handler.InvocationResponse.SUSPEND;
                }
            } else if (messageType == 8 && (ackRequestedProcessor = new AckRequestedProcessor()).processOutgoingAckRequestMessage(rmMsgCtx)) {
                returnValue = Handler.InvocationResponse.SUSPEND;
            }
            if ((opCtx = msgCtx.getOperationContext()) != null && returnValue == Handler.InvocationResponse.SUSPEND) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting HOLD_RESPONSE property");
                }
                opCtx.setProperty("HoldResponse", Boolean.TRUE);
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (Exception e) {
            msgCtx.pause();
            returnValue = Handler.InvocationResponse.SUSPEND;
            String message = SandeshaMessageHelper.getMessage("outMsgError", e.toString());
            throw new AxisFault(message, e);
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                try {
                    transaction.rollback();
                }
                catch (Exception e1) {
                    String message = SandeshaMessageHelper.getMessage("rollbackError", e1.toString());
                    log.debug(message, e1);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaOutHandler::invoke " + returnValue);
        }
        return returnValue;
    }

    public String getName() {
        return "SandeshaOutHandler";
    }
}

