/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.handlers;

import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.MessageValidator;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.msgprocessors.AckRequestedProcessor;
import org.apache.sandesha2.msgprocessors.AcknowledgementProcessor;
import org.apache.sandesha2.msgprocessors.MessagePendingProcessor;
import org.apache.sandesha2.msgprocessors.SequenceProcessor;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.SandeshaUtil;

public class SandeshaInHandler
extends AbstractHandler {
    private static final long serialVersionUID = 733210926016820857L;
    private static final Log log = LogFactory.getLog(SandeshaInHandler.class.getName());

    public String getName() {
        return "SandeshaInHandler";
    }

    public Handler.InvocationResponse invoke(MessageContext msgCtx) throws AxisFault {
        Parameter unreliableParam;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaInHandler::invoke, " + msgCtx.getEnvelope().getHeader());
        }
        Handler.InvocationResponse returnValue = Handler.InvocationResponse.CONTINUE;
        ConfigurationContext context = msgCtx.getConfigurationContext();
        if (context == null) {
            String message = SandeshaMessageHelper.getMessage("configContextNotSet");
            log.debug(message);
            throw new AxisFault(message);
        }
        String DONE = (String)msgCtx.getProperty("Sandesha2AppProcessingDone");
        if (null != DONE && "true".equals(DONE)) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: SandeshaInHandler::invoke, Application processing done " + returnValue);
            }
            return returnValue;
        }
        if (msgCtx.getAxisService() != null && null != (unreliableParam = msgCtx.getAxisService().getParameter(SandeshaClientConstants.UNRELIABLE_MESSAGE)) && "true".equals(unreliableParam.getValue())) {
            log.debug("Exit: SandeshaInHandler::invoke, Service has disabled RM " + returnValue);
            return returnValue;
        }
        if (log.isDebugEnabled()) {
            log.debug("SandeshaInHandler::invoke Continuing beyond basic checks");
        }
        Transaction transaction = null;
        try {
            StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(context, context.getAxisConfiguration());
            transaction = storageManager.getTransaction();
            AxisService axisService = msgCtx.getAxisService();
            if (axisService == null) {
                String message = SandeshaMessageHelper.getMessage("axisServiceIsNull");
                log.debug(message);
                throw new AxisFault(message);
            }
            RMMsgContext rmMsgCtx = null;
            rmMsgCtx = msgCtx.getProperty("RMMessageContext") != null ? (RMMsgContext)msgCtx.getProperty("RMMessageContext") : MsgInitializer.initializeMessage(msgCtx);
            MessageValidator.validateMessage(rmMsgCtx, storageManager);
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = storageManager.getTransaction();
            AcknowledgementProcessor ackProcessor = new AcknowledgementProcessor();
            ackProcessor.processAckHeaders(rmMsgCtx);
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = storageManager.getTransaction();
            AckRequestedProcessor reqProcessor = new AckRequestedProcessor();
            if (reqProcessor.processAckRequestedHeaders(rmMsgCtx)) {
                returnValue = Handler.InvocationResponse.SUSPEND;
            }
            MessagePendingProcessor pendingProcessor = new MessagePendingProcessor();
            pendingProcessor.processMessagePendingHeaders(rmMsgCtx);
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = storageManager.getTransaction();
            SequenceProcessor seqProcessor = new SequenceProcessor();
            returnValue = seqProcessor.processSequenceHeader(rmMsgCtx, transaction);
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("SandeshaInHandler::invoke Exception caught during processInMessage", e);
            }
            msgCtx.pause();
            returnValue = Handler.InvocationResponse.SUSPEND;
            if (e instanceof AxisFault) {
                throw (AxisFault)e;
            }
            String message = SandeshaMessageHelper.getMessage("inMsgError", e.toString());
            throw new AxisFault(message, e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug("SandeshaInHandler::invoke Doing final processing");
            }
            if (transaction != null && transaction.isActive()) {
                try {
                    transaction.rollback();
                    transaction = null;
                }
                catch (Exception e1) {
                    String message = SandeshaMessageHelper.getMessage("rollbackError", e1.toString());
                    log.debug(message, e1);
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaInHandler::invoke " + returnValue);
        }
        return returnValue;
    }
}

