/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.handlers;

import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.Handler;
import org.apache.axis2.handlers.AbstractHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.security.SecurityToken;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMDBeanMgr;
import org.apache.sandesha2.storage.beans.InvokerBean;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.util.FaultManager;
import org.apache.sandesha2.util.MsgInitializer;
import org.apache.sandesha2.util.Range;
import org.apache.sandesha2.util.RangeString;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.wsrm.Sequence;

public class SandeshaGlobalInHandler
extends AbstractHandler {
    private static final long serialVersionUID = -7187928423123306156L;
    private static final Log log = LogFactory.getLog(SandeshaGlobalInHandler.class);

    public Handler.InvocationResponse invoke(MessageContext msgContext) throws AxisFault {
        SOAPEnvelope env;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaGlobalInHandler::invoke, " + msgContext.getEnvelope().getHeader());
        }
        if (msgContext.getAxisService() != null) {
            Parameter unreliableParam = msgContext.getAxisService().getParameter(SandeshaClientConstants.UNRELIABLE_MESSAGE);
            if (null != unreliableParam && "true".equals(unreliableParam.getValue())) {
                if (log.isDebugEnabled()) {
                    log.debug("Exit: SandeshaGlobalInHandler::invoke, Service has disabled RM " + Handler.InvocationResponse.CONTINUE);
                }
                return Handler.InvocationResponse.CONTINUE;
            }
        } else if (msgContext.getConfigurationContext().getAxisConfiguration().getParameter("Sandesha2PropertyBean") == null) {
            if (log.isDebugEnabled()) {
                log.debug("Exit: SandeshaGlobalInHandler::invoke, No Property Bean found " + Handler.InvocationResponse.CONTINUE);
            }
            return Handler.InvocationResponse.CONTINUE;
        }
        String soapAction = msgContext.getSoapAction();
        String wsaAction = msgContext.getWSAAction();
        if (soapAction == null && wsaAction == null && (env = msgContext.getEnvelope()) != null) {
            SOAPBody body;
            boolean lastMessageHeader = false;
            try {
                SOAPHeader header = env.getHeader();
                if (header != null) {
                    Sequence sequence = new Sequence("http://schemas.xmlsoap.org/ws/2005/02/rm");
                    sequence.fromOMElement(header);
                    if (sequence.getLastMessage() != null) {
                        lastMessageHeader = true;
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (lastMessageHeader && (body = env.getBody()) != null && body.getFirstElement() == null) {
                if (log.isDebugEnabled()) {
                    log.debug("Setting SOAP Action for a WSRM 1.0 last message");
                }
                msgContext.setSoapAction("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
            }
        }
        RMMsgContext rmMsgCtx = MsgInitializer.initializeMessage(msgContext);
        msgContext.setProperty("RMMessageContext", rmMsgCtx);
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(rmMsgCtx.getConfigurationContext(), rmMsgCtx.getConfigurationContext().getAxisConfiguration());
        Handler.InvocationResponse response = FaultManager.processMessagesForFaults(rmMsgCtx, storageManager);
        if (rmMsgCtx.getMessageType() == 3 || rmMsgCtx.getMessageType() == 12) {
            SandeshaGlobalInHandler.processApplicationMessage(rmMsgCtx);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaGlobalInHandler::invoke " + response);
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processApplicationMessage(RMMsgContext rmMsgCtx) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaGlobalInHandler::processApplicationMessage");
        }
        Sequence sequence = (Sequence)rmMsgCtx.getMessagePart(6);
        String sequenceId = sequence.getIdentifier().getIdentifier();
        long msgNo = sequence.getMessageNumber().getMessageNumber();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(rmMsgCtx.getConfigurationContext(), rmMsgCtx.getConfigurationContext().getAxisConfiguration());
        Transaction transaction = null;
        try {
            transaction = storageManager.getTransaction();
            RMDBeanMgr mgr = storageManager.getRMDBeanMgr();
            RMDBean bean = mgr.retrieve(sequenceId);
            if (bean != null && bean.getSecurityTokenData() != null) {
                SecurityManager secManager = SandeshaUtil.getSecurityManager(rmMsgCtx.getConfigurationContext());
                QName seqName = new QName(rmMsgCtx.getRMNamespaceValue(), "Sequence");
                SOAPEnvelope envelope = rmMsgCtx.getSOAPEnvelope();
                SOAPBody body = envelope.getBody();
                OMElement seqHeader = envelope.getHeader().getFirstChildWithName(seqName);
                SecurityToken token = secManager.recoverSecurityToken(bean.getSecurityTokenData());
                secManager.checkProofOfPossession(token, seqHeader, rmMsgCtx.getMessageContext());
                secManager.checkProofOfPossession(token, body, rmMsgCtx.getMessageContext());
            }
            if (bean != null) {
                if (msgNo == 0L) {
                    String message = SandeshaMessageHelper.getMessage("invalidMsgNumber", Long.toString(msgNo));
                    log.debug(message);
                    throw new SandeshaException(message);
                }
                RangeString serverCompletedMessageRanges = bean.getServerCompletedMessages();
                boolean msgNoPresentInList = serverCompletedMessageRanges.isMessageNumberInRanges(msgNo);
                if (!msgNoPresentInList) {
                    serverCompletedMessageRanges.addRange(new Range(msgNo));
                    storageManager.getRMDBeanMgr().update(bean);
                } else {
                    if (log.isDebugEnabled()) {
                        log.debug("Detected possible duplicate on message sequence " + sequenceId + ", msgNo " + msgNo);
                    }
                    boolean isDuplicate = true;
                    if (SandeshaUtil.isInOrder(rmMsgCtx.getMessageContext())) {
                        InvokerBean finderBean = new InvokerBean();
                        finderBean.setMsgNo(msgNo);
                        finderBean.setSequenceID(sequenceId);
                        List invokerBeanList = storageManager.getInvokerBeanMgr().find(finderBean);
                        if ((invokerBeanList == null || invokerBeanList.size() == 0) && bean.getNextMsgNoToProcess() <= msgNo) {
                            isDuplicate = false;
                            if (log.isDebugEnabled()) {
                                log.debug("Allowing completed message on sequence " + sequenceId + ", msgNo " + msgNo);
                            }
                        }
                    }
                    if (isDuplicate) {
                        if (log.isDebugEnabled()) {
                            log.debug("Detected definate duplicate message on sequence " + sequenceId + ", msgNo " + msgNo);
                        }
                        SandeshaGlobalInHandler.setupDuplicateOperation(rmMsgCtx);
                    }
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug("Detected definate duplicate message sequence " + sequenceId + ", msgNo " + msgNo);
                }
                SandeshaGlobalInHandler.setupDuplicateOperation(rmMsgCtx);
            }
            if (transaction != null && transaction.isActive()) {
                transaction.commit();
            }
            transaction = null;
        }
        finally {
            if (transaction != null && transaction.isActive()) {
                transaction.rollback();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaGlobalInHandler::processApplicationMessage");
        }
    }

    private static void setupDuplicateOperation(RMMsgContext rmMsgCtx) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaGlobalInHandler::setupDuplicateOperation");
        }
        MessageContext ctx = rmMsgCtx.getMessageContext();
        AxisOperation duplicateMessageOperation = null;
        int mep = 10;
        AxisOperation userOp = ctx.getAxisOperation();
        if (userOp != null) {
            mep = userOp.getAxisSpecifMEPConstant();
        }
        duplicateMessageOperation = 10 == mep ? SpecSpecificConstants.getWSRMOperation(13, "Spec_2005_02", rmMsgCtx.getMessageContext().getAxisService()) : SpecSpecificConstants.getWSRMOperation(14, "Spec_2005_02", rmMsgCtx.getMessageContext().getAxisService());
        ctx.setRelationships(null);
        ctx.setAxisOperation(duplicateMessageOperation);
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaGlobalInHandler::setupDuplicateOperation");
        }
    }
}

