/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.MissingResourceException;
import javax.xml.namespace.QName;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.llom.factory.OMLinkedListImplFactory;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.impl.llom.soap11.SOAP11Factory;
import org.apache.axiom.soap.impl.llom.soap12.SOAP12Factory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.ServiceContext;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisOperationFactory;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.TransportOutDescription;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.sandesha2.Sandesha2Constants;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.apache.sandesha2.client.SandeshaReport;
import org.apache.sandesha2.client.SequenceReport;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.Transaction;
import org.apache.sandesha2.storage.beanmanagers.RMSBeanMgr;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;
import org.apache.sandesha2.workers.Invoker;
import org.apache.sandesha2.wsrm.AckRequested;
import org.apache.sandesha2.wsrm.CloseSequence;
import org.apache.sandesha2.wsrm.Identifier;
import org.apache.sandesha2.wsrm.TerminateSequence;

public class SandeshaClient {
    private static final Log log = LogFactory.getLog(SandeshaClient.class);

    public static SequenceReport getOutgoingSequenceReport(ServiceClient serviceClient) throws SandeshaException {
        ServiceContext serviceContext = serviceClient.getServiceContext();
        if (serviceContext == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("serviceContextNotSet"));
        }
        ConfigurationContext configurationContext = serviceContext.getConfigurationContext();
        String internalSequenceID = SandeshaClient.getInternalSequenceIdFromServiceClient(serviceClient);
        return SandeshaClient.getOutgoingSequenceReport(internalSequenceID, configurationContext);
    }

    public static SequenceReport getOutgoingSequenceReport(String to, String sequenceKey, ConfigurationContext configurationContext) throws SandeshaException {
        String internalSequenceID = SandeshaUtil.getInternalSequenceID(to, sequenceKey);
        return SandeshaClient.getOutgoingSequenceReport(internalSequenceID, configurationContext);
    }

    public static SequenceReport getOutgoingSequenceReport(String internalSequenceID, ConfigurationContext configurationContext) throws SandeshaException {
        return SandeshaClient.getOutgoingSequenceReport(internalSequenceID, configurationContext, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SequenceReport getOutgoingSequenceReport(String internalSequenceID, ConfigurationContext configurationContext, boolean createTransaction) throws SandeshaException {
        SequenceReport sequenceReport = new SequenceReport();
        sequenceReport.setSequenceDirection((byte)2);
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        RMSBeanMgr createSeqMgr = storageManager.getRMSBeanMgr();
        Transaction reportTransaction = null;
        try {
            if (createTransaction) {
                reportTransaction = storageManager.getTransaction();
            }
            sequenceReport.setInternalSequenceID(internalSequenceID);
            RMSBean createSeqFindBean = new RMSBean();
            createSeqFindBean.setInternalSequenceID(internalSequenceID);
            RMSBean rMSBean = createSeqMgr.findUnique(createSeqFindBean);
            if (rMSBean != null && rMSBean.isTerminated()) {
                sequenceReport.setSequenceStatus((byte)3);
                SandeshaClient.fillOutgoingSequenceInfo(sequenceReport, rMSBean, storageManager);
                SequenceReport sequenceReport2 = sequenceReport;
                return sequenceReport2;
            }
            if (rMSBean != null && rMSBean.isTimedOut()) {
                sequenceReport.setSequenceStatus((byte)4);
                SandeshaClient.fillOutgoingSequenceInfo(sequenceReport, rMSBean, storageManager);
                SequenceReport sequenceReport3 = sequenceReport;
                return sequenceReport3;
            }
            if (rMSBean == null) {
                sequenceReport.setSequenceStatus((byte)1);
                SequenceReport sequenceReport4 = sequenceReport;
                return sequenceReport4;
            }
            String outSequenceID = rMSBean.getSequenceID();
            if (outSequenceID == null) {
                sequenceReport.setInternalSequenceID(internalSequenceID);
                sequenceReport.setSequenceStatus((byte)1);
                sequenceReport.setSequenceDirection((byte)2);
                if (rMSBean.getSecurityTokenData() != null) {
                    sequenceReport.setSecureSequence(true);
                }
                SequenceReport sequenceReport5 = sequenceReport;
                return sequenceReport5;
            }
            sequenceReport.setSequenceStatus((byte)2);
            SandeshaClient.fillOutgoingSequenceInfo(sequenceReport, rMSBean, storageManager);
            if (reportTransaction != null && reportTransaction.isActive()) {
                reportTransaction.commit();
            }
            reportTransaction = null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception", e);
            }
        }
        finally {
            if (reportTransaction != null && reportTransaction.isActive()) {
                reportTransaction.rollback();
            }
        }
        return sequenceReport;
    }

    private static void fillOutgoingSequenceInfo(SequenceReport report, RMSBean rmsBean, StorageManager storageManager) {
        report.setSequenceID(rmsBean.getSequenceID());
        List completedMessageList = rmsBean.getClientCompletedMessages().getContainedElementsAsNumbersList();
        Iterator iter = completedMessageList.iterator();
        while (iter.hasNext()) {
            report.addCompletedMessage((Long)iter.next());
        }
        if (rmsBean.getSecurityTokenData() != null) {
            report.setSecureSequence(true);
        }
    }

    public static ArrayList getIncomingSequenceReports(ConfigurationContext configCtx) throws SandeshaException {
        SandeshaReport report = SandeshaClient.getSandeshaReport(configCtx);
        ArrayList incomingSequenceIDs = report.getIncomingSequenceList();
        Iterator incomingSequenceIDIter = incomingSequenceIDs.iterator();
        ArrayList<SequenceReport> incomingSequenceReports = new ArrayList<SequenceReport>();
        while (incomingSequenceIDIter.hasNext()) {
            String sequenceID = (String)incomingSequenceIDIter.next();
            SequenceReport incomingSequenceReport = SandeshaClient.getIncomingSequenceReport(sequenceID, configCtx);
            if (incomingSequenceReport == null) {
                throw new SandeshaException(SandeshaMessageHelper.getMessage("incommingSequenceReportNotFound", sequenceID));
            }
            incomingSequenceReports.add(incomingSequenceReport);
        }
        return incomingSequenceReports;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SandeshaReport getSandeshaReport(ConfigurationContext configurationContext) throws SandeshaException {
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        SandeshaReport sandeshaReport = new SandeshaReport();
        Transaction reportTransaction = null;
        try {
            reportTransaction = storageManager.getTransaction();
            List rmsBeans = storageManager.getRMSBeanMgr().find(null);
            for (RMSBean bean : rmsBeans) {
                String sequenceID = bean.getSequenceID();
                sandeshaReport.addToOutgoingSequenceList(sequenceID);
                sandeshaReport.addToOutgoingInternalSequenceMap(sequenceID, bean.getInternalSequenceID());
                SequenceReport report = SandeshaClient.getOutgoingSequenceReport(bean.getInternalSequenceID(), configurationContext);
                sandeshaReport.addToNoOfCompletedMessagesMap(sequenceID, report.getCompletedMessages().size());
                sandeshaReport.addToSequenceStatusMap(sequenceID, report.getSequenceStatus());
            }
            List rmdBeans = storageManager.getRMDBeanMgr().find(null);
            for (RMDBean serverCompletedMsgsBean : rmdBeans) {
                String sequenceID = serverCompletedMsgsBean.getSequenceID();
                sandeshaReport.addToIncomingSequenceList(sequenceID);
                SequenceReport sequenceReport = SandeshaClient.getIncomingSequenceReport(sequenceID, configurationContext);
                sandeshaReport.addToNoOfCompletedMessagesMap(sequenceID, sequenceReport.getCompletedMessages().size());
                sandeshaReport.addToSequenceStatusMap(sequenceID, sequenceReport.getSequenceStatus());
            }
            if (reportTransaction != null && reportTransaction.isActive()) {
                reportTransaction.commit();
            }
            reportTransaction = null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception", e);
            }
        }
        finally {
            if (reportTransaction != null && reportTransaction.isActive()) {
                reportTransaction.rollback();
            }
        }
        return sandeshaReport;
    }

    public static void createSequence(ServiceClient serviceClient, boolean offer, String sequenceKey) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaClient::createSequence , " + offer + ", " + sequenceKey);
        }
        SandeshaClient.setUpServiceClientAnonymousOperations(serviceClient);
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        EndpointReference toEPR = serviceClient.getOptions().getTo();
        if (toEPR == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("toEPRNotValid", null));
        }
        String to = toEPR.getAddress();
        if (to == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("toEPRNotValid", null));
        }
        if (offer) {
            String offeredSequenceID = SandeshaUtil.getUUID();
            options.setProperty(SandeshaClientConstants.OFFERED_SEQUENCE_ID, offeredSequenceID);
        }
        String oldSequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, sequenceKey);
        String rmSpecVersion = (String)options.getProperty(SandeshaClientConstants.RM_SPEC_VERSION);
        if (rmSpecVersion == null) {
            rmSpecVersion = SpecSpecificConstants.getDefaultSpecVersion();
        }
        options.setProperty(SandeshaClientConstants.DUMMY_MESSAGE, "true");
        String oldAction = options.getAction();
        options.setAction(SpecSpecificConstants.getCreateSequenceAction(rmSpecVersion));
        ServiceContext serviceContext = serviceClient.getServiceContext();
        if (serviceContext == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("serviceContextNotSet"));
        }
        ConfigurationContext configurationContext = serviceContext.getConfigurationContext();
        SandeshaClient.cleanupTerminatedSequence(to, oldSequenceKey, SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration()));
        boolean resetReply = false;
        if (options.isUseSeparateListener() && options.getReplyTo() == null) {
            try {
                EndpointReference replyTo;
                int index;
                QName name;
                if (log.isDebugEnabled()) {
                    log.debug("Creating replyTo EPR");
                }
                TransportOutDescription senderTransport = options.getTransportOut();
                String transportName = null;
                if (senderTransport != null && (name = senderTransport.getName()) != null) {
                    transportName = name.getLocalPart();
                }
                if (transportName == null && (index = to.indexOf(58)) > 0) {
                    transportName = to.substring(0, index);
                }
                if ((replyTo = serviceContext.getMyEPR(transportName)) != null) {
                    options.setReplyTo(replyTo);
                    resetReply = true;
                }
                if (log.isDebugEnabled()) {
                    log.debug("Created replyTo EPR: " + replyTo);
                }
            }
            catch (AxisFault e) {
                if (log.isDebugEnabled()) {
                    log.debug("Caught exception", e);
                }
                throw new SandeshaException(e);
            }
        }
        try {
            serviceClient.fireAndForget(null);
        }
        catch (AxisFault e) {
            throw new SandeshaException(e);
        }
        finally {
            options.setAction(oldAction);
            if (resetReply) {
                options.setReplyTo(null);
            }
            options.setProperty(SandeshaClientConstants.DUMMY_MESSAGE, "false");
            options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, oldSequenceKey);
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaClient::createSequence");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void cleanupTerminatedSequence(String to, String sequenceKey, StorageManager storageManager) throws SandeshaException {
        String internalSequenceId = SandeshaUtil.getInternalSequenceID(to, sequenceKey);
        if (log.isTraceEnabled()) {
            log.trace("Checking if sequence " + internalSequenceId + " previously terminated");
        }
        Transaction tran = null;
        try {
            tran = storageManager.getTransaction();
            RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
            boolean terminatedSequence = false;
            if (rmsBean != null && rmsBean.isTerminated()) {
                terminatedSequence = true;
            }
            if (rmsBean != null && rmsBean.isTimedOut()) {
                terminatedSequence = true;
            }
            if (terminatedSequence) {
                storageManager.getRMSBeanMgr().delete(rmsBean.getCreateSeqMsgID());
            }
            if (tran != null && tran.isActive()) {
                tran.commit();
            }
            tran = null;
        }
        finally {
            if (tran != null && tran.isActive()) {
                tran.rollback();
            }
        }
    }

    public static String createSequence(ServiceClient serviceClient, boolean offer) throws SandeshaException {
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        String newSequenceKey = SandeshaUtil.getUUID();
        SandeshaClient.createSequence(serviceClient, offer, newSequenceKey);
        return newSequenceKey;
    }

    public static void createSequnce(ServiceClient serviceClient, boolean offer, String sequenceKey) throws SandeshaException {
        SandeshaClient.createSequence(serviceClient, offer, sequenceKey);
    }

    public static void terminateSequence(ServiceClient serviceClient) throws SandeshaException {
        SandeshaClient.setUpServiceClientAnonymousOperations(serviceClient);
        ServiceContext serviceContext = serviceClient.getServiceContext();
        if (serviceContext == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("serviceContextNotSet"));
        }
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        String rmSpecVersion = (String)options.getProperty(SandeshaClientConstants.RM_SPEC_VERSION);
        if (rmSpecVersion == null) {
            rmSpecVersion = SpecSpecificConstants.getDefaultSpecVersion();
        }
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmSpecVersion);
        String oldAction = options.getAction();
        try {
            if ("Spec_2007_02".equals(rmSpecVersion)) {
                SOAPEnvelope terminateEnvelope = SandeshaClient.configureTerminateSequence(options, serviceContext.getConfigurationContext());
                OMElement terminateBody = terminateEnvelope.getBody().getFirstChildWithName(new QName(rmNamespaceValue, "TerminateSequence"));
                serviceClient.fireAndForget(terminateBody);
            } else {
                options.setAction("http://schemas.xmlsoap.org/ws/2005/02/rm/LastMessage");
                options.setProperty(SandeshaClientConstants.LAST_MESSAGE, "true");
                serviceClient.fireAndForget(null);
            }
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("couldNotSendTerminate", e.toString());
            throw new SandeshaException(message, e);
        }
        finally {
            options.setAction(oldAction);
        }
    }

    public static void terminateSequence(ServiceClient serviceClient, String sequenceKey) throws SandeshaException {
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        String oldSequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, sequenceKey);
        SandeshaClient.terminateSequence(serviceClient);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, oldSequenceKey);
    }

    public static void closeSequence(ServiceClient serviceClient) throws SandeshaException {
        SandeshaClient.setUpServiceClientAnonymousOperations(serviceClient);
        ServiceContext serviceContext = serviceClient.getServiceContext();
        if (serviceContext == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("serviceContextNotSet"));
        }
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        String rmSpecVersion = (String)options.getProperty(SandeshaClientConstants.RM_SPEC_VERSION);
        if (rmSpecVersion == null) {
            rmSpecVersion = SpecSpecificConstants.getDefaultSpecVersion();
        }
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmSpecVersion);
        SOAPEnvelope closeSequnceEnvelope = SandeshaClient.configureCloseSequence(options, serviceContext.getConfigurationContext());
        OMElement closeSequenceBody = closeSequnceEnvelope.getBody().getFirstChildWithName(new QName(rmNamespaceValue, "CloseSequence"));
        String oldAction = options.getAction();
        options.setAction(SpecSpecificConstants.getCloseSequenceAction(rmSpecVersion));
        try {
            serviceClient.fireAndForget(closeSequenceBody);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("couldNotSendClose", e.toString());
            throw new SandeshaException(message, e);
        }
        finally {
            options.setAction(oldAction);
        }
    }

    public static void closeSequence(ServiceClient serviceClient, String sequenceKey) throws SandeshaException {
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("serviceContextNotSet"));
        }
        String specVersion = (String)options.getProperty(SandeshaClientConstants.RM_SPEC_VERSION);
        if (!"Spec_2007_02".equals(specVersion)) {
            String message = SandeshaMessageHelper.getMessage("closeSequenceSpecLevel", specVersion);
            throw new SandeshaException(message);
        }
        String oldSequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, sequenceKey);
        SandeshaClient.closeSequence(serviceClient);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, oldSequenceKey);
    }

    public static void waitUntilSequenceCompleted(ServiceClient serviceClient) throws SandeshaException {
        SandeshaClient.waitUntilSequenceCompleted(serviceClient, -1L);
    }

    public static void waitUntilSequenceCompleted(ServiceClient serviceClient, String sequenceKey) throws SandeshaException {
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        String oldSequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, sequenceKey);
        SandeshaClient.waitUntilSequenceCompleted(serviceClient);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, oldSequenceKey);
    }

    public static void waitUntilSequenceCompleted(ServiceClient serviceClient, long maxWaitingTime) throws SandeshaException {
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaClient::waitUntilSequenceCompleted , " + maxWaitingTime);
        }
        long startTime = System.currentTimeMillis();
        SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport(serviceClient);
        if (sequenceReport == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotFindReportForGivenData", serviceClient.toString()));
        }
        boolean done = false;
        while (!done) {
            sequenceReport = SandeshaClient.getOutgoingSequenceReport(serviceClient);
            byte status = sequenceReport.getSequenceStatus();
            if (status == 3) {
                done = true;
            }
            if (status == 4) {
                done = true;
            }
            if (done) continue;
            long timeNow = System.currentTimeMillis();
            if (timeNow > startTime + maxWaitingTime && maxWaitingTime != -1L) {
                done = true;
                continue;
            }
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {}
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaClient::waitUntilSequenceCompleted , " + maxWaitingTime);
        }
    }

    public static void waitUntilSequenceCompleted(ServiceClient serviceClient, long maxWaitingTime, String sequenceKey) throws SandeshaException {
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        String oldSequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, sequenceKey);
        SandeshaClient.waitUntilSequenceCompleted(serviceClient, maxWaitingTime);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, oldSequenceKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getSequenceID(ServiceClient serviceClient) throws SandeshaException {
        String internalSequenceID = SandeshaClient.getInternalSequenceIdFromServiceClient(serviceClient);
        ServiceContext serviceContext = serviceClient.getServiceContext();
        if (serviceContext == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("serviceContextNotSet"));
        }
        ConfigurationContext configurationContext = serviceContext.getConfigurationContext();
        SequenceReport sequenceReport = SandeshaClient.getOutgoingSequenceReport(serviceClient);
        if (sequenceReport == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotFindReportForGivenData", serviceClient.toString()));
        }
        if (sequenceReport.getSequenceStatus() != 2) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("noSequenceEstablished", internalSequenceID));
        }
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        Transaction transaction = null;
        String sequenceID = null;
        try {
            transaction = storageManager.getTransaction();
            sequenceID = SandeshaUtil.getSequenceIDFromInternalSequenceID(internalSequenceID, storageManager);
        }
        finally {
            if (transaction != null) {
                transaction.commit();
            }
        }
        if (sequenceID == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("sequenceIdBeanNotSet"));
        }
        return sequenceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SOAPEnvelope configureAckRequest(Options options, ConfigurationContext configurationContext) throws SandeshaException, MissingResourceException {
        String rmSpecVersion;
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        EndpointReference epr = options.getTo();
        if (epr == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("toEPRNotValid", null));
        }
        String internalSequenceID = (String)options.getProperty(SandeshaClientConstants.INTERNAL_SEQUENCE_ID);
        if (internalSequenceID == null) {
            String to = epr.getAddress();
            String sequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
            internalSequenceID = SandeshaUtil.getInternalSequenceID(to, sequenceKey);
        }
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        Transaction transaction = null;
        String sequenceID = null;
        try {
            transaction = storageManager.getTransaction();
            sequenceID = SandeshaUtil.getSequenceIDFromInternalSequenceID(internalSequenceID, storageManager);
        }
        finally {
            if (transaction != null) {
                transaction.commit();
            }
        }
        if (sequenceID == null) {
            sequenceID = "uuid:tempID";
        }
        if ((rmSpecVersion = (String)options.getProperty(SandeshaClientConstants.RM_SPEC_VERSION)) == null) {
            rmSpecVersion = SpecSpecificConstants.getDefaultSpecVersion();
        }
        options.setAction(SpecSpecificConstants.getAckRequestAction(rmSpecVersion));
        String soapNamespaceURI = options.getSoapVersionURI();
        if (soapNamespaceURI == null) {
            soapNamespaceURI = SandeshaClient.getSOAPNamespaceURI(storageManager, internalSequenceID);
        }
        OMLinkedListImplFactory factory = null;
        SOAPEnvelope dummyEnvelope = null;
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespaceURI)) {
            factory = new SOAP12Factory();
            dummyEnvelope = factory.getDefaultEnvelope();
        } else {
            factory = new SOAP11Factory();
            dummyEnvelope = factory.getDefaultEnvelope();
        }
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmSpecVersion);
        AckRequested ackRequested = new AckRequested(rmNamespaceValue);
        Identifier identifier = new Identifier(rmNamespaceValue);
        identifier.setIndentifer(sequenceID);
        ackRequested.setIdentifier(identifier);
        ackRequested.toSOAPEnvelope(dummyEnvelope);
        return dummyEnvelope;
    }

    public static void sendAckRequest(ServiceClient serviceClient) throws SandeshaException {
        SandeshaClient.setUpServiceClientAnonymousOperations(serviceClient);
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        ServiceContext serviceContext = serviceClient.getServiceContext();
        if (serviceContext == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("serviceContextNotSet"));
        }
        ConfigurationContext configContext = serviceContext.getConfigurationContext();
        String rmSpecVersion = (String)options.getProperty(SandeshaClientConstants.RM_SPEC_VERSION);
        if (rmSpecVersion == null) {
            rmSpecVersion = "Spec_2005_02";
        }
        if ("Spec_2005_02".equals(rmSpecVersion)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("emptyAckRequestSpecLevel", rmSpecVersion));
        }
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmSpecVersion);
        SOAPEnvelope dummyEnvelope = SandeshaClient.configureAckRequest(options, configContext);
        OMElement ackRequestedHeaderBlock = dummyEnvelope.getHeader().getFirstChildWithName(new QName(rmNamespaceValue, "AckRequested"));
        String oldAction = options.getAction();
        serviceClient.addHeader(ackRequestedHeaderBlock);
        try {
            serviceClient.fireAndForget(null);
        }
        catch (AxisFault e) {
            String message = SandeshaMessageHelper.getMessage("cannotSendAckRequestException", e.toString());
            throw new SandeshaException(message, e);
        }
        serviceClient.removeHeaders();
        options.setAction(oldAction);
    }

    public static void sendAckRequest(ServiceClient serviceClient, String sequenceKey) throws SandeshaException {
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        String oldSequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, sequenceKey);
        SandeshaClient.sendAckRequest(serviceClient);
        options.setProperty(SandeshaClientConstants.SEQUENCE_KEY, oldSequenceKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void forceDispatchOfInboundMessages(ConfigurationContext configContext, String sequenceID, boolean allowLaterDeliveryOfMissingMessages) throws SandeshaException {
        Transaction reportTransaction = null;
        try {
            StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configContext, configContext.getAxisConfiguration());
            reportTransaction = storageManager.getTransaction();
            Invoker.forceInvokeOfAllMessagesCurrentlyOnSequence(configContext, sequenceID, allowLaterDeliveryOfMissingMessages);
            if (reportTransaction != null && reportTransaction.isActive()) {
                reportTransaction.commit();
            }
            reportTransaction = null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception", e);
            }
        }
        finally {
            if (reportTransaction != null && reportTransaction.isActive()) {
                reportTransaction.rollback();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SOAPEnvelope configureCloseSequence(Options options, ConfigurationContext configurationContext) throws SandeshaException {
        String rmSpecVersion;
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        EndpointReference epr = options.getTo();
        if (epr == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("toEPRNotValid", null));
        }
        String internalSequenceID = (String)options.getProperty(SandeshaClientConstants.INTERNAL_SEQUENCE_ID);
        if (internalSequenceID == null) {
            String to = epr.getAddress();
            String sequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
            internalSequenceID = SandeshaUtil.getInternalSequenceID(to, sequenceKey);
        }
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        Transaction transaction = null;
        String sequenceID = null;
        try {
            transaction = storageManager.getTransaction();
            sequenceID = SandeshaUtil.getSequenceIDFromInternalSequenceID(internalSequenceID, storageManager);
        }
        finally {
            if (transaction != null) {
                transaction.commit();
            }
        }
        if (sequenceID == null) {
            sequenceID = "uuid:tempID";
        }
        if ((rmSpecVersion = (String)options.getProperty(SandeshaClientConstants.RM_SPEC_VERSION)) == null) {
            rmSpecVersion = SpecSpecificConstants.getDefaultSpecVersion();
        }
        if (!SpecSpecificConstants.isSequenceClosingAllowed(rmSpecVersion)) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("closeSequenceSpecLevel", rmSpecVersion));
        }
        SOAPEnvelope dummyEnvelope = null;
        OMLinkedListImplFactory factory = null;
        String soapNamespaceURI = options.getSoapVersionURI();
        if (soapNamespaceURI == null) {
            soapNamespaceURI = SandeshaClient.getSOAPNamespaceURI(storageManager, internalSequenceID);
        }
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespaceURI)) {
            factory = new SOAP12Factory();
            dummyEnvelope = factory.getDefaultEnvelope();
        } else {
            factory = new SOAP11Factory();
            dummyEnvelope = factory.getDefaultEnvelope();
        }
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmSpecVersion);
        CloseSequence closeSequence = new CloseSequence(rmNamespaceValue);
        Identifier identifier = new Identifier(rmNamespaceValue);
        identifier.setIndentifer(sequenceID);
        closeSequence.setIdentifier(identifier);
        closeSequence.toSOAPEnvelope(dummyEnvelope);
        return dummyEnvelope;
    }

    private static byte getServerSequenceStatus(String sequenceID, StorageManager storageManager) throws SandeshaException {
        RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceID);
        if (rmdBean != null && rmdBean.isTerminated()) {
            return 3;
        }
        if (rmdBean != null) {
            return 2;
        }
        throw new SandeshaException(SandeshaMessageHelper.getMessage("cannotFindSequence", sequenceID));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SequenceReport getIncomingSequenceReport(String sequenceID, ConfigurationContext configCtx) throws SandeshaException {
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configCtx, configCtx.getAxisConfiguration());
        Transaction reportTransaction = null;
        try {
            reportTransaction = storageManager.getTransaction();
            SequenceReport sequenceReport = new SequenceReport();
            RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceID);
            List completedMessageList = rmdBean.getServerCompletedMessages().getContainedElementsAsNumbersList();
            Iterator iter = completedMessageList.iterator();
            while (iter.hasNext()) {
                sequenceReport.addCompletedMessage((Long)iter.next());
            }
            sequenceReport.setSequenceID(sequenceID);
            sequenceReport.setInternalSequenceID(sequenceID);
            sequenceReport.setSequenceDirection((byte)1);
            sequenceReport.setSequenceStatus(SandeshaClient.getServerSequenceStatus(sequenceID, storageManager));
            if (rmdBean.getSecurityTokenData() != null) {
                sequenceReport.setSecureSequence(true);
            }
            if (reportTransaction != null && reportTransaction.isActive()) {
                reportTransaction.commit();
            }
            reportTransaction = null;
            SequenceReport sequenceReport2 = sequenceReport;
            return sequenceReport2;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Exception", e);
            }
        }
        finally {
            if (reportTransaction != null && reportTransaction.isActive()) {
                reportTransaction.rollback();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SOAPEnvelope configureTerminateSequence(Options options, ConfigurationContext configurationContext) throws SandeshaException {
        String rmSpecVersion;
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        EndpointReference epr = options.getTo();
        if (epr == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("toEPRNotValid", null));
        }
        String internalSequenceID = (String)options.getProperty(SandeshaClientConstants.INTERNAL_SEQUENCE_ID);
        if (internalSequenceID == null) {
            String to = epr.getAddress();
            String sequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
            internalSequenceID = SandeshaUtil.getInternalSequenceID(to, sequenceKey);
        }
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        Transaction transaction = null;
        String sequenceID = null;
        try {
            transaction = storageManager.getTransaction();
            sequenceID = SandeshaUtil.getSequenceIDFromInternalSequenceID(internalSequenceID, storageManager);
        }
        finally {
            if (transaction != null) {
                transaction.commit();
            }
        }
        if (sequenceID == null) {
            sequenceID = "uuid:tempID";
        }
        if ((rmSpecVersion = (String)options.getProperty(SandeshaClientConstants.RM_SPEC_VERSION)) == null) {
            rmSpecVersion = SpecSpecificConstants.getDefaultSpecVersion();
        }
        options.setAction(SpecSpecificConstants.getTerminateSequenceAction(rmSpecVersion));
        SOAPEnvelope dummyEnvelope = null;
        OMLinkedListImplFactory factory = null;
        String soapNamespaceURI = options.getSoapVersionURI();
        if (soapNamespaceURI == null) {
            soapNamespaceURI = SandeshaClient.getSOAPNamespaceURI(storageManager, internalSequenceID);
        }
        if ("http://www.w3.org/2003/05/soap-envelope".equals(soapNamespaceURI)) {
            factory = new SOAP12Factory();
            dummyEnvelope = factory.getDefaultEnvelope();
        } else {
            factory = new SOAP11Factory();
            dummyEnvelope = factory.getDefaultEnvelope();
        }
        String rmNamespaceValue = SpecSpecificConstants.getRMNamespaceValue(rmSpecVersion);
        TerminateSequence terminateSequence = new TerminateSequence(rmNamespaceValue);
        Identifier identifier = new Identifier(rmNamespaceValue);
        identifier.setIndentifer(sequenceID);
        terminateSequence.setIdentifier(identifier);
        terminateSequence.toSOAPEnvelope(dummyEnvelope);
        return dummyEnvelope;
    }

    private static void setUpServiceClientAnonymousOperations(ServiceClient serviceClient) throws SandeshaException {
        try {
            AxisOperation anonOutInOperation;
            AxisService service = serviceClient.getAxisService();
            AxisOperation anonOutOnlyOperation = service.getOperation(ServiceClient.ANON_OUT_ONLY_OP);
            if (anonOutOnlyOperation == null) {
                anonOutOnlyOperation = AxisOperationFactory.getAxisOperation(14);
                anonOutOnlyOperation.setName(ServiceClient.ANON_OUT_ONLY_OP);
                AxisOperation referenceOperation = service.getOperation(Sandesha2Constants.RM_IN_ONLY_OPERATION);
                if (referenceOperation != null) {
                    anonOutOnlyOperation.setPhasesOutFlow(referenceOperation.getPhasesOutFlow());
                    anonOutOnlyOperation.setPhasesOutFaultFlow(referenceOperation.getPhasesOutFaultFlow());
                    anonOutOnlyOperation.setPhasesInFaultFlow(referenceOperation.getPhasesInFaultFlow());
                    anonOutOnlyOperation.setPhasesInFaultFlow(referenceOperation.getRemainingPhasesInFlow());
                    service.addOperation(anonOutOnlyOperation);
                } else {
                    String message = "Cant find RM Operations. Please engage the Sandesha2 module before doing the invocation.";
                    throw new SandeshaException(message);
                }
            }
            if ((anonOutInOperation = service.getOperation(ServiceClient.ANON_OUT_IN_OP)) == null) {
                anonOutInOperation = AxisOperationFactory.getAxisOperation(16);
                anonOutInOperation.setName(ServiceClient.ANON_OUT_IN_OP);
                AxisOperation referenceOperation = service.getOperation(Sandesha2Constants.RM_IN_OUT_OPERATION);
                if (referenceOperation != null) {
                    anonOutInOperation.setPhasesOutFlow(referenceOperation.getPhasesOutFlow());
                    anonOutInOperation.setPhasesOutFaultFlow(referenceOperation.getPhasesOutFaultFlow());
                    anonOutInOperation.setPhasesInFaultFlow(referenceOperation.getPhasesInFaultFlow());
                    anonOutInOperation.setPhasesInFaultFlow(referenceOperation.getRemainingPhasesInFlow());
                    service.addOperation(anonOutInOperation);
                }
            }
        }
        catch (AxisFault e) {
            throw new SandeshaException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exception getLastSendError(ServiceClient serviceClient) throws SandeshaException {
        ServiceContext serviceContext;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaClient::getLastSendError");
        }
        String internalSequenceId = SandeshaClient.getInternalSequenceIdFromServiceClient(serviceClient);
        if (log.isTraceEnabled()) {
            log.trace("Looking up sequence with identifier " + internalSequenceId);
        }
        if ((serviceContext = serviceClient.getServiceContext()) == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("serviceContextNotSet"));
        }
        ConfigurationContext configurationContext = serviceContext.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        Transaction transaction = null;
        Exception resultException = null;
        try {
            transaction = storageManager.getTransaction();
            RMSBean bean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
            if (bean != null) {
                resultException = bean.getLastSendError();
            }
        }
        finally {
            if (transaction != null) {
                transaction.commit();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaClient::getLastSendError, " + resultException);
        }
        return resultException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getLastSendErrorTimestamp(ServiceClient serviceClient) throws SandeshaException {
        ServiceContext serviceContext;
        if (log.isDebugEnabled()) {
            log.debug("Enter: SandeshaClient::getLastSendErrorTimestamp");
        }
        String internalSequenceId = SandeshaClient.getInternalSequenceIdFromServiceClient(serviceClient);
        if (log.isTraceEnabled()) {
            log.trace("Looking up sequence with identifier " + internalSequenceId);
        }
        if ((serviceContext = serviceClient.getServiceContext()) == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("serviceContextNotSet"));
        }
        ConfigurationContext configurationContext = serviceContext.getConfigurationContext();
        StorageManager storageManager = SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration());
        Transaction transaction = null;
        long resultTime = -1L;
        try {
            transaction = storageManager.getTransaction();
            RMSBean bean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceId);
            if (bean != null) {
                resultTime = bean.getLastSendErrorTimestamp();
            }
        }
        finally {
            if (transaction != null) {
                transaction.commit();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Exit: SandeshaClient::getLastSendErrorTimestamp, " + resultTime);
        }
        return resultTime;
    }

    private static String getInternalSequenceIdFromServiceClient(ServiceClient serviceClient) throws SandeshaException {
        Options options = serviceClient.getOptions();
        if (options == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("optionsObjectNotSet"));
        }
        EndpointReference toEPR = options.getTo();
        if (toEPR == null) {
            throw new SandeshaException(SandeshaMessageHelper.getMessage("toEPRNotValid", null));
        }
        String to = toEPR.getAddress();
        String sequenceKey = (String)options.getProperty(SandeshaClientConstants.SEQUENCE_KEY);
        String internalSequenceID = SandeshaUtil.getInternalSequenceID(to, sequenceKey);
        return internalSequenceID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final String getSOAPNamespaceURI(StorageManager storageManager, String internalSequenceID) throws SandeshaException {
        String soapNamespaceURI = null;
        Transaction transaction = null;
        try {
            transaction = storageManager.getTransaction();
            RMSBean rmsBean = SandeshaUtil.getRMSBeanFromInternalSequenceId(storageManager, internalSequenceID);
            if (rmsBean.getSoapVersion() == 2) {
                soapNamespaceURI = "http://www.w3.org/2003/05/soap-envelope";
            }
        }
        finally {
            if (transaction != null) {
                transaction.commit();
            }
        }
        return soapNamespaceURI;
    }
}

