/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import java.util.Iterator;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.ConfigurationContext;
import org.apache.axis2.context.MessageContext;
import org.apache.axis2.description.AxisDescription;
import org.apache.axis2.description.AxisModule;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.engine.AxisConfiguration;
import org.apache.axis2.modules.Module;
import org.apache.axis2.modules.ModulePolicyExtension;
import org.apache.axis2.modules.PolicyExtension;
import org.apache.axis2.util.TargetResolver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.RMPolicyExtension;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.security.SecurityManager;
import org.apache.sandesha2.storage.SandeshaStorageException;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.util.PropertyManager;
import org.apache.sandesha2.util.SandeshaUtil;

public class SandeshaModule
implements Module,
ModulePolicyExtension {
    private Log log = LogFactory.getLog(SandeshaModule.class);

    public void init(ConfigurationContext configContext, AxisModule module) throws AxisFault {
        String value;
        Parameter propertiesFromRefReqMsg;
        String value2;
        String message;
        String message2;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entry: SandeshaModule::init, " + configContext);
        }
        AxisConfiguration config2 = configContext.getAxisConfiguration();
        Parameter parameter = new Parameter("Sandesha2ModuleClassLoader", module.getModuleClassLoader());
        config2.addParameter(parameter);
        SandeshaMessageHelper.innit();
        SandeshaUtil.setAxisModule(module);
        SandeshaPolicyBean constantPropertyBean = PropertyManager.loadPropertiesFromDefaultValues();
        SandeshaPolicyBean propertyBean = PropertyManager.loadPropertiesFromModuleDescPolicy(module, constantPropertyBean);
        if (propertyBean == null) {
            message2 = SandeshaMessageHelper.getMessage("couldNotLoadModulePolicies");
            this.log.error(message2);
            propertyBean = PropertyManager.loadPropertiesFromDefaultValues();
        } else if (this.log.isDebugEnabled()) {
            message2 = SandeshaMessageHelper.getMessage("modulePoliciesLoaded");
            this.log.info(message2);
        }
        parameter = new Parameter("Sandesha2PropertyBean", propertyBean);
        config2.addParameter(parameter);
        parameter = config2.getParameter("inmemory");
        if (parameter != null) {
            config2.removeParameter(parameter);
        }
        if ((parameter = config2.getParameter("persistent")) != null) {
            config2.removeParameter(parameter);
        }
        try {
            StorageManager inMemorytorageManager = SandeshaUtil.getInMemoryStorageManager(configContext);
            inMemorytorageManager.initStorage(module);
        }
        catch (SandeshaStorageException e) {
            message = SandeshaMessageHelper.getMessage("cannotInitInMemoryStorageManager", e.toString());
            this.log.debug(message, e);
        }
        try {
            StorageManager permanentStorageManager = SandeshaUtil.getPermanentStorageManager(configContext);
            permanentStorageManager.initStorage(module);
        }
        catch (SandeshaStorageException e) {
            message = SandeshaMessageHelper.getMessage("cannotInitPersistentStorageManager", e.toString());
            this.log.debug(message, e);
        }
        parameter = config2.getParameter("Sandesha2SecurityManager");
        if (parameter != null) {
            config2.removeParameter(parameter);
        }
        SecurityManager util = SandeshaUtil.getSecurityManager(configContext);
        util.initSecurity(module);
        configContext.setProperty("UseAsyncOperations", Boolean.TRUE);
        configContext.getAxisConfiguration().addTargetResolver(new TargetResolver(){

            public void resolveTarget(MessageContext messageContext) {
                if (SandeshaModule.this.log.isDebugEnabled()) {
                    SandeshaModule.this.log.debug("Entry: SandeshaModule::resolveTarget");
                }
                if (SandeshaUtil.isMessageUnreliable(messageContext)) {
                    if (SandeshaModule.this.log.isDebugEnabled()) {
                        SandeshaModule.this.log.debug("Unsetting USE_ASYNC_OPERATIONS for unreliable message");
                    }
                    messageContext.setProperty("UseAsyncOperations", Boolean.FALSE);
                }
                if (SandeshaModule.this.log.isDebugEnabled()) {
                    SandeshaModule.this.log.debug("Exit: SandeshaModule::resolveTarget");
                }
            }
        });
        Parameter propertiesFromRefMsg = module.getParameter("propertiesToCopyFromReferenceMessage");
        if (propertiesFromRefMsg != null && (value2 = (String)propertiesFromRefMsg.getValue()) != null) {
            value2 = value2.trim();
            String[] propertyNames = value2.split(",");
            Parameter param = new Parameter();
            param.setName("propertiesToCopyFromReferenceMessageAsStringArray");
            param.setValue(propertyNames);
            module.addParameter(param);
        }
        if ((propertiesFromRefReqMsg = module.getParameter("propertiesToCopyFromReferenceRequestMessage")) != null && (value = (String)propertiesFromRefReqMsg.getValue()) != null) {
            value = value.trim();
            String[] propertyNames = value.split(",");
            Parameter param = new Parameter();
            param.setName("propertiesToCopyFromReferenceRequestMessageAsStringArray");
            param.setValue(propertyNames);
            module.addParameter(param);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Exit: SandeshaModule::init");
        }
    }

    public void engageNotify(AxisDescription axisDescription) throws AxisFault {
        SandeshaPolicyBean parentPropertyBean;
        SandeshaPolicyBean axisDescPropertyBean;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entry: SandeshaModule::engageNotify, " + axisDescription);
        }
        if ((axisDescPropertyBean = PropertyManager.loadPropertiesFromAxisDescription(axisDescription, parentPropertyBean = SandeshaUtil.getPropertyBean(axisDescription.getParent()))) != null) {
            Parameter parameter = new Parameter();
            parameter.setName("Sandesha2PropertyBean");
            parameter.setValue(axisDescPropertyBean);
            axisDescription.addParameter(parameter);
        }
        axisDescription.addParameter(new Parameter("DisableResponseAck", Boolean.TRUE));
        if (axisDescription instanceof AxisService) {
            AxisService service = (AxisService)axisDescription;
            Iterator ops = service.getOperations();
            while (ops.hasNext()) {
                AxisOperation op = (AxisOperation)ops.next();
                this.log.debug("Examining operation " + op.getName() + ", mep " + op.getAxisSpecifMEPConstant());
                String name = null;
                QName qName = op.getName();
                if (qName != null) {
                    name = qName.getLocalPart();
                }
                if (!(name != null && name.startsWith("Sandesha2Operation") || ServiceClient.ANON_OUT_IN_OP.equals(qName))) {
                    if (op.getAxisSpecifMEPConstant() != 16) continue;
                    Parameter p = new Parameter("ServiceContainsOutInMeps", Boolean.TRUE);
                    service.addParameter(p);
                }
                break;
            }
        } else if (axisDescription instanceof AxisOperation) {
            AxisOperation op = (AxisOperation)axisDescription;
            this.log.debug("Examining operation " + op.getName() + ", mep " + op.getAxisSpecifMEPConstant());
            String name = null;
            QName qName = op.getName();
            if (qName != null) {
                name = qName.getLocalPart();
            }
            if (name != null && !name.startsWith("Sandesha2Operation") && !ServiceClient.ANON_OUT_IN_OP.equals(qName) && op.getAxisSpecifMEPConstant() == 16) {
                Parameter p = new Parameter("ServiceContainsOutInMeps", Boolean.TRUE);
                op.getParent().addParameter(p);
            }
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Exit: SandeshaModule::engageNotify");
        }
    }

    public PolicyExtension getPolicyExtension() {
        return new RMPolicyExtension();
    }

    public void shutdown(ConfigurationContext configurationContext) throws AxisFault {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Entry: SandeshaModule::shutdown, " + configurationContext);
        }
        SandeshaUtil.getSandeshaStorageManager(configurationContext, configurationContext.getAxisConfiguration()).shutdown();
        if (this.log.isDebugEnabled()) {
            this.log.debug("Exit: SandeshaModule::shutdown");
        }
    }

    public void applyPolicy(Policy policy, AxisDescription axisDescription) throws AxisFault {
    }

    public boolean canSupportAssertion(Assertion assertion) {
        return true;
    }
}

