/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sandesha2;

import org.apache.sandesha2.RMMsgContext;
import org.apache.sandesha2.SandeshaException;
import org.apache.sandesha2.i18n.SandeshaMessageHelper;
import org.apache.sandesha2.policy.SandeshaPolicyBean;
import org.apache.sandesha2.storage.StorageManager;
import org.apache.sandesha2.storage.beans.RMDBean;
import org.apache.sandesha2.storage.beans.RMSBean;
import org.apache.sandesha2.util.SandeshaUtil;
import org.apache.sandesha2.util.SpecSpecificConstants;

public class MessageValidator {
    public static void validateMessage(RMMsgContext rmMsg, StorageManager storageManager) throws SandeshaException {
        SandeshaPolicyBean propertyBean;
        int type = rmMsg.getMessageType();
        if (type != 1 && type != 0) {
            String sequenceID = SandeshaUtil.getSequenceIDFromRMMessage(rmMsg);
            if (sequenceID != null) {
                String rmVersionOfSequence = null;
                RMDBean rmdBean = SandeshaUtil.getRMDBeanFromSequenceId(storageManager, sequenceID);
                if (rmdBean != null) {
                    rmVersionOfSequence = rmdBean.getRMVersion();
                } else {
                    RMSBean rmsBean = SandeshaUtil.getRMSBeanFromSequenceId(storageManager, sequenceID);
                    if (rmsBean != null) {
                        rmVersionOfSequence = rmsBean.getRMVersion();
                    }
                }
                String rmNamespaceOfMsg = rmMsg.getRMNamespaceValue();
                String rmNamespaceOfSequence = null;
                if (rmVersionOfSequence != null) {
                    rmNamespaceOfSequence = SpecSpecificConstants.getRMNamespaceValue(rmVersionOfSequence);
                }
                if (rmNamespaceOfSequence != null && !rmNamespaceOfSequence.equals(rmNamespaceOfMsg)) {
                    String message = SandeshaMessageHelper.getMessage("rmNamespaceNotMatchSequence", rmNamespaceOfMsg, rmNamespaceOfSequence, sequenceID);
                    throw new SandeshaException(message);
                }
            }
        } else if (type == 0 && (propertyBean = SandeshaUtil.getPropertyBean(rmMsg.getMessageContext().getAxisOperation())).isEnforceRM()) {
            String message = SandeshaMessageHelper.getMessage("rmEnforceFailure", rmMsg.getMessageId());
            throw new SandeshaException(message);
        }
    }
}

