/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HttpStatus;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.message.BasicHttpVersion;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

public class BasicStatusLine
implements StatusLine {
    private final HttpVersion httpVersion;
    private final int statusCode;
    private final String reasonPhrase;

    public BasicStatusLine(HttpVersion httpVersion, int statusCode, String reasonPhrase) {
        if (httpVersion == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        if (statusCode < 0) {
            throw new IllegalArgumentException("Status code may not be negative");
        }
        this.httpVersion = httpVersion;
        this.statusCode = statusCode;
        this.reasonPhrase = reasonPhrase;
    }

    public BasicStatusLine(HttpVersion httpVersion, int statusCode) {
        this(httpVersion, statusCode, HttpStatus.getStatusText(statusCode));
    }

    public static StatusLine parse(CharArrayBuffer buffer, int indexFrom, int indexTo) throws ProtocolException {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int i = indexFrom;
            while (HTTP.isWhitespace(buffer.charAt(i))) {
                ++i;
            }
            int blank = buffer.indexOf(32, i, indexTo);
            if (blank <= 0) {
                throw new ProtocolException("Unable to parse HTTP-Version from the status line: " + buffer.substring(indexFrom, indexTo));
            }
            HttpVersion ver = BasicHttpVersion.parse(buffer, i, blank);
            i = blank;
            while (HTTP.isWhitespace(buffer.charAt(i))) {
                ++i;
            }
            blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                blank = indexTo;
            }
            int statusCode = 0;
            try {
                statusCode = Integer.parseInt(buffer.substringTrimmed(i, blank));
            }
            catch (NumberFormatException e) {
                throw new ProtocolException("Unable to parse status code from status line: " + buffer.substring(indexFrom, indexTo));
            }
            i = blank;
            String reasonPhrase = null;
            reasonPhrase = i < indexTo ? buffer.substringTrimmed(i, indexTo) : "";
            return new BasicStatusLine(ver, statusCode, reasonPhrase);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException("Invalid status line: " + buffer.substring(indexFrom, indexTo));
        }
    }

    public static final StatusLine parse(String s) throws ProtocolException {
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        return BasicStatusLine.parse(buffer, 0, buffer.length());
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public HttpVersion getHttpVersion() {
        return this.httpVersion;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String toString() {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append(this.httpVersion);
        buffer.append(' ');
        buffer.append(Integer.toString(this.statusCode));
        if (this.reasonPhrase != null && this.reasonPhrase.length() > 0) {
            buffer.append(' ');
            buffer.append(this.reasonPhrase);
        }
        return buffer.toString();
    }

    public static void format(CharArrayBuffer buffer, StatusLine statusline) {
        if (buffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (statusline == null) {
            throw new IllegalArgumentException("Status line may not be null");
        }
        BasicHttpVersion.format(buffer, statusline.getHttpVersion());
        buffer.append(' ');
        buffer.append(Integer.toString(statusline.getStatusCode()));
        if (statusline.getReasonPhrase() != null) {
            buffer.append(' ');
            buffer.append(statusline.getReasonPhrase());
        }
    }

    public static String format(StatusLine statusline) {
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        BasicStatusLine.format(buffer, statusline);
        return buffer.toString();
    }
}

