/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.message;

import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.RequestLine;
import org.apache.http.message.BasicHttpVersion;
import org.apache.http.protocol.HTTP;
import org.apache.http.util.CharArrayBuffer;

public class BasicRequestLine
implements RequestLine {
    private final HttpVersion httpversion;
    private final String method;
    private final String uri;

    public BasicRequestLine(String method, String uri, HttpVersion httpversion) {
        if (method == null) {
            throw new IllegalArgumentException("Method may not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("URI may not be null");
        }
        if (httpversion == null) {
            throw new IllegalArgumentException("HTTP version may not be null");
        }
        this.method = method;
        this.uri = uri;
        this.httpversion = httpversion;
    }

    public String getMethod() {
        return this.method;
    }

    public HttpVersion getHttpVersion() {
        return this.httpversion;
    }

    public String getUri() {
        return this.uri;
    }

    public String toString() {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append(this.method);
        buffer.append(' ');
        buffer.append(this.uri);
        buffer.append(' ');
        buffer.append(this.httpversion);
        return buffer.toString();
    }

    public static RequestLine parse(CharArrayBuffer buffer, int indexFrom, int indexTo) throws ProtocolException {
        if (buffer == null) {
            throw new IllegalArgumentException("Char array buffer may not be null");
        }
        if (indexFrom < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (indexTo > buffer.length()) {
            throw new IndexOutOfBoundsException();
        }
        if (indexFrom > indexTo) {
            throw new IndexOutOfBoundsException();
        }
        try {
            int i = indexFrom;
            while (HTTP.isWhitespace(buffer.charAt(i))) {
                ++i;
            }
            int blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                throw new ProtocolException("Invalid request line: " + buffer.substring(indexFrom, indexTo));
            }
            String method = buffer.substringTrimmed(i, blank);
            i = blank;
            while (HTTP.isWhitespace(buffer.charAt(i))) {
                ++i;
            }
            blank = buffer.indexOf(32, i, indexTo);
            if (blank < 0) {
                throw new ProtocolException("Invalid request line: " + buffer.substring(indexFrom, indexTo));
            }
            String uri = buffer.substringTrimmed(i, blank);
            HttpVersion ver = BasicHttpVersion.parse(buffer, blank, indexTo);
            return new BasicRequestLine(method, uri, ver);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ProtocolException("Invalid request line: " + buffer.substring(indexFrom, indexTo));
        }
    }

    public static final RequestLine parse(String s) throws ProtocolException {
        if (s == null) {
            throw new IllegalArgumentException("String may not be null");
        }
        CharArrayBuffer buffer = new CharArrayBuffer(s.length());
        buffer.append(s);
        return BasicRequestLine.parse(buffer, 0, buffer.length());
    }

    public static void format(CharArrayBuffer buffer, RequestLine requestline) {
        if (buffer == null) {
            throw new IllegalArgumentException("String buffer may not be null");
        }
        if (requestline == null) {
            throw new IllegalArgumentException("Request line may not be null");
        }
        buffer.append(requestline.getMethod());
        buffer.append(' ');
        buffer.append(requestline.getUri());
        buffer.append(' ');
        BasicHttpVersion.format(buffer, requestline.getHttpVersion());
    }

    public static String format(RequestLine requestline) {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        BasicRequestLine.format(buffer, requestline);
        return buffer.toString();
    }
}

