/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLConnection;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.wsdl.Binding;
import javax.wsdl.BindingFault;
import javax.wsdl.BindingInput;
import javax.wsdl.BindingOperation;
import javax.wsdl.BindingOutput;
import javax.wsdl.Definition;
import javax.wsdl.Fault;
import javax.wsdl.Import;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.Service;
import javax.wsdl.Types;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.ExtensionRegistry;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import org.apache.axis2.java.security.AccessController;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Element;

public class WSDLDefinitionWrapper
implements Definition {
    private static final Log log = LogFactory.getLog(WSDLDefinitionWrapper.class);
    private static final boolean isDebugEnabled = log.isDebugEnabled();
    private static final String myClassName = "WSDLDefinitionWrapper";
    static final long serialVersionUID = -2788807375814097409L;
    private Definition wsdlDefinition = null;
    private URL wsdlURL = null;
    private String wsdlExplicitURI = null;
    private String wsdlDocumentBaseURI = null;

    public WSDLDefinitionWrapper(Definition def) {
        this.prepare(def, null);
    }

    public WSDLDefinitionWrapper(Definition def, URL wURL) {
        this.prepare(def, wURL);
    }

    private void prepare(Definition def, URL wURL) {
        block8: {
            this.wsdlDefinition = def;
            this.wsdlURL = wURL;
            if (def != null) {
                try {
                    this.wsdlDocumentBaseURI = def.getDocumentBaseURI();
                    if (this.wsdlURL == null && this.wsdlDocumentBaseURI != null) {
                        try {
                            URL locURL;
                            this.wsdlURL = locURL = new URL(this.wsdlDocumentBaseURI);
                        }
                        catch (Exception uex) {
                            // empty catch block
                        }
                    }
                    if (this.wsdlURL != null) {
                        this.wsdlExplicitURI = this.getExplicitURI(this.wsdlURL);
                    }
                    def.setTypes(null);
                    def.setDocumentationElement(null);
                }
                catch (Exception e) {
                    if (!isDebugEnabled) break block8;
                    log.debug("WSDLDefinitionWrapper.prepare():  Caught exception [" + e.getClass().getName() + "]  error [" + e.getMessage() + "]", e);
                }
            }
        }
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.prepare():   wsdlDocumentBaseURI [" + this.wsdlDocumentBaseURI + "]     wsdlExplicitURI [" + this.wsdlExplicitURI + "]   wsdlURL [" + this.wsdlURL + "]");
        }
    }

    public void releaseResources() {
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setTypes(null);
            this.wsdlDefinition.setDocumentationElement(null);
        }
    }

    public Definition getUnwrappedDefinition() {
        Definition def;
        if (this.wsdlDefinition == null) {
            try {
                def = this.loadDefinition();
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug("WSDLDefinitionWrapper.getUnwrappedDefinition(): error trying to load Definition    [" + e.getClass().getName() + "]  error [" + e.getMessage() + "] ", e);
                }
                def = null;
            }
        } else if (this.wsdlDefinition instanceof WSDLDefinitionWrapper) {
            def = ((WSDLDefinitionWrapper)this.wsdlDefinition).getUnwrappedDefinition();
        } else {
            try {
                def = this.loadDefinition();
                if (def == null) {
                    def = this.wsdlDefinition;
                }
            }
            catch (Exception e) {
                if (isDebugEnabled) {
                    log.debug("WSDLDefinitionWrapper.getUnwrappedDefinition(): error trying to load Definition    [" + e.getClass().getName() + "]  error [" + e.getMessage() + "] ", e);
                }
                def = this.wsdlDefinition;
            }
        }
        return def;
    }

    public void setDocumentBaseURI(String d) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.setDocumentBaseURI(" + d + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setDocumentBaseURI(d);
        }
    }

    public String getDocumentBaseURI() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getDocumentBaseURI()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getDocumentBaseURI();
        }
        return null;
    }

    public void setQName(QName n) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.setQName(" + n + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setQName(n);
        }
    }

    public QName getQName() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getQName()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getQName();
        }
        return null;
    }

    public void setTargetNamespace(String t) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.setTargetNamespace(" + t + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setTargetNamespace(t);
        }
    }

    public String getTargetNamespace() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getTargetNamespace()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getTargetNamespace();
        }
        return null;
    }

    public void addNamespace(String prefix, String namespaceURI) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.addNamespace(" + prefix + ", " + namespaceURI + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addNamespace(prefix, namespaceURI);
        }
    }

    public String removeNamespace(String prefix) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.removeNamespace(" + prefix + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeNamespace(prefix);
        }
        return null;
    }

    public String getNamespace(String prefix) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getNamespace(" + prefix + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getNamespace(prefix);
        }
        return null;
    }

    public String getPrefix(String namespaceURI) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getPrefix(" + namespaceURI + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getPrefix(namespaceURI);
        }
        return null;
    }

    public Map getNamespaces() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getNamespaces()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getNamespaces();
        }
        return null;
    }

    public List getNativeAttributeNames() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getNativeAttributeNames()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getNativeAttributeNames();
        }
        return null;
    }

    public void setTypes(Types types) {
        if (this.wsdlDefinition != null) {
            if (isDebugEnabled) {
                log.debug("WSDLDefinitionWrapper.setTypes() from wsdl Definition");
            }
            this.wsdlDefinition.setTypes(types);
            this.wsdlDefinition.setTypes(null);
        } else if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.setTypes(): nothing to set");
        }
    }

    public Types getTypes() {
        Definition def;
        block5: {
            def = null;
            try {
                def = this.loadDefinition();
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block5;
                log.debug("WSDLDefinitionWrapper.getTypes(): error trying to load Definition    [" + e.getClass().getName() + "]  error [" + e.getMessage() + "] ", e);
            }
        }
        if (def != null) {
            Types t = def.getTypes();
            if (isDebugEnabled) {
                log.debug("WSDLDefinitionWrapper.getTypes() from reloaded wsdl Definition returning [" + t + "]");
            }
            return t;
        }
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getTypes() returning NULL");
        }
        return null;
    }

    public void addImport(Import importDef) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.addImport(" + importDef + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addImport(importDef);
        }
    }

    public Import removeImport(Import importDef) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.removeImport(" + importDef + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeImport(importDef);
        }
        return null;
    }

    public List getImports(String namespaceURI) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getImports(" + namespaceURI + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getImports(namespaceURI);
        }
        return null;
    }

    public Map getImports() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getImports()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getImports();
        }
        return null;
    }

    public void addMessage(Message message) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.addMessage(" + message + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addMessage(message);
        }
    }

    public Message getMessage(QName name) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getMessage(" + name + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getMessage(name);
        }
        return null;
    }

    public Message removeMessage(QName name) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.removeMessage(" + name + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeMessage(name);
        }
        return null;
    }

    public Map getMessages() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getMessages()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getMessages();
        }
        return null;
    }

    public void addBinding(Binding binding) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.addBinding(" + binding + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addBinding(binding);
        }
    }

    public Binding getBinding(QName name) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getBinding(" + name + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getBinding(name);
        }
        return null;
    }

    public Binding removeBinding(QName name) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.removeBinding(" + name + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeBinding(name);
        }
        return null;
    }

    public Map getBindings() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getBindings()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getBindings();
        }
        return null;
    }

    public Map getAllBindings() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getAllBindings()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getAllBindings();
        }
        return null;
    }

    public void addPortType(PortType portType) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.addPortType(" + portType + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addPortType(portType);
        }
    }

    public PortType getPortType(QName name) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getPortType(" + name + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getPortType(name);
        }
        return null;
    }

    public PortType removePortType(QName name) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.removePortType(" + name + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removePortType(name);
        }
        return null;
    }

    public Map getPortTypes() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getPortTypes()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getPortTypes();
        }
        return null;
    }

    public Map getAllPortTypes() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getAllPortTypes()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getAllPortTypes();
        }
        return null;
    }

    public void addService(Service service) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.addService(" + service + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addService(service);
        }
    }

    public Service getService(QName name) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getService(" + name + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getService(name);
        }
        return null;
    }

    public Service removeService(QName name) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.removeService(" + name + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeService(name);
        }
        return null;
    }

    public Map getServices() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getServices()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getServices();
        }
        return null;
    }

    public Map getAllServices() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getAllServices()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getAllServices();
        }
        return null;
    }

    public void setDocumentationElement(Element docEl) {
        if (this.wsdlDefinition != null) {
            if (isDebugEnabled) {
                log.debug("WSDLDefinitionWrapper.setDocumentationElement(docEl) from wsdl Definition");
            }
            this.wsdlDefinition.setDocumentationElement(docEl);
            this.wsdlDefinition.setDocumentationElement(null);
        } else if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.setDocumentationElement(docEl): nothing to set");
        }
    }

    public Element getDocumentationElement() {
        Definition def;
        block8: {
            if (isDebugEnabled) {
                log.debug("WSDLDefinitionWrapper.getDocumentationElement() from reloaded wsdl Definition");
            }
            def = null;
            try {
                def = this.loadDefinition();
            }
            catch (Exception e) {
                if (!isDebugEnabled) break block8;
                log.debug("WSDLDefinitionWrapper.getDocumentationElement(): error trying to load Definition    [" + e.getClass().getName() + "]  error [" + e.getMessage() + "] ", e);
            }
        }
        if (def != null) {
            Element docElement = def.getDocumentationElement();
            if (isDebugEnabled) {
                if (docElement != null) {
                    log.debug("WSDLDefinitionWrapper.getDocumentationElement() from reloaded wsdl Definition returning  NON-NULL org.w3c.dom.Element");
                } else {
                    log.debug("WSDLDefinitionWrapper.getDocumentationElement() from reloaded wsdl Definition returning  NULL org.w3c.dom.Element");
                }
            }
            return docElement;
        }
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getDocumentationElement() returning NULL");
        }
        return null;
    }

    public void addExtensibilityElement(ExtensibilityElement extElement) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.addExtensibilityElement(" + extElement + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.addExtensibilityElement(extElement);
        }
    }

    public List getExtensibilityElements() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getExtensibilityElements()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getExtensibilityElements();
        }
        return null;
    }

    public Binding createBinding() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createBinding()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createBinding();
        }
        return null;
    }

    public BindingFault createBindingFault() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createBindingFault()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createBindingFault();
        }
        return null;
    }

    public BindingInput createBindingInput() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createBindingInput()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createBindingInput();
        }
        return null;
    }

    public BindingOperation createBindingOperation() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createBindingOperation()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createBindingOperation();
        }
        return null;
    }

    public BindingOutput createBindingOutput() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createBindingOutput()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createBindingOutput();
        }
        return null;
    }

    public Fault createFault() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createFault()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createFault();
        }
        return null;
    }

    public Import createImport() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createImport()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createImport();
        }
        return null;
    }

    public Input createInput() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createInput()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createInput();
        }
        return null;
    }

    public Message createMessage() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createMessage()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createMessage();
        }
        return null;
    }

    public Operation createOperation() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createOperation()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createOperation();
        }
        return null;
    }

    public Output createOutput() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createOutput()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createOutput();
        }
        return null;
    }

    public Part createPart() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createPart()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createPart();
        }
        return null;
    }

    public Port createPort() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createPort()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createPort();
        }
        return null;
    }

    public PortType createPortType() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createPortType()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createPortType();
        }
        return null;
    }

    public Service createService() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createService()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createService();
        }
        return null;
    }

    public Types createTypes() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.createTypes()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.createTypes();
        }
        return null;
    }

    public void setExtensionRegistry(ExtensionRegistry extReg) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.setExtensionRegistry(" + extReg + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setExtensionRegistry(extReg);
        }
    }

    public ExtensionRegistry getExtensionRegistry() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getExtensionRegistry()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getExtensionRegistry();
        }
        return null;
    }

    public String toString() {
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.toString();
        }
        return "";
    }

    public ExtensibilityElement removeExtensibilityElement(ExtensibilityElement extElement) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.removeExtensibilityElement(" + extElement + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.removeExtensibilityElement(extElement);
        }
        return null;
    }

    public Object getExtensionAttribute(QName name) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getExtensionAttribute(" + name + ")");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getExtensionAttribute(name);
        }
        return null;
    }

    public Map getExtensionAttributes() {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getExtensionAttributes()");
        }
        if (this.wsdlDefinition != null) {
            return this.wsdlDefinition.getExtensionAttributes();
        }
        return null;
    }

    public void setExtensionAttribute(QName name, Object value) {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.setExtensionAttribute(" + name + ",  " + value + ")");
        }
        if (this.wsdlDefinition != null) {
            this.wsdlDefinition.setExtensionAttribute(name, value);
        }
    }

    private String getExplicitURI(URL wsdlURL) throws WSDLException {
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.getExplicitURI(" + wsdlURL + ") ");
        }
        String explicitURI = null;
        ClassLoader classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        try {
            boolean isFileProtocol;
            URL url = wsdlURL;
            String filePath = null;
            boolean bl = isFileProtocol = url != null && "file".equals(url.getProtocol());
            if (isFileProtocol) {
                boolean isRelativePath;
                filePath = url != null ? url.getPath() : null;
                URI uri = null;
                if (url != null) {
                    uri = url.toURI();
                }
                boolean bl2 = isRelativePath = filePath != null && !new File(filePath).isAbsolute();
                if (isRelativePath) {
                    if (isDebugEnabled) {
                        log.debug("WSDLDefinitionWrapper.getExplicitURI(" + wsdlURL + "): WSDL URL has a relative path");
                    }
                    if ((url = this.getAbsoluteURL(classLoader, filePath)) == null) {
                        if (isDebugEnabled) {
                            log.debug("WSDLDefinitionWrapper.getExplicitURI(" + wsdlURL + "): " + "WSDL URL for relative path not found in ClassLoader");
                            log.debug("WSDLDefinitionWrapper.getExplicitURI(" + wsdlURL + "): " + "Unable to read WSDL from relative path, check the relative path");
                            log.debug("WSDLDefinitionWrapper.getExplicitURI(" + wsdlURL + "): " + "Relative path example: file:/WEB-INF/wsdl/<wsdlfilename>");
                            log.debug("WSDLDefinitionWrapper.getExplicitURI(" + wsdlURL + "): " + "Using relative path as default wsdl URL to load wsdl Definition.");
                        }
                        url = wsdlURL;
                    } else if (isDebugEnabled) {
                        log.debug("WSDLDefinitionWrapper.getExplicitURI(" + wsdlURL + "): " + "WSDL URL found for relative path: " + filePath + " scheme: " + uri.getScheme());
                    }
                }
            }
            URLConnection urlCon = url.openConnection();
            InputStream is = null;
            try {
                is = this.getInputStream(urlCon);
            }
            catch (IOException e) {
                if (isDebugEnabled) {
                    log.debug("WSDLDefinitionWrapper.getExplicitURI(" + wsdlURL + "): " + "Could not open url connection. Trying to use " + "classloader to get another URL.");
                }
                if (filePath != null) {
                    url = this.getAbsoluteURL(classLoader, filePath);
                    if (url == null) {
                        if (log.isDebugEnabled()) {
                            log.debug("Could not locate URL for wsdl. Reporting error");
                        }
                        throw new WSDLException("WSDL4JWrapper : ", e.getMessage(), e);
                    }
                    urlCon = url.openConnection();
                    if (log.isDebugEnabled()) {
                        log.debug("Found URL for WSDL from jar");
                    }
                }
                if (isDebugEnabled) {
                    log.debug("WSDLDefinitionWrapper.getExplicitURI(" + wsdlURL + "): " + "Could not get URL from classloader. Reporting " + "error due to no file path.");
                }
                throw new WSDLException("WSDLDefinitionWrapper : ", e.getMessage(), e);
            }
            if (is != null) {
                is.close();
            }
            explicitURI = urlCon.getURL().toString();
        }
        catch (Exception ex) {
            throw new WSDLException("WSDLDefinitionWrapper : ", ex.getMessage(), ex);
        }
        return explicitURI;
    }

    private URL getAbsoluteURL(ClassLoader classLoader, String filePath) throws WSDLException {
        URL url = classLoader.getResource(filePath);
        if (url == null) {
            if (log.isDebugEnabled()) {
                log.debug("Could not get URL from classloader. Looking in a jar.");
            }
            if (classLoader instanceof URLClassLoader) {
                URLClassLoader urlLoader = (URLClassLoader)classLoader;
                url = this.getURLFromJAR(urlLoader, this.wsdlURL);
            }
        }
        return url;
    }

    private Definition loadDefinition() throws WSDLException {
        Definition def = null;
        if (this.wsdlExplicitURI != null) {
            try {
                def = (Definition)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws WSDLException {
                        WSDLReader reader = WSDLDefinitionWrapper.this.getWSDLReader();
                        return reader.readWSDL(WSDLDefinitionWrapper.this.wsdlExplicitURI);
                    }
                });
            }
            catch (PrivilegedActionException e) {
                if (isDebugEnabled) {
                    log.debug("WSDLDefinitionWrapper.loadDefinition(): Exception thrown from AccessController: " + e);
                }
                WSDLException we = new WSDLException("WSDLDefinitionWrapper : ", e.getMessage(), e);
                throw we;
            }
        }
        if (isDebugEnabled) {
            log.debug("WSDLDefinitionWrapper.loadDefinition():  returning Definition [" + def + "]");
        }
        return def;
    }

    private URL getURLFromJAR(URLClassLoader urlLoader, URL relativeURL) throws WSDLException {
        URL[] urlList = urlLoader.getURLs();
        if (urlList == null) {
            return null;
        }
        for (int i = 0; i < urlList.length; ++i) {
            File f;
            URL url = urlList[i];
            if (url == null) {
                return null;
            }
            if (!"file".equals(url.getProtocol()) || !(f = new File(url.getPath())).exists() || f.isDirectory()) continue;
            try {
                JarFile jf = new JarFile(f);
                Enumeration<JarEntry> entries = jf.entries();
                while (entries.hasMoreElements()) {
                    String relativePath;
                    JarEntry je = entries.nextElement();
                    String name = je.getName();
                    if (!name.endsWith(".wsdl") || !(relativePath = relativeURL.getPath()).endsWith(name)) continue;
                    String path = f.getAbsolutePath();
                    if (path != null && path.indexOf("/") == 0) {
                        path = path.substring(1, path.length());
                    }
                    URL absoluteUrl = new URL("jar:file:/" + path + "!/" + je.getName());
                    return absoluteUrl;
                }
                continue;
            }
            catch (Exception e) {
                WSDLException we = new WSDLException("WSDLDefinitionWrapper : ", e.getMessage(), e);
                throw we;
            }
        }
        return null;
    }

    private WSDLReader getWSDLReader() throws WSDLException {
        WSDLReader reader;
        try {
            reader = (WSDLReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws WSDLException {
                    WSDLFactory factory = WSDLFactory.newInstance();
                    return factory.newWSDLReader();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw (WSDLException)e.getException();
        }
        reader.setFeature("javax.wsdl.verbose", false);
        return reader;
    }

    private InputStream getInputStream(URLConnection urlCon) throws Exception {
        final URLConnection finalURLCon = urlCon;
        InputStream is = null;
        try {
            is = (InputStream)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException {
                    return finalURLCon.getInputStream();
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw e.getException();
        }
        return is;
    }
}

