/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.util;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Import;
import javax.wsdl.Types;
import javax.wsdl.extensions.ExtensibilityElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WSDL4JImportedWSDLHelper {
    protected static final Log log = LogFactory.getLog(WSDL4JImportedWSDLHelper.class);
    private static final boolean isTraceEnabled = log.isTraceEnabled();

    public static void processImports(Definition wsdl4JDefinition) {
        if (isTraceEnabled) {
            log.trace("processImports: wsdl4JDefinition=" + wsdl4JDefinition);
        }
        HashMap imported_defs = new HashMap();
        WSDL4JImportedWSDLHelper.getImportedDefinitions(wsdl4JDefinition, imported_defs);
        Iterator iterator = imported_defs.values().iterator();
        while (iterator.hasNext()) {
            Definition imported_def = (Definition)iterator.next();
            Map def_namespaces = wsdl4JDefinition.getNamespaces();
            Map imported_def_namespaces = imported_def.getNamespaces();
            Iterator prefix_iterator = imported_def_namespaces.keySet().iterator();
            while (prefix_iterator.hasNext()) {
                Object prefix = prefix_iterator.next();
                if (def_namespaces.containsKey(prefix)) continue;
                def_namespaces.put(prefix, imported_def_namespaces.get(prefix));
            }
            Types imported_def_types = imported_def.getTypes();
            if (imported_def_types != null) {
                Types def_types = wsdl4JDefinition.getTypes();
                if (def_types == null) {
                    def_types = wsdl4JDefinition.createTypes();
                    wsdl4JDefinition.setTypes(def_types);
                }
                Iterator types_iterator = imported_def_types.getExtensibilityElements().iterator();
                while (types_iterator.hasNext()) {
                    def_types.addExtensibilityElement((ExtensibilityElement)types_iterator.next());
                }
            }
            wsdl4JDefinition.getMessages().putAll(imported_def.getMessages());
            wsdl4JDefinition.getPortTypes().putAll(imported_def.getPortTypes());
            wsdl4JDefinition.getBindings().putAll(imported_def.getBindings());
            wsdl4JDefinition.getServices().putAll(imported_def.getServices());
            wsdl4JDefinition.getExtensibilityElements().addAll(imported_def.getExtensibilityElements());
        }
    }

    private static void getImportedDefinitions(Definition definition, Map importedDefs) {
        Map wsdlImports = definition.getImports();
        Iterator iterator = wsdlImports.values().iterator();
        while (iterator.hasNext()) {
            Vector imports = (Vector)iterator.next();
            Iterator iter2 = imports.iterator();
            while (iter2.hasNext()) {
                Definition imported_def;
                String import_def_key;
                Import wsdl_import = (Import)iter2.next();
                if (isTraceEnabled) {
                    log.trace("getImportedDefinitions: import uri=" + wsdl_import.getLocationURI());
                }
                if ((import_def_key = (imported_def = wsdl_import.getDefinition()).getDocumentBaseURI()) == null) {
                    import_def_key = imported_def.getTargetNamespace();
                }
                if (importedDefs.containsKey(import_def_key)) continue;
                importedDefs.put(import_def_key, imported_def);
                WSDL4JImportedWSDLHelper.getImportedDefinitions(imported_def, importedDefs);
            }
        }
    }
}

