/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen.extension;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.axis2.AxisFault;
import org.apache.axis2.description.AxisMessage;
import org.apache.axis2.description.AxisOperation;
import org.apache.axis2.description.AxisService;
import org.apache.axis2.description.Parameter;
import org.apache.axis2.wsdl.WSDLUtil;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.codegen.extension.AbstractCodeGenerationExtension;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.ConfigPropertyFileLoader;
import org.apache.axis2.wsdl.util.MessagePartInformationHolder;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAll;
import org.apache.ws.commons.schema.XmlSchemaAny;
import org.apache.ws.commons.schema.XmlSchemaChoice;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaContentModel;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObjectCollection;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class SchemaUnwrapperExtension
extends AbstractCodeGenerationExtension {
    public void engage(CodeGenConfiguration configuration) throws CodeGenerationException {
        if (!configuration.isParametersWrapped()) {
            if (!ConfigPropertyFileLoader.getUnwrapSupportedFrameworkNames().contains(configuration.getDatabindingType())) {
                throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedforunwrapping"));
            }
            if (!ConfigPropertyFileLoader.getUnwrapDirectFrameworkNames().contains(configuration.getDatabindingType())) {
                AxisService axisService = configuration.getAxisService();
                Iterator operations = axisService.getOperations();
                while (operations.hasNext()) {
                    AxisOperation op = (AxisOperation)operations.next();
                    if (WSDLUtil.isInputPresentForMEP(op.getMessageExchangePattern())) {
                        this.walkSchema(op.getMessage("In"), "_input");
                    }
                    if (!WSDLUtil.isOutputPresentForMEP(op.getMessageExchangePattern())) continue;
                    this.walkSchema(op.getMessage("Out"), "_output");
                }
            }
        }
    }

    public void walkSchema(AxisMessage message, String qnameSuffix) throws CodeGenerationException {
        if (message.getSchemaElement() == null) {
            return;
        }
        LinkedList partNameList = new LinkedList();
        XmlSchemaElement schemaElement = message.getSchemaElement();
        XmlSchemaType schemaType = schemaElement.getSchemaType();
        this.handleAllCasesOfComplexTypes(schemaType, message, partNameList, qnameSuffix);
        try {
            message.addParameter(this.getParameter("UnWrapped", Boolean.TRUE));
            MessagePartInformationHolder infoHolder = new MessagePartInformationHolder();
            infoHolder.setOperationName(((AxisOperation)message.getParent()).getName());
            infoHolder.setPartsList(partNameList);
            message.addParameter(this.getParameter("UnWrapped_details", infoHolder));
        }
        catch (AxisFault axisFault) {
            throw new CodeGenerationException(axisFault);
        }
    }

    private void handleAllCasesOfComplexTypes(XmlSchemaType schemaType, AxisMessage message, List partNameList, String qnameSuffix) throws CodeGenerationException {
        String complexType2 = "";
        if (schemaType instanceof XmlSchemaComplexType) {
            XmlSchemaComplexType cmplxType = (XmlSchemaComplexType)schemaType;
            if (cmplxType.getContentModel() == null) {
                if (cmplxType.getParticle() != null) {
                    this.processXMLSchemaSequence(cmplxType.getParticle(), message, partNameList, qnameSuffix);
                }
            } else {
                this.processComplexContentModel(cmplxType, message, partNameList, qnameSuffix);
            }
        } else {
            throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedSchemaFormat", "unknown", "complexType"));
        }
    }

    private void processComplexContentModel(XmlSchemaComplexType cmplxType, AxisMessage message, List partNameList, String qnameSuffix) throws CodeGenerationException {
        XmlSchemaComplexContent xmlSchemaComplexContent;
        XmlSchemaContent content;
        XmlSchemaContentModel contentModel = cmplxType.getContentModel();
        if (contentModel instanceof XmlSchemaComplexContent && (content = (xmlSchemaComplexContent = (XmlSchemaComplexContent)contentModel).getContent()) instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaComplexContentExtension schemaExtension = (XmlSchemaComplexContentExtension)content;
            if (schemaExtension.getParticle() != null) {
                this.processXMLSchemaSequence(schemaExtension.getParticle(), message, partNameList, qnameSuffix);
            }
            AxisService axisService = (AxisService)message.getParent().getParent();
            ArrayList schemasList = axisService.getSchema();
            XmlSchema parentSchema = null;
            for (int i = 0; i < schemasList.size() || parentSchema == null; ++i) {
                XmlSchema schema = (XmlSchema)schemasList.get(i);
                if (!schema.getTargetNamespace().equals(schemaExtension.getBaseTypeName().getNamespaceURI())) continue;
                parentSchema = schema;
            }
            XmlSchemaType extensionSchemaType = parentSchema.getTypeByName(schemaExtension.getBaseTypeName());
            this.handleAllCasesOfComplexTypes(extensionSchemaType, message, partNameList, qnameSuffix);
        }
    }

    private void processXMLSchemaSequence(XmlSchemaParticle schemaParticle, AxisMessage message, List partNameList, String qnameSuffix) throws CodeGenerationException {
        if (schemaParticle instanceof XmlSchemaSequence) {
            QName opName = ((AxisOperation)message.getParent()).getName();
            XmlSchemaSequence sequence = (XmlSchemaSequence)schemaParticle;
            XmlSchemaObjectCollection items = sequence.getItems();
            if (items.getCount() == 0) {
                return;
            }
            Iterator i = items.getIterator();
            while (i.hasNext()) {
                Object item = i.next();
                if (item instanceof XmlSchemaElement) {
                    String partName = ((XmlSchemaElement)item).getName();
                    partNameList.add(WSDLUtil.getPartQName(opName.getLocalPart(), qnameSuffix, partName));
                    continue;
                }
                if (item instanceof XmlSchemaAny) {
                    XmlSchemaAny xmlSchemaAny = (XmlSchemaAny)item;
                    partNameList.add(WSDLUtil.getPartQName(opName.getLocalPart(), qnameSuffix, "extraElement"));
                    continue;
                }
                throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedSchemaFormat", "unknown type", "Element"));
            }
        } else {
            if (schemaParticle instanceof XmlSchemaChoice) {
                throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedSchemaFormat", "choice", "sequence"));
            }
            if (schemaParticle instanceof XmlSchemaAll) {
                throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedSchemaFormat", "all", "sequence"));
            }
            throw new CodeGenerationException(CodegenMessages.getMessage("extension.unsupportedSchemaFormat", "unknown", "sequence"));
        }
    }

    private Parameter getParameter(String key, Object value) {
        Parameter myParameter = new Parameter();
        myParameter.setName(key);
        myParameter.setValue(value);
        return myParameter;
    }
}

