/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axis2.wsdl.codegen;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.apache.axis2.util.CommandLineOption;
import org.apache.axis2.util.CommandLineOptionConstants;
import org.apache.axis2.wsdl.codegen.CodeGenConfiguration;
import org.apache.axis2.wsdl.i18n.CodegenMessages;

class CodegenConfigLoader
implements CommandLineOptionConstants {
    CodegenConfigLoader() {
    }

    public static void loadConfig(CodeGenConfiguration config2, Map optionMap) {
        String optionValue;
        String value;
        boolean syncFlagPresent;
        String outputLocation = ".";
        CommandLineOption commandLineOption = CodegenConfigLoader.loadOption("o", "output", optionMap);
        if (commandLineOption != null) {
            outputLocation = commandLineOption.getOptionValue();
        }
        File outputLocationFile = new File(outputLocation);
        config2.setOutputLocation(outputLocationFile);
        if (outputLocationFile.exists()) {
            if (outputLocationFile.isFile()) {
                throw new RuntimeException(CodegenMessages.getMessage("options.notADirectoryException"));
            }
        } else {
            outputLocationFile.mkdirs();
        }
        config2.setServerSide(CodegenConfigLoader.loadOption("ss", "server-side", optionMap) != null);
        config2.setGenerateDeployementDescriptor(CodegenConfigLoader.loadOption("sd", "service-description", optionMap) != null);
        config2.setWriteTestCase(CodegenConfigLoader.loadOption("t", "test-case", optionMap) != null);
        boolean asyncFlagPresent = CodegenConfigLoader.loadOption("a", "async", optionMap) != null;
        boolean bl = syncFlagPresent = CodegenConfigLoader.loadOption("s", "sync", optionMap) != null;
        if (asyncFlagPresent) {
            config2.setAsyncOn(true);
            config2.setSyncOn(false);
        }
        if (syncFlagPresent) {
            config2.setAsyncOn(false);
            config2.setSyncOn(true);
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("p", "package", optionMap)) != null) {
            config2.setPackageName(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("l", "language", optionMap)) != null) {
            config2.setOutputLanguage(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("d", "databinding-method", optionMap)) != null) {
            config2.setDatabindingType(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("u", "unpack-classes", optionMap)) != null) {
            config2.setPackClasses(false);
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("S", "source-folder", optionMap)) != null) {
            config2.setSourceLocation(commandLineOption.getOptionValue());
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("R", "resource-folder", optionMap)) != null) {
            config2.setResourceLocation(commandLineOption.getOptionValue());
        }
        config2.setPortName((commandLineOption = CodegenConfigLoader.loadOption("pn", "port-name", optionMap)) != null ? commandLineOption.getOptionValue() : null);
        commandLineOption = CodegenConfigLoader.loadOption("sn", "service-name", optionMap);
        config2.setServiceName(commandLineOption != null ? commandLineOption.getOptionValue() : null);
        commandLineOption = CodegenConfigLoader.loadOption("r", "repository-path", optionMap);
        config2.setRepositoryPath(commandLineOption != null ? commandLineOption.getOptionValue() : null);
        config2.setServerSideInterface(CodegenConfigLoader.loadOption("ssi", "serverside-interface", optionMap) != null);
        config2.setGenerateAll(CodegenConfigLoader.loadOption("g", "generate-all", optionMap) != null);
        commandLineOption = CodegenConfigLoader.loadOption("em", "external-mapping", optionMap);
        if (commandLineOption != null) {
            try {
                config2.setTypeMappingFile(new File(commandLineOption.getOptionValue()));
            }
            catch (Exception e) {
                throw new RuntimeException(CodegenMessages.getMessage("options.nomappingFile"), e);
            }
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("ns2p", "namespace2package", optionMap)) != null && (value = commandLineOption.getOptionValue()) != null) {
            if (value.indexOf(61) != -1) {
                String[] valuepairs = value.split(",");
                if (valuepairs.length > 0) {
                    HashMap<String, String> map = new HashMap<String, String>(valuepairs.length);
                    for (int i = 0; i < valuepairs.length; ++i) {
                        String[] values = valuepairs[i].split("=");
                        if (values.length != 2) continue;
                        map.put(values[0], values[1]);
                    }
                    config2.setUri2PackageNameMap(map);
                }
            } else {
                try {
                    Properties p = new Properties();
                    p.load(new FileInputStream(value));
                    config2.setUri2PackageNameMap(p);
                }
                catch (IOException e) {
                    throw new RuntimeException(CodegenMessages.getMessage("options.noFile", value), e);
                }
            }
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("uw", "unwrap-params", optionMap)) != null) {
            config2.setParametersWrapped(false);
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("wv", "wsdl-version", optionMap)) != null && ("2.0".equals(optionValue = commandLineOption.getOptionValue()) || "2".equals(optionValue))) {
            config2.setWSDLVersion("2.0");
        }
        config2.setFlattenFiles(CodegenConfigLoader.loadOption("f", "flatten-files", optionMap) != null);
        commandLineOption = CodegenConfigLoader.loadOption("b", "backword-compatible", optionMap);
        if (commandLineOption != null) {
            config2.setBackwordCompatibilityMode(true);
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("sp", "suppress-prefixes", optionMap)) != null) {
            config2.setSuppressPrefixesMode(true);
        }
        if ((commandLineOption = CodegenConfigLoader.loadOption("xc", "xsdconfig", optionMap)) != null) {
            config2.setXsdConfigFile(commandLineOption.getOptionValue());
        }
        Iterator keyIterator = optionMap.keySet().iterator();
        while (keyIterator.hasNext()) {
            Object key = keyIterator.next();
            CommandLineOption option = (CommandLineOption)optionMap.get(key);
            if (!key.toString().startsWith("E")) continue;
            config2.getProperties().put(key.toString().replaceFirst("E", ""), option.getOptionValue());
        }
    }

    private static CommandLineOption loadOption(String shortOption, String longOption, Map options) {
        CommandLineOption option = null;
        if (longOption != null && (option = (CommandLineOption)options.get(longOption)) != null) {
            return option;
        }
        if (shortOption != null) {
            option = (CommandLineOption)options.get(shortOption);
        }
        return option;
    }
}

